/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.module.view.ejb.moduleLevel.viewlets;

import com.intellij.facet.impl.ui.FacetEditorContextBase;
import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.ejb.facet.EjbFacet;
import com.intellij.javaee.ejb.facet.EjbFacetConfigurationImpl;
import com.intellij.javaee.module.view.SourceRootsSelectorConfigurable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBox;

public class EjbRootsConfigurable
extends SourceRootsSelectorConfigurable {
    private static final Key<SharedEjbRootsInfo> EJB_ROOTS_KEY = Key.create((String)"EJB_FACET_ROOTS");
    private final EjbFacetConfigurationImpl myConfiguration;
    private SharedEjbRootsInfo myRootsInfo;

    public EjbRootsConfigurable(EjbFacetConfigurationImpl configuration, FacetEditorContext context) {
        super(context, J2EEBundle.message((String)"label.ejb.roots.text", (Object[])new Object[0]));
        this.myConfiguration = configuration;
        this.updateRootsList();
        this.initRootsInfo(context);
        this.updateOccupiedRootsList();
    }

    private void initRootsInfo(FacetEditorContext context) {
        UserDataHolder sharedData = ((FacetEditorContextBase)context).getSharedModuleData();
        this.myRootsInfo = (SharedEjbRootsInfo)sharedData.getUserData(EJB_ROOTS_KEY);
        if (this.myRootsInfo == null) {
            this.myRootsInfo = new SharedEjbRootsInfo();
            sharedData.putUserData(EJB_ROOTS_KEY, (Object)this.myRootsInfo);
        }
        Module module = context.getModule();
        Collection ejbFacets = context.getFacetsProvider().getFacetsByType(module, EjbFacet.ID);
        for (EjbFacet ejbFacet : ejbFacets) {
            EjbFacetConfigurationImpl facetConfiguration = (EjbFacetConfigurationImpl)ejbFacet.getConfiguration();
            for (String url : facetConfiguration.getSourceRoots()) {
                this.myRootsInfo.myUrl2Facet.put(url, facetConfiguration);
            }
        }
        this.myRootsInfo.myListeners.add(() -> this.updateOccupiedRootsList());
        if (context.isNewFacet()) {
            ArrayList<String> roots = new ArrayList<String>();
            for (String url : this.myUrl2CheckBox.keySet()) {
                if (this.myRootsInfo.myUrl2Facet.containsKey(url)) continue;
                roots.add(url);
            }
            this.myConfiguration.setSourceRoots(roots);
            this.myRootsInfo.onChange();
        }
    }

    @Override
    protected List<String> getSourceRootsConfiguration() {
        return this.myConfiguration.getSourceRoots();
    }

    public void apply() {
        this.myConfiguration.setSourceRoots(this.getConfiguredRoots());
    }

    @Override
    protected void updateOccupiedRootsList() {
        for (Map.Entry entry : this.myUrl2CheckBox.entrySet()) {
            EjbFacetConfigurationImpl configuration = (EjbFacetConfigurationImpl)this.myRootsInfo.myUrl2Facet.get(entry.getKey());
            ((JCheckBox)entry.getValue()).setEnabled(configuration == null || configuration == this.myConfiguration);
        }
    }

    @Override
    protected void onCheckboxActionPerformed(JCheckBox checkBox, String url) {
        if (checkBox.isSelected()) {
            this.myRootsInfo.myUrl2Facet.put(url, this.myConfiguration);
        } else {
            this.myRootsInfo.myUrl2Facet.remove(url);
        }
        this.myRootsInfo.onChange();
    }

    private static class SharedEjbRootsInfo {
        private final List<Runnable> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        private final Map<String, EjbFacetConfigurationImpl> myUrl2Facet = new HashMap<String, EjbFacetConfigurationImpl>();

        private SharedEjbRootsInfo() {
        }

        public void onChange() {
            for (Runnable listener : this.myListeners) {
                listener.run();
            }
        }
    }
}

