/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.run.execution.update;

import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.j2ee.openapi.ex.DeploymentManagerEx;
import com.intellij.javaee.J2EEBundle;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSettings;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.deployment.ExternalFileDeploymentSource;
import com.intellij.javaee.run.configuration.CommonModel;
import com.intellij.javaee.run.configuration.CommonStrategy;
import com.intellij.javaee.run.execution.update.UpdatingPolicy;
import com.intellij.javaee.run.execution.update.UpdatingRunningApplicationUtil;
import com.intellij.javaee.serverInstances.J2EEServerInstance;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedeployArtifactsUpdatingPolicy
extends UpdatingPolicy {
    public RedeployArtifactsUpdatingPolicy() {
        super("redeploy-artifacts");
    }

    @Override
    public String getDescription() {
        return J2EEBundle.message((String)"updating.policy.redeploy", (Object[])new Object[0]);
    }

    @Override
    public boolean isAvailableForConfiguration(@NotNull CommonModel commonModel) {
        if (commonModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commonModel", "com/intellij/javaee/run/execution/update/RedeployArtifactsUpdatingPolicy", "isAvailableForConfiguration"));
        }
        DeploymentSettings deploymentSettings = commonModel.getDeploymentSettings();
        return deploymentSettings != null && !deploymentSettings.getDeploymentModels().isEmpty();
    }

    @Override
    public void runUpdate(@NotNull Project project, @Nullable Executor executor, @NotNull J2EEServerInstance serverInstance, @NotNull ProcessHandler processHandler, boolean onFrameDeactivation) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/RedeployArtifactsUpdatingPolicy", "runUpdate"));
        }
        if (serverInstance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/run/execution/update/RedeployArtifactsUpdatingPolicy", "runUpdate"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/intellij/javaee/run/execution/update/RedeployArtifactsUpdatingPolicy", "runUpdate"));
        }
        for (DeploymentModel deploymentModel : serverInstance.getCommonModel().getDeploymentModels()) {
            DeploymentSource deploymentSource = deploymentModel.getDeploymentSource();
            if (!(deploymentSource instanceof ExternalFileDeploymentSource)) continue;
            ((CommonStrategy)serverInstance.getCommonModel()).getDeploymentProvider().doDeploy(project, serverInstance, deploymentModel);
        }
        List artifacts = serverInstance.getCommonModel().getDeployedArtifacts();
        Runnable deployRunnable = () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javaee/run/execution/update/RedeployArtifactsUpdatingPolicy", "lambda$runUpdate$0"));
            }
            if (serverInstance == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverInstance", "com/intellij/javaee/run/execution/update/RedeployArtifactsUpdatingPolicy", "lambda$runUpdate$0"));
            }
            DeploymentManagerEx.getInstanceEx(project).deployArtifactsWithoutCompilation(serverInstance, artifacts);
        };
        HotSwapUI.getInstance((Project)project).dontPerformHotswapAfterThisCompilation();
        ExecutionManager.getInstance((Project)project).compileAndRun(deployRunnable, new ExecutionEnvironmentBuilder(project, UpdatingRunningApplicationUtil.getExecutor(project, processHandler)).runProfile((RunProfile)serverInstance.getCommonModel()).build(), null, null);
    }
}

