/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.generation;

import com.intellij.ide.util.PackageUtil;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.javaee.JavaeeUtil;
import com.intellij.javaee.model.common.persistence.mapping.RelationAttributeBase;
import com.intellij.javaee.model.xml.persistence.PersistenceUnit;
import com.intellij.javaee.model.xml.persistence.mapping.AccessType;
import com.intellij.javaee.model.xml.persistence.mapping.AttributeBase;
import com.intellij.javaee.model.xml.persistence.mapping.AttributeWithColumn;
import com.intellij.javaee.model.xml.persistence.mapping.Basic;
import com.intellij.javaee.model.xml.persistence.mapping.CascadeType;
import com.intellij.javaee.model.xml.persistence.mapping.Column;
import com.intellij.javaee.model.xml.persistence.mapping.ColumnResult;
import com.intellij.javaee.model.xml.persistence.mapping.DiscriminatorType;
import com.intellij.javaee.model.xml.persistence.mapping.Embeddable;
import com.intellij.javaee.model.xml.persistence.mapping.Embedded;
import com.intellij.javaee.model.xml.persistence.mapping.Entity;
import com.intellij.javaee.model.xml.persistence.mapping.EntityMappings;
import com.intellij.javaee.model.xml.persistence.mapping.EntityResult;
import com.intellij.javaee.model.xml.persistence.mapping.FetchType;
import com.intellij.javaee.model.xml.persistence.mapping.GenerationType;
import com.intellij.javaee.model.xml.persistence.mapping.Id;
import com.intellij.javaee.model.xml.persistence.mapping.InheritanceType;
import com.intellij.javaee.model.xml.persistence.mapping.JoinColumn;
import com.intellij.javaee.model.xml.persistence.mapping.JoinTable;
import com.intellij.javaee.model.xml.persistence.mapping.ManyToMany;
import com.intellij.javaee.model.xml.persistence.mapping.ManyToOne;
import com.intellij.javaee.model.xml.persistence.mapping.NamedNativeQuery;
import com.intellij.javaee.model.xml.persistence.mapping.NamedQuery;
import com.intellij.javaee.model.xml.persistence.mapping.OneToMany;
import com.intellij.javaee.model.xml.persistence.mapping.PersistentObjectBase;
import com.intellij.javaee.model.xml.persistence.mapping.PrimaryKeyJoinColumn;
import com.intellij.javaee.model.xml.persistence.mapping.QueryHint;
import com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase;
import com.intellij.javaee.model.xml.persistence.mapping.SecondaryTable;
import com.intellij.javaee.model.xml.persistence.mapping.SqlResultSetMapping;
import com.intellij.javaee.model.xml.persistence.mapping.Temporal;
import com.intellij.javaee.model.xml.persistence.mapping.UniqueConstraint;
import com.intellij.javaee.model.xml.persistence.mapping.Version;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.facet.JpaFacet;
import com.intellij.jpa.generation.JpaMappingGenerator;
import com.intellij.jpa.generation.ORMToAnnotationsConverter;
import com.intellij.jpa.generation.ui.ImportMappingsDialog;
import com.intellij.jpa.model.annotations.mapping.JamEntityMappings;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.persistence.PersistenceDataKeys;
import com.intellij.persistence.PersistenceHelper;
import com.intellij.persistence.facet.PersistenceFacet;
import com.intellij.persistence.model.PersistenceMappings;
import com.intellij.persistence.model.PersistencePackage;
import com.intellij.persistence.model.PersistentEntityBase;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.Function;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.GenericValueUtil;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.ui.CaptionComponent;
import gnu.trove.THashMap;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class HibernateImporter
implements JpaMappingGenerator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.jpa.generation.HibernateImporter");
    public static final String CONFIGURATION_ROOT = "hibernate-configuration";
    public static final String MAPPING_ROOT = "hibernate-mapping";
    private static final HashMap<String, String> HIBERNATE_TYPES_MAP = new HashMap();
    private ImportMappingsDialog myDialog;
    private PersistenceFacet myFacet;
    private XmlFile myFile;
    private final THashMap<String, PsiDirectory> myDirectories = new THashMap();
    private Trinity<PersistenceUnit, EntityMappings, PersistenceUnit> myMocks;

    public HibernateImporter() {
    }

    public HibernateImporter(PersistenceFacet facet, XmlFile file) {
        this.myFacet = facet;
        this.myFile = file;
    }

    @Override
    public String getTitle() {
        return JpaMessages.message((String)"action.name.generate.persistence.unit.by.hibernate.mappings", (Object[])new Object[0]);
    }

    @Override
    public JpaMappingGenerator clone() {
        return new HibernateImporter();
    }

    @Override
    public boolean beforeGenerate(DataContext dataContext) {
        this.myFacet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.getData(dataContext);
        this.myDialog = new ImportMappingsDialog(this.myFacet, unit != null ? (String)unit.getName().getValue() : null){

            @Override
            public void setupTargetControls(JLabel targetLabel, final TextFieldWithBrowseButton targetComponent, CaptionComponent captionComponent) {
                this.setTitle(JpaMessages.message((String)"dialog.title.import.hibernate.mappings", (Object[])new Object[0]));
                targetLabel.setText(JpaMessages.message((String)"label.title.choose.hibernate.xml", (Object[])new Object[0]));
                captionComponent.setText(JpaMessages.message((String)"caption.hibernate.import.text", (Object[])new Object[0]));
                captionComponent.setDescriptionText(JpaMessages.message((String)"caption.hibernate.import.description", (Object[])new Object[0]));
                targetComponent.getTextField().setEditable(false);
                targetComponent.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false){

                            public boolean isFileVisible(VirtualFile file, boolean showHiddenFiles) {
                                if (file.isDirectory()) {
                                    return true;
                                }
                                if (!file.getFileType().equals(StdFileTypes.XML)) {
                                    return false;
                                }
                                PsiFile xmlFile = PsiManager.getInstance((Project)HibernateImporter.this.getProject()).findFile(file);
                                String tagNS = JavaeeUtil.getRootTagNS(xmlFile, HibernateImporter.CONFIGURATION_ROOT);
                                if (tagNS != null && (tagNS.isEmpty() || tagNS.contains(HibernateImporter.CONFIGURATION_ROOT))) {
                                    return true;
                                }
                                tagNS = JavaeeUtil.getRootTagNS(xmlFile, HibernateImporter.MAPPING_ROOT);
                                return tagNS != null && (tagNS.isEmpty() || tagNS.contains(HibernateImporter.MAPPING_ROOT));
                            }
                        };
                        descriptor.setRoots(ContainerUtil.concat((Iterable)ContainerUtil.map((Object[])ModuleManager.getInstance((Project)HibernateImporter.this.getProject()).getModules(), (Function)new Function<Module, List<VirtualFile>>(){

                            public List<VirtualFile> fun(Module module) {
                                return Arrays.asList(ModuleRootManager.getInstance((Module)module).getContentRoots());
                            }
                        })));
                        descriptor.putUserData(LangDataKeys.MODULE_CONTEXT, (Object)HibernateImporter.this.myFacet.getModule());
                        descriptor.setTitle(JpaMessages.message((String)"title.choose.hibernate.xml", (Object[])new Object[0]));
                        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)HibernateImporter.this.getProject(), null);
                        if (file != null) {
                            HibernateImporter.this.myFile = (XmlFile)PsiManager.getInstance((Project)HibernateImporter.this.getProject()).findFile(file);
                            targetComponent.getTextField().setText(file.getPath());
                        }
                    }
                });
            }
        };
        this.myDialog.show();
        if (this.myDialog.getExitCode() != 0) {
            return false;
        }
        if (ModelMergerUtil.getImplementation((Object)this.getPersistenceMappings(), JamEntityMappings.class) != null) {
            ORMToAnnotationsConverter.ensureJpaApiLibraryExists(this.myFacet.getModule());
        }
        this.myMocks = this.createMockMappings((PersistenceUnit)this.myDialog.getPersistenceUnit(), this.myFacet);
        if (this.myMocks == null) {
            return false;
        }
        return this.ensurePackagesAreCreated((EntityMappings)this.myMocks.second);
    }

    private Project getProject() {
        return this.myFacet.getModule().getProject();
    }

    @Override
    public boolean isAvailableOnDataContext(DataContext dataContext) {
        PersistenceFacet facet = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET.getData(dataContext);
        PersistenceFacet facetContext = (PersistenceFacet)PersistenceDataKeys.PERSISTENCE_FACET_CONTEXT.getData(dataContext);
        PersistencePackage unit = (PersistencePackage)PersistenceDataKeys.PERSISTENCE_UNIT_CONTEXT.getData(dataContext);
        if (facet == null || facetContext == null && unit == null) {
            return false;
        }
        if (unit != null && JamCommonUtil.isInLibrary((CommonModelElement)unit)) {
            return false;
        }
        return facet instanceof JpaFacet;
    }

    public void addAffectedElements(EntityMappings newMappings, Collection<PsiElement> result) {
        ContainerUtil.addIfNotNull(result, (Object)this.getPersistenceUnit().getIdentifyingPsiElement());
        for (PersistenceMappings mappings : ModelMergerUtil.getFilteredImplementations((Object)this.getPersistenceMappings())) {
            ContainerUtil.addIfNotNull(result, (Object)mappings.getIdentifyingPsiElement());
        }
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        GlobalSearchScope scope = GlobalSearchScope.moduleScope((Module)this.myFacet.getModule());
        for (PersistentObject object : PersistenceCommonUtil.queryPersistentObjects((PersistenceMappings)newMappings)) {
            String classNamePK;
            String className = this.getNewClassName(object.getClazz().getStringValue());
            if (className != null) {
                ContainerUtil.addIfNotNull(result, (Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(className, scope));
            }
            if (!(object instanceof PersistentEntityBase) || (classNamePK = this.getNewClassName(((PersistentEntityBase)object).getIdClassValue().getStringValue())) == null) continue;
            ContainerUtil.addIfNotNull(result, (Object)JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass(classNamePK, scope));
        }
    }

    protected PersistenceMappings getPersistenceMappings() {
        return this.myDialog.getPersistenceMapping();
    }

    protected PersistencePackage getPersistenceUnit() {
        return this.myDialog.getPersistenceUnit();
    }

    protected String getPackageName() {
        return this.myDialog.getPackageName();
    }

    protected String getEntityNameSuffix() {
        return this.myDialog.getEntityNameSuffix();
    }

    protected String getEntityNamePrefix() {
        return this.myDialog.getEntityNamePrefix();
    }

    public boolean ensurePackagesAreCreated(EntityMappings mappings) {
        for (PersistentObject object : JpaUtil.getPersistentObjects((PersistenceMappings)mappings)) {
            String packageName;
            String fqName = this.getQualifiedName(object.getClazz().getStringValue());
            if (fqName == null || this.myDirectories.containsKey((Object)(packageName = StringUtil.getPackageName((String)fqName)))) continue;
            try {
                PsiDirectory directory = PackageUtil.findOrCreateDirectoryForPackage((Module)this.myFacet.getModule(), (String)packageName, null, (boolean)false);
                if (directory == null) {
                    return false;
                }
                this.myDirectories.put((Object)packageName, (Object)directory);
            }
            catch (IncorrectOperationException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public VirtualFile[] generate() {
        VirtualFile[] virtualFileArray;
        VirtualFile unitFile;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            this.myMocks = this.createMockMappings((PersistenceUnit)this.getPersistenceUnit(), this.myFacet);
        }
        assert (this.myFacet != null && this.myFile != null && this.myMocks != null);
        PersistenceUnit unit = (PersistenceUnit)this.myMocks.third;
        EntityMappings mockMappings = (EntityMappings)this.myMocks.second;
        PersistenceUnit mockUnit = (PersistenceUnit)this.myMocks.first;
        PersistenceMappings mappings = this.getPersistenceMappings();
        ArrayList affectedElements = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> this.addAffectedElements(mockMappings, affectedElements));
        Ref indicatorRef = Ref.create(null);
        PersistenceHelper.getHelper().runCompositeWriteCommandAction(this.getProject(), JpaMessages.message((String)"command.generate.persistence.mappings", (Object[])new Object[]{this.getTitle()}), affectedElements, indicatorRef, new Runnable[]{() -> {
            try {
                if (!this.ensurePackagesAreCreated(mockMappings)) {
                    return;
                }
                new ORMToAnnotationsConverter(this.myFacet.getModule()).createMissingClassesAndFields(Collections.singletonList(mockMappings));
                if (unit != mockUnit) {
                    unit.copyFrom((DomElement)mockUnit);
                }
                for (PersistenceMappings persistenceMappings : ModelMergerUtil.getFilteredImplementations((Object)mappings)) {
                    if (persistenceMappings instanceof EntityMappings) {
                        ((EntityMappings)persistenceMappings).copyFrom((DomElement)mockMappings);
                    } else if (persistenceMappings instanceof JamEntityMappings) {
                        ORMToAnnotationsConverter.ensureJpaApiLibraryExists(this.myFacet.getModule());
                        new ORMToAnnotationsConverter(this.myFacet.getModule()).migrateORM(Collections.singletonList(mockMappings));
                    }
                    JpaUtil.ensureMappingsIncluded(unit, persistenceMappings);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }});
        PsiFile containingFile = unit.getContainingFile();
        VirtualFile virtualFile = unitFile = containingFile == null ? null : containingFile.getVirtualFile();
        if (unitFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = unitFile;
        }
        return virtualFileArray;
    }

    @Nullable
    private Trinity<PersistenceUnit, EntityMappings, PersistenceUnit> createMockMappings(final PersistenceUnit unit, PersistenceFacet facet) {
        final EntityMappings mockMappings = (EntityMappings)DomManager.getDomManager((Project)this.getProject()).createMockElement(EntityMappings.class, this.myFacet.getModule(), false);
        String version = JpaUtil.getJpaVersion((JpaFacet)facet).getValue();
        mockMappings.getVersion().setValue((Object)version);
        final PersistenceUnit mockUnit = DomManager.getDomManager((Project)this.getProject()).isMockElement((DomElement)unit) ? unit : (PersistenceUnit)DomManager.getDomManager((Project)this.getProject()).createMockElement(PersistenceUnit.class, this.myFacet.getModule(), false);
        final Ref result = Ref.create((Object)Boolean.FALSE);
        new WriteCommandAction.Simple(this.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                result.set((Object)HibernateImporter.this.setupMockUnit(unit, mockMappings, mockUnit));
            }
        }.execute();
        if (!((Boolean)result.get()).booleanValue()) {
            return null;
        }
        return Trinity.create((Object)mockUnit, (Object)mockMappings, (Object)unit);
    }

    private boolean setupMockUnit(PersistenceUnit unit, EntityMappings mockMappings, PersistenceUnit mockUnit) {
        if (mockUnit != unit) {
            mockUnit.copyFrom((DomElement)unit);
        }
        mockMappings.getPackage().setStringValue(this.getPackageName());
        try {
            if (JavaeeUtil.getRootTagNS((PsiFile)this.myFile, CONFIGURATION_ROOT) != null) {
                this.importHibernateConfig(mockUnit, mockMappings, this.myFile);
            } else if (JavaeeUtil.getRootTagNS((PsiFile)this.myFile, MAPPING_ROOT) != null) {
                this.importHibernateMappings(mockUnit, mockMappings, Collections.singletonList(this.myFile), Collections.emptyList());
            }
        }
        catch (JDOMException e) {
            ApplicationManager.getApplication().invokeLater(() -> Messages.showErrorDialog((Project)this.getProject(), (String)StringUtil.getThrowableText((Throwable)e, (String)"com.intellij."), (String)JpaMessages.message((String)"dialog.title.import.hibernate.mappings", (Object[])new Object[0])), ModalityState.NON_MODAL);
            return false;
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            return false;
        }
        return true;
    }

    @Nullable
    private String getNewClassName(String className) {
        return this.getNewClassName(className, this.getEntityNamePrefix(), this.getEntityNameSuffix());
    }

    @Nullable
    private String getNewClassName(String className, String prefix, String suffix) {
        return StringUtil.isEmpty((String)className) ? null : this.getQualifiedName(prefix + PsiNameHelper.getShortClassName((String)className) + suffix);
    }

    private String getQualifiedName(String type) {
        String packageName = this.getPackageName();
        return packageName.length() > 0 ? packageName + '.' + type : type;
    }

    private void importHibernateConfig(PersistenceUnit unit, EntityMappings mockMappings, XmlFile hibernateConfigFile) throws Exception {
        SAXBuilder builder = new SAXBuilder();
        Document doc = builder.build((Reader)new StringReader(hibernateConfigFile.getText()));
        ArrayList<XmlFile> xmlFiles = new ArrayList<XmlFile>();
        ArrayList<File> otherFiles = new ArrayList<File>();
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        List mappingList = doc.getRootElement().getChild("session-factory").getChildren("mapping");
        for (Element e : mappingList) {
            XmlFile xmlFile;
            String str = e.getAttributeValue("resource");
            if (str != null) {
                XmlFile resource;
                VirtualFile resourceVF = JavaeeUtil.findResource(ModuleUtil.findModuleForPsiElement((PsiElement)hibernateConfigFile), str);
                PsiFile resourcePsi = resourceVF == null ? null : PsiManager.getInstance((Project)this.getProject()).findFile(resourceVF);
                XmlFile xmlFile2 = resource = resourcePsi instanceof XmlFile ? (XmlFile)resourcePsi : null;
                if (resource == null) {
                    LOG.warn("resource not found: " + str);
                    continue;
                }
                xmlFiles.add(resource);
                continue;
            }
            str = e.getAttributeValue("file");
            if (str == null) continue;
            File file = new File(str);
            if (!file.isAbsolute()) {
                file = new File(VfsUtil.virtualToIoFile((VirtualFile)hibernateConfigFile.getVirtualFile().getParent()), str).getCanonicalFile();
            }
            if (!file.exists()) {
                LOG.warn("external file doesn't exist: " + file);
                continue;
            }
            VirtualFile virtualFile = VfsUtil.findFileByURL((URL)file.toURL());
            PsiFile psiFile = psiManager.findFile(virtualFile);
            XmlFile xmlFile3 = xmlFile = psiFile instanceof XmlFile ? (XmlFile)psiFile : null;
            if (xmlFile != null) {
                xmlFiles.add(xmlFile);
                continue;
            }
            otherFiles.add(file);
        }
        if (!this.importHibernateMappings(unit, mockMappings, xmlFiles, otherFiles)) {
            return;
        }
        List propertyList = doc.getRootElement().getChild("session-factory").getChildren("property");
        for (String str : propertyList) {
        }
        for (Element e : mappingList) {
            String str = e.getAttributeValue("jar");
            if (str != null) {
                PsiFile file;
                VirtualFile jar = hibernateConfigFile.getVirtualFile().getParent().findFileByRelativePath(str);
                if (jar == null || (file = psiManager.findFile(jar)) == null) {
                    LOG.warn("jar file not found: " + str);
                    continue;
                }
                if (GenericValueUtil.containsValue((Collection)unit.getJarFiles(), (Object)file)) continue;
                unit.addJarFile().setValue((Object)file);
                continue;
            }
            str = e.getAttributeValue("package");
            if (str != null) {
                PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.getProject()).findPackage(str);
                if (psiPackage == null) {
                    LOG.warn("package not found: " + str);
                    continue;
                }
                List classes = unit.getClasses();
                for (PsiClass o : psiPackage.getClasses()) {
                    String className = o.getQualifiedName();
                    if (GenericValueUtil.containsString((Collection)classes, (String)className)) continue;
                    unit.addClass().setStringValue(className);
                }
                continue;
            }
            str = e.getAttributeValue("class");
            if (str == null || GenericValueUtil.containsString((Collection)unit.getClasses(), (String)str)) continue;
            unit.addClass().setStringValue(str);
        }
    }

    private boolean importHibernateMappings(PersistenceUnit unit, EntityMappings mappings, List<XmlFile> xmlFiles, List<File> otherFiles) throws Exception {
        for (File file : otherFiles) {
            this.importHibernateMapping(unit, mappings, new CharArrayReader(FileUtil.loadFileText((File)file)));
        }
        for (XmlFile xmlFile : xmlFiles) {
            this.importHibernateMapping(unit, mappings, new StringReader(VfsUtil.loadText((VirtualFile)xmlFile.getVirtualFile())));
        }
        return true;
    }

    private static String getClassQName(MappingInfo info, String className) {
        String s = info.imports.get(className);
        if (s != null) {
            return s;
        }
        String pkg = info.entityMappings.getPackage().getStringValue();
        return HibernateImporter.getClassQName(className, pkg);
    }

    private static String getClassQName(String className, String packageName) {
        if (className != null && className.indexOf(46) < 0 && packageName != null && packageName.length() > 0) {
            return packageName + "." + className;
        }
        return className;
    }

    private static String getClassShortName(MappingInfo info, String className) {
        String pkg = info.entityMappings.getPackage().getStringValue();
        if (pkg != null && className.length() > pkg.length() + 1 && className.startsWith(pkg) && className.charAt(pkg.length()) == '.') {
            return className.substring(pkg.length() + 1);
        }
        return className;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importHibernateMapping(PersistenceUnit persistenceUnit, @NotNull EntityMappings entityMappings, @NotNull Reader hibernateMappingFile) throws Exception {
        String name;
        if (entityMappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entityMappings", "com/intellij/jpa/generation/HibernateImporter", "importHibernateMapping"));
        }
        if (hibernateMappingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hibernateMappingFile", "com/intellij/jpa/generation/HibernateImporter", "importHibernateMapping"));
        }
        SAXBuilder builder = new SAXBuilder();
        Document doc = null;
        try {
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return new InputSource(new ByteArrayInputStream(new byte[0]));
                }
            });
            doc = builder.build(hibernateMappingFile);
        }
        finally {
            hibernateMappingFile.close();
        }
        Element hibernateMappingElement = doc.getRootElement();
        MappingInfo info = new MappingInfo();
        info.module = this.myFacet.getModule();
        info.entityMappings = entityMappings;
        info.persistenceUnit = persistenceUnit;
        this.buildExternalMappings(info);
        String str = hibernateMappingElement.getAttributeValue("schema");
        if (str != null) {
            info.entityMappings.getSchema().setValue((Object)str);
        }
        if ((str = hibernateMappingElement.getAttributeValue("catalog")) != null) {
            info.entityMappings.getSchema().setValue((Object)str);
        }
        if ((str = hibernateMappingElement.getAttributeValue("default-access")) != null) {
            AccessType accessType = str.equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
            info.entityMappings.getAccess().setValue((Object)accessType);
        }
        if ((str = hibernateMappingElement.getAttributeValue("package")) != null) {
            entityMappings.getPackage().setStringValue(this.getPackageName());
        }
        if ((str = hibernateMappingElement.getAttributeValue("default-cascade")) != null) {
            info.defaultCascade = HibernateImporter.parseCascades(str, (CascadeType)DomManager.getDomManager((Project)this.getProject()).createMockElement(CascadeType.class, info.module, false));
        }
        info.defaultLazy = hibernateMappingElement.getAttributeValue("default-lazy", (String)null);
        for (Element e : doc.getRootElement().getChildren("import")) {
            String qname = e.getAttributeValue("class");
            String name2 = e.getAttributeValue("rename");
            info.imports.put(name2, qname);
        }
        for (Element e : doc.getRootElement().getChildren("query")) {
            name = e.getAttributeValue("name");
            info.queries.put(name, e);
        }
        for (Element e : doc.getRootElement().getChildren("sql-query")) {
            name = e.getAttributeValue("name");
            info.sqlQueries.put(name, e);
        }
        for (Element e : doc.getRootElement().getChildren("resultset")) {
            name = e.getAttributeValue("name");
            info.resultSets.put(name, e);
        }
        for (Element e : doc.getRootElement().getChildren("class")) {
            this.processClass(info, e);
        }
        for (Element e : doc.getRootElement().getChildren("subclass")) {
            if (!this.ensureInheritanceType(info, e.getChildText("extends"), InheritanceType.SINGLE_TABLE)) continue;
            this.processSubclass(info, e);
        }
        for (Element e : doc.getRootElement().getChildren("joined-subclass")) {
            if (!this.ensureInheritanceType(info, e.getChildText("extends"), InheritanceType.JOINED)) continue;
            this.processJoinedSubclass(info, e);
        }
        for (Element e : doc.getRootElement().getChildren("joined-subclass")) {
            if (!this.ensureInheritanceType(info, e.getChildText("extends"), InheritanceType.TABLE_PER_CLASS)) continue;
            this.processUnionSubclass(info, e);
        }
        this.resolveRelationships(info);
        return true;
    }

    private void resolveRelationships(MappingInfo info) {
        for (Map.Entry<com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase, Pair<Element, Element>> entry : info.relationAttributeMap.entrySet()) {
            Entity targetEntity;
            String str;
            com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase property = entry.getKey();
            Element propertyElement = (Element)entry.getValue().getFirst();
            Element relationElement = (Element)entry.getValue().getSecond();
            boolean many = property instanceof ManyToOne || property instanceof ManyToMany;
            boolean inverse = property instanceof ManyToMany && (str = propertyElement.getAttributeValue("inverse")) != null ? Boolean.parseBoolean(str) : false;
            Ref targetAttribute = new Ref();
            String targetEntityClassName = this.getNewClassName(HibernateImporter.getClassQName(info, property.getTargetEntityClass().getStringValue()));
            Entity entity = targetEntity = targetEntityClassName == null ? null : this.findEntityByName(info, targetEntityClassName, true);
            if (targetEntity != null) {
                String thisEntityName = JpaUtil.getQualifiedName((PersistentObject)property.getParentOfType(PersistentObjectBase.class, true));
                for (com.intellij.javaee.model.common.persistence.mapping.AttributeBase attribute : targetEntity.getAllAttributes()) {
                    if (!(attribute instanceof RelationAttributeBase)) continue;
                    RelationAttributeBase targetProperty = (RelationAttributeBase)attribute;
                    String targetTargetEntityClassName = targetProperty.getTargetEntityClass().getStringValue();
                    if (many != targetProperty instanceof RelationAttributeBase.AnyToManyBase || targetTargetEntityClassName == null || !thisEntityName.equals(this.getNewClassName(HibernateImporter.getClassQName(info, targetTargetEntityClassName)))) continue;
                    if (!(targetProperty instanceof RelationAttributeBase.NonManyToOneBase)) {
                        ((RelationAttributeBase.NonManyToOneBase)property).getMappedBy().setStringValue((String)targetProperty.getName().getValue());
                    } else if (!(property instanceof RelationAttributeBase.NonManyToOneBase)) {
                        ((RelationAttributeBase.NonManyToOneBase)targetProperty).getMappedBy().setStringValue((String)property.getName().getValue());
                    } else if (inverse) {
                        ((RelationAttributeBase.NonManyToOneBase)property).getMappedBy().setStringValue((String)targetProperty.getName().getValue());
                    } else {
                        ((RelationAttributeBase.NonManyToOneBase)targetProperty).getMappedBy().setStringValue((String)property.getName().getValue());
                    }
                    if (targetAttribute == null) break;
                    targetAttribute.set((Object)((com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase)targetProperty));
                    break;
                }
                if (property instanceof RelationAttributeBase.AnyToManyBase && (str = propertyElement.getAttributeValue("order-by")) != null) {
                    ((RelationAttributeBase.AnyToManyBase)property).getOrderBy().setValue((Object)this.convertOrderBy(targetEntity, str));
                }
            }
            this.processJoinParametersForAttribute(property, (com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase)targetAttribute.get(), inverse, propertyElement, relationElement);
        }
    }

    private boolean ensureInheritanceType(MappingInfo info, String extendsStr, InheritanceType inheritanceType) {
        if (extendsStr == null || extendsStr.length() == 0) {
            LOG.warn("superclass should be specified");
            return false;
        }
        Entity entity = this.findEntityByName(extendsStr = this.getNewClassName(HibernateImporter.getClassQName(info, extendsStr)), info.entityMappings, true);
        if (entity != null) {
            InheritanceType curType = (InheritanceType)entity.getInheritance().getStrategy().getValue();
            if (curType == null) {
                entity.getInheritance().getStrategy().setValue((Object)inheritanceType);
            } else if (inheritanceType != curType) {
                LOG.warn(curType + " current inheritance doesn't match " + inheritanceType);
                return false;
            }
            return true;
        }
        LOG.warn("superclass not found: " + extendsStr);
        return false;
    }

    private void processClassCommons(MappingInfo info, Entity entity, Element classElement) {
        String str = classElement.getAttributeValue("name");
        if (str != null) {
            entity.getClazz().setStringValue(HibernateImporter.getClassShortName(info, this.getNewClassName(HibernateImporter.getClassQName(info, str))));
        }
        if ((str = classElement.getAttributeValue("entity-name")) != null) {
            entity.getName().setValue((Object)str);
        } else {
            String fqName = entity.getClazz().getStringValue();
            entity.getName().setValue((Object)(fqName == null ? null : StringUtil.getShortName((String)fqName)));
        }
        if (!"subclass".equals(classElement.getName())) {
            str = classElement.getAttributeValue("table");
            if (str != null) {
                entity.getTable().getTableName().setValue((Object)str);
            }
            if ((str = classElement.getAttributeValue("schema")) != null) {
                entity.getTable().getSchema().setValue((Object)str);
            }
            if ((str = classElement.getAttributeValue("catalog")) != null) {
                entity.getTable().getCatalog().setValue((Object)str);
            }
        }
        this.processContents(info, entity, classElement, false, null);
        for (Element resultSetElement : classElement.getChildren("resultset")) {
            this.processResultSet(info, entity, resultSetElement);
        }
        for (Element queryElement : classElement.getChildren("query")) {
            this.processQuery(info, entity, queryElement);
        }
        for (Element queryElement : classElement.getChildren("sql-query")) {
            this.processSqlQuery(info, entity, queryElement);
        }
    }

    private void processResultSet(MappingInfo info, Entity entity, Element resultSetElement) {
        SqlResultSetMapping resultSetMapping = entity.addSqlResultSetMapping();
        String str = resultSetElement.getAttributeValue("name");
        if (str != null) {
            resultSetMapping.getName().setValue((Object)str);
        }
        for (Element element : resultSetElement.getChildren()) {
            if ("return-sclalar".equals(element.getName())) {
                ColumnResult columnResult = resultSetMapping.addColumnResult();
                str = element.getAttributeValue("name");
                if (str == null) continue;
                columnResult.getName().setValue((Object)str);
                continue;
            }
            if (!"return".equals(element.getName())) continue;
            EntityResult entityResult = resultSetMapping.addEntityResult();
            str = element.getAttributeValue("class");
            if (str == null) continue;
            entityResult.getEntityClass().setStringValue(str);
        }
    }

    private void processSqlQuery(MappingInfo info, Entity entity, Element queryElement) {
        NamedNativeQuery query = entity.addNamedNativeQuery();
        String str = queryElement.getAttributeValue("name");
        if (str != null) {
            query.getName().setValue((Object)str);
        }
        if ((str = queryElement.getText()) != null) {
            query.getName().setValue((Object)str);
        }
        if ((str = queryElement.getAttributeValue("resultset-ref")) != null) {
            query.getResultSetMapping().setValue((Object)str);
        } else {
            query.getResultSetMapping().setValue(query.getName().getValue());
            this.processResultSet(info, entity, queryElement);
        }
        this.addHibernateHints(query, queryElement);
    }

    private void processQuery(MappingInfo info, Entity entity, Element queryElement) {
        NamedNativeQuery query = entity.addNamedNativeQuery();
        String str = queryElement.getAttributeValue("name");
        if (str != null) {
            query.getName().setValue((Object)str);
        }
        if ((str = queryElement.getText()) != null) {
            query.getName().setValue((Object)str);
        }
        this.addHibernateHints(query, queryElement);
    }

    private void addHibernateHints(NamedNativeQuery query, Element queryElement) {
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.cacheable", queryElement.getAttributeValue("cacheable"));
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.cacheRegion", queryElement.getAttributeValue("cache-region"));
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.timeout", queryElement.getAttributeValue("timeout"));
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.fetchSize", queryElement.getAttributeValue("fetch-size"));
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.flushMode", queryElement.getAttributeValue("flush-mode"));
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.cacheMode", queryElement.getAttributeValue("cache-mode"));
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.readOnly", queryElement.getAttributeValue("read-only"));
        HibernateImporter.addQueryHint((NamedQuery)query, "org.hibernate.comment", queryElement.getAttributeValue("comment"));
    }

    private static void addQueryHint(NamedQuery query, String hintName, String hintValue) {
        if (hintValue != null) {
            QueryHint hint = query.addHint();
            hint.getName().setValue((Object)hintName);
            hint.getValue().setValue((Object)hintValue);
        }
    }

    private static void checkUnsupportedChildren(Element element, String tagName) {
        if (element.getChildren(tagName).size() > 0) {
            LOG.warn(tagName + " elements not supported");
        }
    }

    private List<AttributeBase> processContents(MappingInfo info, Entity entity, Element classElement, boolean isJoinOrProperties, String secondaryTable) {
        Basic attribute;
        ArrayList<AttributeBase> addedList = new ArrayList<AttributeBase>();
        for (Element propertyElement : classElement.getChildren("property")) {
            attribute = (Basic)this.processProperty(info, (PersistentObjectBase)entity, (AttributeWithColumn)entity.getAttributes().addBasic(), propertyElement, secondaryTable);
            addedList.add((AttributeBase)attribute);
        }
        for (Element relElement : classElement.getChildren("many-to-one")) {
            attribute = this.processToOneProperty(info, entity, relElement);
            addedList.add((AttributeBase)attribute);
        }
        for (Element componentElement : classElement.getChildren("component")) {
            attribute = this.processComponent(info, entity, componentElement);
            addedList.add((AttributeBase)attribute);
        }
        HibernateImporter.checkUnsupportedChildren(classElement, "dynamic-component");
        HibernateImporter.checkUnsupportedChildren(classElement, "any");
        if (!isJoinOrProperties) {
            HibernateImporter.checkUnsupportedChildren(classElement, "array");
            HibernateImporter.checkUnsupportedChildren(classElement, "primitive-array");
            for (Element relElement : classElement.getChildren("one-to-one")) {
                attribute = this.processToOneProperty(info, entity, relElement);
                addedList.add((AttributeBase)attribute);
            }
            for (Element relElement : classElement.getChildren("map")) {
                attribute = this.processToManyProperty(info, entity, relElement);
                if (attribute == null) continue;
                addedList.add((AttributeBase)attribute);
            }
            for (Element relElement : classElement.getChildren("set")) {
                attribute = this.processToManyProperty(info, entity, relElement);
                if (attribute == null) continue;
                addedList.add((AttributeBase)attribute);
            }
            for (Element relElement : classElement.getChildren("list")) {
                attribute = this.processToManyProperty(info, entity, relElement);
                if (attribute == null) continue;
                addedList.add((AttributeBase)attribute);
            }
            for (Element relElement : classElement.getChildren("bag")) {
                attribute = this.processToManyProperty(info, entity, relElement);
                if (attribute == null) continue;
                addedList.add((AttributeBase)attribute);
            }
            for (Element relElement : classElement.getChildren("idbag")) {
                attribute = this.processToManyProperty(info, entity, relElement);
                if (attribute == null) continue;
                addedList.add((AttributeBase)attribute);
            }
            for (Element propertiesElement : classElement.getChildren("properties")) {
                List<AttributeBase> attributes = this.processProperties(info, entity, propertiesElement);
                addedList.addAll(attributes);
            }
        }
        return addedList;
    }

    private void processContents(MappingInfo info, Embeddable embeddable, Element classElement, String secondaryTable) {
        for (Element propertyElement : classElement.getChildren("property")) {
            this.processProperty(info, (PersistentObjectBase)embeddable, (AttributeWithColumn)embeddable.getAttributes().addBasic(), propertyElement, secondaryTable);
        }
        HibernateImporter.checkUnsupportedChildren(classElement, "many-to-one");
        HibernateImporter.checkUnsupportedChildren(classElement, "component");
        HibernateImporter.checkUnsupportedChildren(classElement, "dynamic-component");
        HibernateImporter.checkUnsupportedChildren(classElement, "any");
        HibernateImporter.checkUnsupportedChildren(classElement, "array");
        HibernateImporter.checkUnsupportedChildren(classElement, "primitive-array");
        HibernateImporter.checkUnsupportedChildren(classElement, "one-to-one");
        HibernateImporter.checkUnsupportedChildren(classElement, "map");
        HibernateImporter.checkUnsupportedChildren(classElement, "set");
        HibernateImporter.checkUnsupportedChildren(classElement, "list");
        HibernateImporter.checkUnsupportedChildren(classElement, "bag");
        HibernateImporter.checkUnsupportedChildren(classElement, "idbag");
    }

    private List<AttributeBase> processProperties(MappingInfo info, Entity clazz, Element propertiesElement) {
        String name = propertiesElement.getAttributeValue("name");
        List<AttributeBase> addedList = this.processContents(info, clazz, propertiesElement, true, null);
        if (name != null) {
            info.propertiesMap.put(name, addedList);
        }
        return addedList;
    }

    private Embedded processComponent(MappingInfo info, Entity entity, Element componentElement) {
        Embedded property = entity.getAttributes().addEmbedded();
        this.ensureAccessType(info, (PersistentObjectBase)entity, componentElement);
        EntityMappings entityMappings = (EntityMappings)entity.getParent();
        assert (entityMappings != null);
        Embeddable component = entityMappings.addEmbeddable();
        String className = null;
        String str = componentElement.getAttributeValue("class");
        if (str != null) {
            className = this.getNewClassName(HibernateImporter.getClassQName(info, str), "", "");
        }
        if ((str = componentElement.getAttributeValue("name")) != null) {
            property.getName().setValue((Object)str);
            PsiType codedType = this.getPropertyPsiType(info, (PersistentObjectBase)entity, str);
            if (component.getClazz().getValue() == null) {
                PsiType type = codedType;
                String string = className = type != null ? type.getCanonicalText() : StringUtil.capitalize((String)str);
            }
        }
        if (className != null) {
            component.getClazz().setStringValue(HibernateImporter.getClassShortName(info, className));
            property.setDefaultTypeName(className);
        }
        this.processContents(info, component, componentElement, null);
        str = componentElement.getAttributeValue("lazy", info.defaultLazy);
        if (str != null) {
            FetchType fetchType = Boolean.parseBoolean(str) ? FetchType.LAZY : FetchType.EAGER;
            for (Basic attribute : component.getAttributes().getBasics()) {
                GenericAttributeValue fetch = attribute.getFetch();
                if (fetch.getValue() != null) continue;
                fetch.setValue((Object)fetchType);
            }
        }
        return property;
    }

    private void processToXXXCommon(MappingInfo info, Entity clazz, com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase property, Element propertyElement, Element relationElement) {
        PsiType type;
        Entity entity;
        Entity targetEntity;
        String targetEntityClassName = null;
        String str = propertyElement.getAttributeValue("name");
        if (str != null) {
            property.getName().setValue((Object)str);
        }
        this.ensureAccessType(info, (PersistentObjectBase)clazz, propertyElement);
        str = relationElement.getAttributeValue("entity-name");
        if (str != null && (targetEntity = this.findEntityByName(info, str, false)) != null) {
            targetEntityClassName = JpaUtil.getQualifiedName((PersistentObject)targetEntity);
        }
        if (targetEntityClassName == null && (str = relationElement.getAttributeValue("class")) != null) {
            targetEntityClassName = this.getNewClassName(HibernateImporter.getClassQName(info, str));
            entity = this.findEntityByName(info, targetEntityClassName, true);
        }
        PsiType codedType = this.getPropertyPsiType(info, (PersistentObjectBase)clazz, (String)property.getName().getValue());
        if (targetEntityClassName == null && (type = codedType) != null) {
            targetEntityClassName = this.getNewClassName(type.getCanonicalText());
            entity = this.findEntityByName(info, targetEntityClassName, true);
        }
        if (targetEntityClassName != null) {
            property.getTargetEntityClass().setStringValue(HibernateImporter.getClassShortName(info, targetEntityClassName));
        }
        if ((str = propertyElement.getAttributeValue("cascade")) != null) {
            HibernateImporter.parseCascades(str, property.getCascade());
        }
        if ((str = propertyElement.getAttributeValue("lazy", info.defaultLazy)) != null) {
            FetchType fetchType = "false".equals(str) ? FetchType.EAGER : FetchType.LAZY;
            property.getFetch().setValue((Object)fetchType);
        }
        info.relationAttributeMap.put(property, (Pair<Element, Element>)Pair.create((Object)propertyElement, (Object)relationElement));
    }

    private static CascadeType parseCascades(String str, CascadeType cascadeType) {
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("create".equals(str)) {
                cascadeType.getCascadePersist().setValue((Object)Boolean.TRUE);
                continue;
            }
            if ("merge".equals(str)) {
                cascadeType.getCascadeMerge().setValue((Object)Boolean.TRUE);
                continue;
            }
            if ("delete".equals(str)) {
                cascadeType.getCascadeRemove().setValue((Object)Boolean.TRUE);
                continue;
            }
            if ("refresh".equals(str)) {
                cascadeType.getCascadeRefresh().setValue((Object)Boolean.TRUE);
                continue;
            }
            if ("all".equals(str)) {
                cascadeType.getCascadeAll().setValue((Object)Boolean.TRUE);
                continue;
            }
            if ("none".equals(str)) {
                cascadeType.getCascadeAll().setValue((Object)Boolean.FALSE);
                cascadeType.getCascadeMerge().setValue((Object)Boolean.FALSE);
                cascadeType.getCascadePersist().setValue((Object)Boolean.FALSE);
                cascadeType.getCascadeRefresh().setValue((Object)Boolean.FALSE);
                cascadeType.getCascadeRemove().setValue((Object)Boolean.FALSE);
                break;
            }
            LOG.warn("unsupported cascade type: " + token);
        }
        return cascadeType;
    }

    @Nullable
    private RelationAttributeBase.AnyToManyBase processToManyProperty(MappingInfo info, Entity entity, Element propertyElement) {
        Element indexElement;
        String str;
        OneToMany property;
        Element relationElement;
        Element e = propertyElement.getChild("element");
        if (e != null || (e = propertyElement.getChild("composite-element")) != null || (e = propertyElement.getChild("many-to-any")) != null) {
            LOG.warn(e.getName() + " not supported");
            return null;
        }
        e = propertyElement.getChild("one-to-many");
        if (e != null) {
            relationElement = e;
            property = entity.getAttributes().addOneToMany();
        } else {
            e = propertyElement.getChild("many-to-many");
            if (e != null) {
                relationElement = e;
                property = entity.getAttributes().addManyToMany();
            } else {
                LOG.warn("only one-to-many and many-to-many supported");
                return null;
            }
        }
        Ref targetEntity = new Ref();
        Ref targetAttribute = new Ref();
        this.processToXXXCommon(info, entity, (com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase)property, propertyElement, relationElement);
        if ("map".equals(propertyElement.getName())) {
            Element mapKeyElement;
            String str2;
            e = propertyElement.getChild("map-key");
            if (e != null && (str2 = (mapKeyElement = e).getAttributeValue("column")) != null) {
                AttributeWithColumn attr = this.getAttributeByColumnName(entity, str2);
                String propertyName = str2;
                if (attr != null) {
                    propertyName = (String)attr.getName().getValue();
                } else {
                    LOG.warn("attribute not found by column name: " + str2);
                }
                property.getMapKey().getTargetAttribute().setStringValue(propertyName);
            }
        } else if ("list".equals(propertyElement.getName()) && ((e = propertyElement.getChild("index")) != null || (e = propertyElement.getChild("list-index")) != null) && (str = (indexElement = e).getAttributeValue("column")) != null) {
            AttributeWithColumn attr = this.getAttributeByColumnName(entity, str);
            if (attr != null) {
                property.getOrderBy().setValue((Object)((String)attr.getName().getValue() + " ASC"));
            } else {
                LOG.warn("attribute not found by column name: " + str);
            }
        }
        return property;
    }

    private void processJoinParametersForAttribute(com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase property, com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase targetProperty, boolean inverse, Element propertyElement, Element relationElement) {
        com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase owner;
        JoinTable joinTable = null;
        com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase relationAttributeBase = owner = inverse ? targetProperty : property;
        if (owner == null) {
            return;
        }
        String str = propertyElement.getAttributeValue("table");
        if (str != null) {
            joinTable = owner.getJoinTable();
            joinTable.getTableName().setValue((Object)str);
        } else if (property instanceof ManyToMany) {
            joinTable = owner.getJoinTable();
        }
        Element e = propertyElement.getChild("key");
        if (e != null) {
            Element keyElement = e;
            this.processJoinColumnsForAttribute(owner, joinTable, keyElement, inverse);
        }
        this.processJoinColumnsForAttribute(owner, joinTable, relationElement, !inverse);
    }

    private void processJoinColumnsForAttribute(com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase owner, JoinTable joinTable, Element keyElement, boolean inverse) {
        String str = keyElement.getAttributeValue("column");
        if (str != null) {
            this.processJoinColumn(this.getOrCreateJoinColumn(str, owner, joinTable, inverse), keyElement, true);
        }
        for (Element columnElement : keyElement.getChildren("column")) {
            str = columnElement.getAttributeValue("name");
            this.processJoinColumn(this.getOrCreateJoinColumn(str, owner, joinTable, inverse), columnElement, false);
        }
    }

    private JoinColumn getOrCreateJoinColumn(String columnName, com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase owner, JoinTable joinTable, boolean inverse) {
        List joinColumns = joinTable != null ? (inverse ? joinTable.getInverseJoinColumns() : joinTable.getJoinColumns()) : ((RelationAttributeBase.NonManyToManyBase)owner).getJoinColumns();
        for (JoinColumn joinColumn : joinColumns) {
            if (!Comparing.equal((String)columnName, (String)((String)joinColumn.getName().getValue()))) continue;
            return joinColumn;
        }
        JoinColumn joinColumn = joinTable != null ? (inverse ? joinTable.addInverseJoinColumn() : joinTable.addJoinColumn()) : ((RelationAttributeBase.NonManyToManyBase)owner).addJoinColumn();
        return joinColumn;
    }

    private JoinColumn processJoinColumn(JoinColumn joinColumn, Element columnElement, boolean def) {
        String str = columnElement.getAttributeValue(def ? "column" : "name");
        if (str != null) {
            joinColumn.getName().setValue((Object)str);
        }
        if ((str = columnElement.getAttributeValue("not-null")) != null) {
            Boolean nullable = !Boolean.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
            joinColumn.getNullable().setValue((Object)nullable);
        }
        if ((str = columnElement.getAttributeValue("update")) != null) {
            Boolean updatable = Boolean.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
            joinColumn.getUpdatable().setValue((Object)updatable);
        }
        if ((str = columnElement.getAttributeValue("unique")) != null) {
            Boolean unique = Boolean.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
            joinColumn.getUnique().setValue((Object)unique);
        }
        return joinColumn;
    }

    @Nullable
    private String convertOrderBy(Entity targetEntity, String hibernateOrderBy) {
        StringTokenizer st = new StringTokenizer(hibernateOrderBy, ", ");
        StringBuilder sb = new StringBuilder();
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if ("ASC".equalsIgnoreCase(token) || "DESC".equalsIgnoreCase(token)) {
                if (count > 0) {
                    sb.append(" ");
                }
                sb.append(token.toUpperCase());
                break;
            }
            AttributeWithColumn attribute = this.getAttributeByColumnName(targetEntity, token);
            String propertyName = token;
            if (attribute != null) {
                propertyName = (String)attribute.getName().getValue();
            } else {
                LOG.warn("attribute not found by column name: " + token);
            }
            if (count > 0) {
                sb.append(", ");
            }
            sb.append(propertyName);
            ++count;
        }
        return count > 0 ? sb.toString() : null;
    }

    private RelationAttributeBase.AnyToOneBase processToOneProperty(MappingInfo info, Entity entity, Element propertyElement) {
        boolean many = "many-to-one".equals(propertyElement.getName());
        ManyToOne property = many ? entity.getAttributes().addManyToOne() : entity.getAttributes().addOneToOne();
        Ref targetAttribute = new Ref();
        this.processToXXXCommon(info, entity, (com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase)property, propertyElement, propertyElement);
        return property;
    }

    private AttributeWithColumn processProperty(MappingInfo info, PersistentObjectBase entity, AttributeWithColumn property, Element propertyElement, String secondaryTable) {
        Boolean flag;
        String str = propertyElement.getAttributeValue("name");
        if (str != null) {
            property.getName().setValue((Object)str);
        }
        this.ensureAccessType(info, entity, propertyElement);
        PsiType type = this.getPropertyPsiType(info, entity, (String)property.getName().getValue());
        String typeName = type == null ? null : type.getCanonicalText();
        str = propertyElement.getAttributeValue("type");
        if (str != null) {
            if (("blob".equals(str) || "clob".equals(str)) && property instanceof Basic) {
                ((Basic)property).getLob().ensureTagExists();
            }
            if (typeName == null) {
                typeName = HIBERNATE_TYPES_MAP.get(str);
            }
        }
        property.setDefaultTypeName(typeName);
        if (secondaryTable != null) {
            property.getColumn().getTable().setValue((Object)secondaryTable);
        }
        this.processColumn(info, property.getColumn(), propertyElement, true);
        Element e = propertyElement.getChild("column");
        if (e != null) {
            this.processColumn(info, property.getColumn(), e, false);
        }
        if ((str = propertyElement.getAttributeValue("update")) != null) {
            flag = Boolean.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
            property.getColumn().getUpdatable().setValue((Object)flag);
        }
        if ((str = propertyElement.getAttributeValue("insert")) != null) {
            flag = Boolean.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
            property.getColumn().getInsertable().setValue((Object)flag);
        }
        if ((str = propertyElement.getAttributeValue("lazy", info.defaultLazy)) != null) {
            FetchType fetchType;
            FetchType fetchType2 = fetchType = Boolean.parseBoolean(str) ? FetchType.LAZY : FetchType.EAGER;
            if (property instanceof Basic) {
                ((Basic)property).getFetch().setValue((Object)fetchType);
            }
        }
        return property;
    }

    private void processColumn(MappingInfo info, Column column, Element columnElement, boolean def) {
        String str = columnElement.getAttributeValue(def ? "column" : "name");
        if (str != null) {
            column.getName().setValue((Object)str);
        }
        if ((str = columnElement.getAttributeValue("length")) != null) {
            column.getLength().setValue((Object)HibernateImporter.toInteger(str));
        }
        if ((str = columnElement.getAttributeValue("precision")) != null) {
            column.getPrecision().setValue((Object)HibernateImporter.toInteger(str));
        }
        if ((str = columnElement.getAttributeValue("scale")) != null) {
            column.getScale().setValue((Object)HibernateImporter.toInteger(str));
        }
        if ((str = columnElement.getAttributeValue("not-null")) != null) {
            Boolean nullable = !Boolean.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
            column.getNullable().setValue((Object)nullable);
        }
        if ((str = columnElement.getAttributeValue("unique")) != null) {
            Boolean unique = Boolean.parseBoolean(str) ? Boolean.TRUE : Boolean.FALSE;
            column.getUnique().setValue((Object)unique);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processClass(MappingInfo info, Element classElement) {
        Element versionElement;
        Version list;
        Id property;
        Element e;
        String str;
        Entity entity;
        block36: {
            block35: {
                block40: {
                    block39: {
                        block38: {
                            block37: {
                                Element generatorElement;
                                PsiType type;
                                entity = info.entityMappings.addEntity();
                                this.processClassCommons(info, entity, classElement);
                                str = classElement.getAttributeValue("discriminator-value");
                                if (str != null) {
                                    entity.getDiscriminatorValue().setValue((Object)str);
                                }
                                if ((e = classElement.getChild("id")) == null) break block35;
                                Element idElement = e;
                                property = entity.getAttributes().addId();
                                str = idElement.getAttributeValue("name");
                                if (str != null) {
                                    property.getName().setValue((Object)str);
                                }
                                this.ensureAccessType(info, (PersistentObjectBase)entity, idElement);
                                this.processColumn(info, property.getColumn(), idElement, true);
                                e = idElement.getChild("column");
                                if (e != null) {
                                    this.processColumn(info, property.getColumn(), e, false);
                                }
                                if ((type = this.getPropertyPsiType(info, (PersistentObjectBase)entity, (String)property.getName().getValue())) != null) {
                                    property.setDefaultTypeName(type.getCanonicalText());
                                }
                                if ((e = idElement.getChild("generator")) == null || (str = (generatorElement = e).getAttributeValue("class")) == null) break block36;
                                if (!"identity".equals(str)) break block37;
                                property.getGeneratedValue().getStrategy().setValue((Object)GenerationType.IDENTITY);
                                break block36;
                            }
                            if (!"sequence".equals(str)) break block38;
                            property.getGeneratedValue().getStrategy().setValue((Object)GenerationType.SEQUENCE);
                            break block36;
                        }
                        if (!"hilo".equals(str) && !"seqhilo".equals(str)) break block39;
                        property.getGeneratedValue().getStrategy().setValue((Object)GenerationType.TABLE);
                        break block36;
                    }
                    if (!"increment".equals(str) && !"native".equals(str) && !"uuid".equals(str) && !"guid".equals(str)) break block40;
                    property.getGeneratedValue().getStrategy().setValue((Object)GenerationType.AUTO);
                    break block36;
                }
                if ("assigned".equals(str) || "foreign".equals(str) || "select".equals(str)) break block36;
                break block36;
            }
            e = classElement.getChild("composite-id");
            if (e != null) {
                Element compositeIdElement = e;
                String className = null;
                this.ensureAccessType(info, (PersistentObjectBase)entity, compositeIdElement);
                str = compositeIdElement.getAttributeValue("class");
                if (str != null) {
                    className = this.getNewClassName(HibernateImporter.getClassQName(info, str), "", "");
                }
                if ((str = compositeIdElement.getAttributeValue("name")) != null) {
                    String name = str;
                    entity.getAttributes().getEmbeddedId().getName().setValue((Object)name);
                    PsiType type = this.getPropertyPsiType(info, (PersistentObjectBase)entity, name);
                    if (className == null && type != null) {
                        className = type.getCanonicalText();
                    }
                    entity.getAttributes().getEmbeddedId().setDefaultTypeName(className);
                } else {
                    str = compositeIdElement.getAttributeValue("mapped");
                    if (str != null && Boolean.TRUE.equals(Boolean.valueOf(str)) && className != null) {
                        entity.getIdClass().getClazz().setStringValue(className);
                        HibernateImporter.checkUnsupportedChildren(compositeIdElement, "key-many-to-one");
                        for (Element keyPropertyElement : compositeIdElement.getChildren("key-property")) {
                            PsiType type;
                            Id id = entity.getAttributes().addId();
                            str = keyPropertyElement.getAttributeValue("name");
                            if (str != null) {
                                id.getName().setValue((Object)str);
                            }
                            if ((str = keyPropertyElement.getAttributeValue("column")) != null) {
                                id.getColumn().getName().setValue((Object)str);
                            }
                            if ((type = this.getPropertyPsiType(info, (PersistentObjectBase)entity, (String)id.getName().getValue())) == null) continue;
                            id.setDefaultTypeName(type.getCanonicalText());
                        }
                    }
                }
            }
        }
        e = classElement.getChild("discriminator");
        if (e != null) {
            Element discriminatorElement = e;
            str = discriminatorElement.getAttributeValue("column");
            if (str != null) {
                entity.getDiscriminatorColumn().getName().setValue((Object)str);
            }
            if ((str = discriminatorElement.getAttributeValue("type")) != null) {
                if (Arrays.asList("string", "boolean", "yes_no", "true_false").contains(str)) {
                    entity.getDiscriminatorColumn().getDiscriminatorType().setValue((Object)DiscriminatorType.STRING);
                } else if (Arrays.asList("integer", "byte", "short").contains(str)) {
                    entity.getDiscriminatorColumn().getDiscriminatorType().setValue((Object)DiscriminatorType.INTEGER);
                } else if (Arrays.asList("character").contains(str)) {
                    entity.getDiscriminatorColumn().getDiscriminatorType().setValue((Object)DiscriminatorType.CHAR);
                }
            }
            if ((str = discriminatorElement.getAttributeValue("length")) != null) {
                entity.getDiscriminatorColumn().getLength().setValue((Object)HibernateImporter.toInteger(str));
            }
            if ((e = discriminatorElement.getChild("column")) != null) {
                Element columnElement = e;
                str = columnElement.getAttributeValue("name");
                if (str != null) {
                    entity.getDiscriminatorColumn().getName().setValue((Object)str);
                }
                if ((str = columnElement.getAttributeValue("length")) != null) {
                    entity.getDiscriminatorColumn().getLength().setValue((Object)HibernateImporter.toInteger(str));
                }
            }
        }
        if ((e = classElement.getChild("natural-id")) != null) {
            Element naturalIdElement = e;
            list = this.processContents(info, entity, naturalIdElement, true, null);
            UniqueConstraint uniqueConstraint = entity.getTable().addUniqueConstraint();
            for (AttributeBase attribute : list) {
                if (!(attribute instanceof AttributeWithColumn)) continue;
                uniqueConstraint.addColumnName().setValue((Object)HibernateImporter.getColumnName((AttributeWithColumn)attribute));
            }
        }
        if ((e = classElement.getChild("version")) != null) {
            versionElement = e;
            list = (Version)this.processProperty(info, (PersistentObjectBase)entity, (AttributeWithColumn)entity.getAttributes().addVersion(), versionElement, null);
        }
        if ((e = classElement.getChild("timestamp")) != null) {
            versionElement = e;
            property = (Version)this.processProperty(info, (PersistentObjectBase)entity, (AttributeWithColumn)entity.getAttributes().addVersion(), versionElement, null);
            property.getTemporal().setValue((Object)Temporal.TIMESTAMP);
        }
        if (classElement.getChildren("subclass").size() > 0 || classElement.getChildren("join").size() > 0) {
            entity.getInheritance().getStrategy().setValue((Object)InheritanceType.SINGLE_TABLE);
            for (Element el1 : classElement.getChildren("subclass")) {
                this.processSubclass(info, el1);
            }
            for (Element el1 : classElement.getChildren("join")) {
                this.processJoin(info, entity, el1);
            }
            return;
        }
        if (classElement.getChildren("joined-subclass").size() > 0) {
            entity.getInheritance().getStrategy().setValue((Object)InheritanceType.JOINED);
            for (Element el1 : classElement.getChildren("joined-subclass")) {
                this.processJoinedSubclass(info, el1);
            }
            return;
        }
        if (classElement.getChildren("union-subclass").size() <= 0) return;
        entity.getInheritance().getStrategy().setValue((Object)InheritanceType.TABLE_PER_CLASS);
        for (Element el1 : classElement.getChildren("union-subclass")) {
            this.processUnionSubclass(info, el1);
        }
    }

    private void ensureAccessType(MappingInfo info, PersistentObjectBase clazz, Element element) {
        AccessType accessType;
        boolean defaultValueFlag = false;
        String str = element.getAttributeValue("access");
        if (str != null) {
            accessType = str.equals("property") ? AccessType.PROPERTY : AccessType.FIELD;
        } else {
            defaultValueFlag = true;
            accessType = (AccessType)info.entityMappings.getAccess().getValue();
        }
        if (accessType == null) {
            return;
        }
        GenericAttributeValue access = clazz.getAccess();
        if (access.getValue() == null) {
            if (!defaultValueFlag) {
                access.setValue((Object)accessType);
            }
        } else if (access.getValue() != accessType) {
            LOG.warn(access.getValue() + " access doesn't match " + accessType);
        }
    }

    private void processUnionSubclass(MappingInfo info, Element classElement) {
        Entity clazz = info.entityMappings.addEntity();
        this.processClassCommons(info, clazz, classElement);
        for (Element el1 : classElement.getChildren("union-subclass")) {
            this.processUnionSubclass(info, el1);
        }
    }

    private void processJoinedSubclass(MappingInfo info, Element classElement) {
        Entity clazz = info.entityMappings.addEntity();
        this.processClassCommons(info, clazz, classElement);
        for (Element el1 : classElement.getChildren("joined-subclass")) {
            this.processJoinedSubclass(info, el1);
        }
    }

    private void processSubclass(MappingInfo info, Element classElement) {
        Entity clazz = info.entityMappings.addEntity();
        this.processClassCommons(info, clazz, classElement);
        String str = classElement.getAttributeValue("discriminator-value");
        if (str != null) {
            clazz.getDiscriminatorValue().setValue((Object)str);
        }
        for (Element element : classElement.getChildren("subclass")) {
            this.processSubclass(info, element);
        }
        for (Element element : classElement.getChildren("join")) {
            this.processJoin(info, clazz, element);
        }
    }

    private void processJoin(MappingInfo info, Entity clazz, Element joinElement) {
        Element e;
        SecondaryTable secondaryTable = clazz.addSecondaryTable();
        String str = joinElement.getAttributeValue("table");
        if (str != null) {
            secondaryTable.getTableName().setValue((Object)str);
        }
        if ((str = joinElement.getAttributeValue("schema")) != null) {
            secondaryTable.getSchema().setValue((Object)str);
        }
        if ((str = joinElement.getAttributeValue("catalog")) != null) {
            secondaryTable.getCatalog().setValue((Object)str);
        }
        if ((e = joinElement.getChild("key")) != null) {
            Element keyElement = e;
            str = keyElement.getAttributeValue("column");
            if (str != null) {
                PrimaryKeyJoinColumn defJoinColumn = secondaryTable.addPrimaryKeyJoinColumn();
                defJoinColumn.getName().setValue((Object)str);
            }
            for (Element columnElement : keyElement.getChildren("column")) {
                PrimaryKeyJoinColumn joinColumn = secondaryTable.addPrimaryKeyJoinColumn();
                str = columnElement.getAttributeValue("name");
                if (str == null) continue;
                joinColumn.getName().setValue((Object)str);
            }
        }
        this.processContents(info, clazz, joinElement, true, (String)secondaryTable.getTableName().getValue());
    }

    private static Integer toInteger(String str) {
        try {
            return new Integer(str);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    private static String getColumnName(AttributeWithColumn attribute) {
        String columnName = (String)attribute.getColumn().getName().getValue();
        return columnName == null ? (String)attribute.getName().getValue() : columnName;
    }

    private AttributeWithColumn getAttributeByColumnName(Entity entity, String columnName) {
        for (com.intellij.javaee.model.common.persistence.mapping.AttributeBase attributeBase : entity.getAllAttributes()) {
            AttributeWithColumn attribute;
            if (!(attributeBase instanceof AttributeWithColumn) || !columnName.equals(HibernateImporter.getColumnName(attribute = (AttributeWithColumn)attributeBase))) continue;
            return attribute;
        }
        return null;
    }

    private static String getEntityName(Entity entity) {
        String value = (String)entity.getName().getValue();
        return !StringUtil.isEmpty((String)value) ? value : StringUtil.getShortName((String)entity.getClazz().getStringValue());
    }

    @Nullable
    private PsiType getPropertyPsiType(MappingInfo info, PersistentObjectBase persistentObject, String propertyName) {
        String className = JpaUtil.getQualifiedName((PersistentObject)persistentObject);
        if (className == null || propertyName == null) {
            return null;
        }
        Project project = info.module.getProject();
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)project).findClass(className, GlobalSearchScope.allScope((Project)info.module.getProject()));
        if (psiClass == null) {
            return null;
        }
        PsiField propertyField = PropertyUtil.findPropertyField((PsiClass)psiClass, (String)propertyName, (boolean)false);
        if (propertyField != null) {
            info.mappedSuperClassCandidates.add(propertyField.getContainingClass());
            return propertyField.getType();
        }
        PsiMethod propertyGetter = PropertyUtil.findPropertyGetter((PsiClass)psiClass, (String)propertyName, (boolean)false, (boolean)true);
        if (propertyGetter != null) {
            info.mappedSuperClassCandidates.add(propertyGetter.getContainingClass());
            return propertyGetter.getReturnType();
        }
        return null;
    }

    @Nullable
    private Entity findEntityByName(MappingInfo info, String entityNameOrClassName, boolean useClassName) {
        PersistentObjectBase persistentObject;
        Entity result = this.findEntityByName(entityNameOrClassName, info.entityMappings, useClassName);
        if (result == null && (persistentObject = info.externalMappings.get(entityNameOrClassName)) instanceof Entity) {
            result = (Entity)persistentObject;
        }
        return result;
    }

    private void buildExternalMappings(MappingInfo info) {
        DomFileElement orm;
        info.externalMappings.clear();
        JpaFacet facet = JpaUtil.getJpaFacet(info.module);
        ConfigFile defORM = facet == null ? null : facet.getDefaultORMDescriptor();
        DomFileElement domFileElement = orm = defORM != null && defORM.getXmlFile() != null ? DomManager.getDomManager((Project)info.module.getProject()).getFileElement(defORM.getXmlFile(), EntityMappings.class) : null;
        if (orm != null) {
            EntityMappings entityMappings = (EntityMappings)orm.getRootElement();
            this.buildMappings(entityMappings, info.externalMappings);
        }
        if (info.persistenceUnit != null) {
            for (GenericValue mappingFileGeneric : info.persistenceUnit.getModelHelper().getMappingFiles(EntityMappings.class)) {
                EntityMappings entityMappings = (EntityMappings)mappingFileGeneric.getValue();
                if (entityMappings == null) continue;
                this.buildMappings(entityMappings, info.externalMappings);
            }
        }
    }

    private void buildMappings(EntityMappings entityMappings, HashMap<String, PersistentObjectBase> externalMappings) {
        for (Entity entity : entityMappings.getEntities()) {
            externalMappings.put(HibernateImporter.getEntityName(entity), (PersistentObjectBase)entity);
            externalMappings.put(JpaUtil.getQualifiedName((PersistentObject)entity), (PersistentObjectBase)entity);
        }
        for (Embeddable embeddable : entityMappings.getEmbeddables()) {
            externalMappings.put(JpaUtil.getQualifiedName((PersistentObject)embeddable), (PersistentObjectBase)embeddable);
        }
    }

    @Nullable
    private Entity findEntityByName(String name, EntityMappings entityMappings, boolean useClassName) {
        for (Entity entity : entityMappings.getEntities()) {
            if (!useClassName && name.equals(HibernateImporter.getEntityName(entity))) {
                return entity;
            }
            if (!useClassName || !name.equals(JpaUtil.getQualifiedName((PersistentObject)entity))) continue;
            return entity;
        }
        return null;
    }

    static {
        HIBERNATE_TYPES_MAP.put("integer", "int");
        HIBERNATE_TYPES_MAP.put("long", "long");
        HIBERNATE_TYPES_MAP.put("short", "short");
        HIBERNATE_TYPES_MAP.put("float", "float");
        HIBERNATE_TYPES_MAP.put("double", "double");
        HIBERNATE_TYPES_MAP.put("character", "char");
        HIBERNATE_TYPES_MAP.put("byte", "byte");
        HIBERNATE_TYPES_MAP.put("boolean", "boolean");
        HIBERNATE_TYPES_MAP.put("yes_no", "boolean");
        HIBERNATE_TYPES_MAP.put("true_false", "boolean");
        HIBERNATE_TYPES_MAP.put("string", "java.lang.String");
        HIBERNATE_TYPES_MAP.put("date", "java.util.Date");
        HIBERNATE_TYPES_MAP.put("time", "java.util.Time");
        HIBERNATE_TYPES_MAP.put("timestamp", "java.util.Timestamp");
        HIBERNATE_TYPES_MAP.put("calendar", "java.util.Calendar");
        HIBERNATE_TYPES_MAP.put("calendar_date", "java.util.Calendar");
        HIBERNATE_TYPES_MAP.put("big_decimal", "java.math.BigDecimal");
        HIBERNATE_TYPES_MAP.put("big_integer", "java.math.BigInteger");
        HIBERNATE_TYPES_MAP.put("locale", "java.util.Locale");
        HIBERNATE_TYPES_MAP.put("timezone", "java.util.TimeZone");
        HIBERNATE_TYPES_MAP.put("currency", "java.util.Currency");
        HIBERNATE_TYPES_MAP.put("class", "java.lang.Class");
        HIBERNATE_TYPES_MAP.put("binary", "byte[]");
        HIBERNATE_TYPES_MAP.put("text", "java.lang.String");
        HIBERNATE_TYPES_MAP.put("serializable", "java.io.Serializable");
        HIBERNATE_TYPES_MAP.put("clob", "java.sql.Clob");
        HIBERNATE_TYPES_MAP.put("blob", "java.sql.Blob");
        HIBERNATE_TYPES_MAP.put("imm_date", "java.util.Date");
        HIBERNATE_TYPES_MAP.put("imm_time", "java.util.Time");
        HIBERNATE_TYPES_MAP.put("imm_timestamp", "java.util.Timestamp");
        HIBERNATE_TYPES_MAP.put("imm_calendar", "java.util.Calendar");
        HIBERNATE_TYPES_MAP.put("imm_calendar_date", "java.util.Calendar");
        HIBERNATE_TYPES_MAP.put("imm_serializable", "java.io.Serializable");
        HIBERNATE_TYPES_MAP.put("imm_binary", "byte[]");
    }

    private static class MappingInfo {
        Module module;
        EntityMappings entityMappings;
        PersistenceUnit persistenceUnit;
        String defaultLazy;
        CascadeType defaultCascade;
        HashMap<String, String> imports = new HashMap();
        HashMap<String, Element> queries = new HashMap();
        HashMap<String, Element> sqlQueries = new HashMap();
        HashMap<String, Element> resultSets = new HashMap();
        HashMap<String, List<AttributeBase>> propertiesMap = new HashMap();
        HashMap<String, PersistentObjectBase> externalMappings = new HashMap();
        HashSet<PsiClass> mappedSuperClassCandidates = new HashSet();
        HashMap<com.intellij.javaee.model.xml.persistence.mapping.RelationAttributeBase, Pair<Element, Element>> relationAttributeMap = new HashMap();

        private MappingInfo() {
        }
    }
}

