/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.model.common.persistence.mapping.EntityListener;
import com.intellij.jpa.JpaMessages;
import com.intellij.jpa.actions.GenerateEntityListenerMethods;
import com.intellij.jpa.highlighting.JpaHighlightingMessages;
import com.intellij.jpa.inspections.AbstractJpaInspection;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.persistence.model.PersistenceListener;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.xml.ModelMergerUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class JpaEntityListenerWarningsInspection
extends AbstractJpaInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = JpaMessages.message((String)"inspection.jpa.entity.listener.warnings", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("JpaEntityListenerWarningsInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection", "getShortName"));
        }
        return "JpaEntityListenerWarningsInspection";
    }

    @Override
    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected void checkClass(PsiClass aClass, PersistenceClassRole role, ProblemsHolder holder, boolean isOnTheFly) {
        PersistenceListener listener = role.getEntityListener();
        if (listener != null) {
            JpaEntityListenerWarningsInspection.checkNoListenerMethodsDefinedWarning(aClass, listener, holder);
        }
    }

    private static void checkNoListenerMethodsDefinedWarning(PsiClass aClass, PersistenceListener listener, ProblemsHolder holder) {
        CommonProcessors.FindFirstProcessor processor = new CommonProcessors.FindFirstProcessor();
        for (PersistenceListener impl : ModelMergerUtil.getImplementations((Object)listener)) {
            if (!(impl instanceof EntityListener)) continue;
            ((EntityListener)impl).processEntityListenerMethods(aClass, (Processor)processor);
        }
        if (!processor.isFound()) {
            holder.registerProblem((PsiElement)aClass.getNameIdentifier(), JpaHighlightingMessages.message("entity.listener.class.has.no.annotated.methods", aClass.getName()), new LocalQuickFix[]{new GenerateListenerMethodsFix(aClass)});
        }
    }

    private static class GenerateListenerMethodsFix
    implements LocalQuickFix {
        private final PsiClass myClass;

        public GenerateListenerMethodsFix(PsiClass aClass) {
            this.myClass = aClass;
        }

        @NotNull
        public String getFamilyName() {
            String string = JpaHighlightingMessages.message("intention.family.generate.entity.listener.methods", new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection$GenerateListenerMethodsFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection$GenerateListenerMethodsFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/jpa/inspections/JpaEntityListenerWarningsInspection$GenerateListenerMethodsFix", "applyFix"));
            }
            Editor editor = FileEditorManager.getInstance((Project)project).openTextEditor(new OpenFileDescriptor(project, this.myClass.getContainingFile().getVirtualFile(), this.myClass.getNameIdentifier().getTextOffset()), false);
            new GenerateEntityListenerMethods().actionPerformedImpl(project, editor);
        }
    }
}

