/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.ql.editor;

import com.intellij.jpa.ql.editor.QlSyntaxHighlighter;
import com.intellij.jpa.ql.model.QlAttribute;
import com.intellij.jpa.ql.model.QlEntity;
import com.intellij.jpa.ql.psi.QlAliasDefinition;
import com.intellij.jpa.ql.psi.QlDateTimeLiteral;
import com.intellij.jpa.ql.psi.QlFunctionCallExpression;
import com.intellij.jpa.ql.psi.QlIdentifier;
import com.intellij.jpa.ql.psi.QlInputParameter;
import com.intellij.jpa.ql.psi.QlReferenceExpression;
import com.intellij.jpa.ql.psi.QlVisitor;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.jetbrains.annotations.NotNull;

public class QlAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement psiElement, final @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/jpa/ql/editor/QlAnnotator", "annotate"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jpa/ql/editor/QlAnnotator", "annotate"));
        }
        psiElement.accept((PsiElementVisitor)new QlVisitor(){

            @Override
            public void visitAliasDefinition(@NotNull QlAliasDefinition o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/editor/QlAnnotator$1", "visitAliasDefinition"));
                }
                QlAnnotator.setHighlighting(o.getIdentifier(), holder, QlSyntaxHighlighter.ID_VARIABLE);
            }

            @Override
            public void visitFunctionCallExpression(@NotNull QlFunctionCallExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/editor/QlAnnotator$1", "visitFunctionCallExpression"));
                }
                PsiElement nameToken = o.getFirstChild();
                if (nameToken != null) {
                    QlAnnotator.setHighlighting(nameToken, holder, QlSyntaxHighlighter.FUNCTION);
                }
            }

            @Override
            public void visitDateTimeLiteral(@NotNull QlDateTimeLiteral o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/editor/QlAnnotator$1", "visitDateTimeLiteral"));
                }
                QlAnnotator.setHighlighting(o, holder, QlSyntaxHighlighter.DATETIME);
            }

            @Override
            public void visitReferenceExpression(@NotNull QlReferenceExpression o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/editor/QlAnnotator$1", "visitReferenceExpression"));
                }
                Object target = o.resolve();
                if (target == null) {
                    return;
                }
                QlIdentifier ident = o.getIdentifier();
                TextAttributesKey attrs = null;
                if (target instanceof QlAliasDefinition) {
                    attrs = QlSyntaxHighlighter.ID_VARIABLE;
                } else if (target instanceof QlEntity) {
                    attrs = QlSyntaxHighlighter.ENTITY;
                } else if (target instanceof QlAttribute) {
                    attrs = QlSyntaxHighlighter.ATTRIBUTE;
                }
                if (attrs != null) {
                    QlAnnotator.setHighlighting(ident, holder, attrs);
                }
            }

            @Override
            public void visitInputParameter(@NotNull QlInputParameter o) {
                if (o == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/jpa/ql/editor/QlAnnotator$1", "visitInputParameter"));
                }
                QlAnnotator.setHighlighting(o, holder, QlSyntaxHighlighter.PARAMETER);
            }
        });
    }

    protected static void setHighlighting(@NotNull PsiElement element, @NotNull AnnotationHolder holder, TextAttributesKey key) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/jpa/ql/editor/QlAnnotator", "setHighlighting"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/jpa/ql/editor/QlAnnotator", "setHighlighting"));
        }
        holder.createInfoAnnotation(element, null).setEnforcedTextAttributes(TextAttributes.ERASE_MARKER);
        holder.createInfoAnnotation(element, null).setTextAttributes(key);
    }
}

