/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.expr.IdentifierExpr;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.ArrayList;
import java.util.List;

public class BuiltInVariableExpr
extends IdentifierExpr {
    private final String mAccessCode;

    BuiltInVariableExpr(String name, String type, String accessCode) {
        super(name);
        super.setUserDefinedType(type);
        this.mAccessCode = accessCode;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        ModelClass modelClass = super.resolveType(modelAnalyzer);
        return modelClass;
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return new ArrayList<Dependency>();
    }

    @Override
    protected KCode generateCode() {
        if (this.mAccessCode == null) {
            return new KCode().app(this.mName);
        }
        return new KCode().app(this.mAccessCode);
    }

    @Override
    public boolean isDeclared() {
        return false;
    }

    @Override
    public String getInvertibleError() {
        return "Built-in variables may not be the target of two-way binding";
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.builtInVariable(this.mName, this.mUserDefinedType, this.mAccessCode);
    }
}

