/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.transparent;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.concurrent.atomic.AtomicReference;
import net.sourceforge.transparent.CCaseSharedConfig;
import net.sourceforge.transparent.TransparentVcs;
import net.sourceforge.transparent.exceptions.ClearCaseException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseOrUCM {
    @NonNls
    private static final String NOT_A_UCM_VOB = "cleartool: Error: Not a UCM PVOB:";
    @NonNls
    private static final String UCM_MISMATCH_GROUP = "UCM_MISMATCH_GROUP";
    private final TransparentVcs myVcs;
    private final AtomicReference<MyNotification> myCurrentNotification;

    public BaseOrUCM(TransparentVcs vcs) {
        this.myVcs = vcs;
        this.myCurrentNotification = new AtomicReference<Object>(null);
    }

    public void checkRootsForUCMMismatch() {
        Boolean isUCM = this.isUCMByRoots();
        if (isUCM == null) {
            MyNotification oldNotification = this.myCurrentNotification.getAndSet(null);
            if (oldNotification != null) {
                oldNotification.expire();
            }
            return;
        }
        CCaseSharedConfig sharedConfig = CCaseSharedConfig.getInstance(this.myVcs.getProject());
        boolean useUcmModelConfig = sharedConfig.isUseUcmModel();
        MyNotification newNotification = null;
        if (useUcmModelConfig && !isUCM.booleanValue()) {
            newNotification = new MyNotification("Project is configured to use UCM model, but it is base ClearCase");
        } else if (!useUcmModelConfig && isUCM.booleanValue()) {
            newNotification = new MyNotification("Project is configured as base ClearCase, but UCM model is used");
        }
        MyNotification oldNotification = this.myCurrentNotification.getAndSet(newNotification);
        if (oldNotification != null) {
            oldNotification.expire();
        }
        if (newNotification != null) {
            Notifications.Bus.notify((Notification)newNotification, (Project)this.myVcs.getProject());
        }
    }

    @Nullable
    public Boolean isUCMByRoots() {
        VirtualFile[] roots;
        Boolean UCM = null;
        Project project = this.myVcs.getProject();
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        for (VirtualFile root : roots = vcsManager.getRootsUnderVcs((AbstractVcs)this.myVcs)) {
            try {
                UCM = BaseOrUCM.isUCM(root);
                break;
            }
            catch (ClearCaseException clearCaseException) {
            }
        }
        return UCM;
    }

    public static boolean isUCM(VirtualFile vf) {
        String result = TransparentVcs.cleartoolOnLocalPathWithOutput(vf.getPath(), "lsproj", "-s", "-cview");
        return !StringUtil.isEmptyOrSpaces((String)result) && !result.startsWith(NOT_A_UCM_VOB);
    }

    private static class MyNotification
    extends Notification {
        private MyNotification(@NotNull String content) {
            if (content == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "net/sourceforge/transparent/BaseOrUCM$MyNotification", "<init>"));
            }
            super(BaseOrUCM.UCM_MISMATCH_GROUP, "ClearCase settings mismatch", content, NotificationType.WARNING);
        }

        public String toString() {
            return this.getContent();
        }
    }
}

