/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.play.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.play.completion.PlayCompletionUtils;
import com.intellij.play.completion.beans.NameValueDescriptor;
import com.intellij.play.completion.beans.PlayTagDescriptor;
import com.intellij.play.language.PlayElementTypes;
import com.intellij.play.language.psi.PlayNameValueCompositeElement;
import com.intellij.play.language.psi.PlayTag;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import icons.PlayIcons;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PlayGroovyCompletionContributor
extends CompletionContributor {
    public PlayGroovyCompletionContributor() {
        this.extend(CompletionType.BASIC, (ElementPattern)PlatformPatterns.psiElement().inside((ElementPattern)PlatformPatterns.psiElement((IElementType)PlayElementTypes.TAG_EXPRESSION)), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            public void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
                if (parameters == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "com/intellij/play/completion/PlayGroovyCompletionContributor$1", "addCompletions"));
                }
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/play/completion/PlayGroovyCompletionContributor$1", "addCompletions"));
                }
                if (PlayGroovyCompletionContributor.this.isNameValueExpressionPosition(parameters) || PlayGroovyCompletionContributor.this.isLiteralExpression(parameters)) {
                    return;
                }
                PlayTag tag = (PlayTag)PsiTreeUtil.getParentOfType((PsiElement)parameters.getOriginalPosition(), PlayTag.class);
                if (tag != null) {
                    List existingAttrNames = ContainerUtil.mapNotNull((Object[])tag.getNameValues(), element -> element.getName());
                    PlayTagDescriptor tagDescriptor = PlayCompletionUtils.findTagDescriptor(tag);
                    if (tagDescriptor != null) {
                        for (NameValueDescriptor nameValueDescriptor : tagDescriptor.getDescriptors()) {
                            String name = nameValueDescriptor.getName();
                            if (StringUtil.isEmptyOrSpaces((String)name) || existingAttrNames.contains(name)) continue;
                            result.addElement(PlayGroovyCompletionContributor.this.createLookupElement(nameValueDescriptor));
                        }
                    }
                }
            }
        });
    }

    private boolean isLiteralExpression(CompletionParameters parameters) {
        PsiElement originalPosition = parameters.getOriginalPosition();
        return originalPosition != null && PsiTreeUtil.getParentOfType((PsiElement)originalPosition, PsiLiteral.class) != null;
    }

    private boolean isNameValueExpressionPosition(CompletionParameters parameters) {
        PsiElement originalPosition = parameters.getOriginalPosition();
        if (originalPosition != null) {
            if (PsiTreeUtil.getParentOfType((PsiElement)originalPosition, PlayNameValueCompositeElement.class) != null) {
                return true;
            }
            if (originalPosition.getNode().getElementType() == PlayElementTypes.COMMA) {
                PsiElement prevSibling = originalPosition.getPrevSibling();
                if (prevSibling instanceof PlayNameValueCompositeElement) {
                    return true;
                }
                while (prevSibling != null) {
                    IElementType elementType = prevSibling.getNode().getElementType();
                    if (elementType == PlayElementTypes.ATTR_NAME) {
                        return true;
                    }
                    if (elementType == PlayElementTypes.TAG_NAME) {
                        return false;
                    }
                    prevSibling = prevSibling.getPrevSibling();
                }
            }
        }
        return false;
    }

    private LookupElement createLookupElement(final @NotNull NameValueDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/play/completion/PlayGroovyCompletionContributor", "createLookupElement"));
        }
        String name = descriptor.getName();
        assert (name != null);
        return LookupElementBuilder.create((String)(name + descriptor.getTailText())).withPresentableText(name).bold().withIcon(PlayIcons.PlayAttr).withTypeText(descriptor.getPresentableText(), true).withInsertHandler((InsertHandler)new InsertHandler<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElement item) {
                PsiDocumentManager.getInstance((Project)context.getProject()).commitDocument(context.getEditor().getDocument());
                if (descriptor.isStringExpression()) {
                    context.getEditor().getCaretModel().moveToOffset(context.getSelectionEndOffset() - 1);
                } else {
                    AutoPopupController.getInstance((Project)context.getProject()).scheduleAutoPopup(context.getEditor());
                }
            }
        });
    }
}

