/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.steps.reference;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.TokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.cucumber.psi.GherkinElementTypes;
import org.jetbrains.plugins.cucumber.psi.GherkinTokenTypes;
import org.jetbrains.plugins.cucumber.psi.impl.GherkinStepImpl;
import org.jetbrains.plugins.cucumber.steps.reference.CucumberStepReference;

public class CucumberStepReferenceProvider
extends PsiReferenceProvider {
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReferenceProvider", "getReferencesByElement"));
        }
        if (element instanceof GherkinStepImpl) {
            TokenSet textAndParamSet = TokenSet.create((IElementType[])new IElementType[]{GherkinTokenTypes.TEXT, GherkinTokenTypes.STEP_PARAMETER_TEXT, GherkinTokenTypes.STEP_PARAMETER_BRACE, GherkinElementTypes.STEP_PARAMETER});
            ASTNode textNode = element.getNode().findChildByType(textAndParamSet);
            textAndParamSet = TokenSet.orSet((TokenSet[])new TokenSet[]{textAndParamSet, TokenSet.create((IElementType[])new IElementType[]{TokenType.WHITE_SPACE})});
            if (textNode != null) {
                int end;
                int start = textNode.getTextRange().getStartOffset();
                int endBeforeSpace = end = textNode.getTextRange().getEndOffset();
                for (textNode = textNode.getTreeNext(); textNode != null && textAndParamSet.contains(textNode.getElementType()); textNode = textNode.getTreeNext()) {
                    endBeforeSpace = textNode.getElementType() == TokenType.WHITE_SPACE ? end : textNode.getTextRange().getEndOffset();
                    end = textNode.getTextRange().getEndOffset();
                }
                TextRange tr = new TextRange(start, endBeforeSpace);
                CucumberStepReference reference = new CucumberStepReference(element, tr.shiftRight(-element.getTextOffset()));
                PsiReference[] psiReferenceArray = new PsiReference[]{reference};
                if (psiReferenceArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReferenceProvider", "getReferencesByElement"));
                }
                return psiReferenceArray;
            }
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/steps/reference/CucumberStepReferenceProvider", "getReferencesByElement"));
        }
        return PsiReference.EMPTY_ARRAY;
    }
}

