/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.psi.JSElementFactory;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSTypeDeclarationOwner;
import com.intellij.lang.javascript.psi.ecma6.JSTypeDeclaration;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.intellij.idea.lang.javascript.intention.JSIntention;
import org.jetbrains.annotations.NotNull;

public class JSRemoveTypeDeclarationIntention
extends JSIntention {
    private static final JSElementPredicate PREDICATE = new JSElementPredicate(){

        public boolean satisfiedBy(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSRemoveTypeDeclarationIntention$1", "satisfiedBy"));
            }
            if (!(element instanceof JSTypeDeclarationOwner) && !(element instanceof JSFunction)) {
                return false;
            }
            DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)element);
            return holder != null && holder.hasFeature(JSLanguageFeature.TYPES) && JSRemoveTypeDeclarationIntention.getTypeElement(element) != null;
        }
    };

    private static PsiElement getTypeElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSRemoveTypeDeclarationIntention", "getTypeElement"));
        }
        if (element instanceof JSTypeDeclaration || element.getParent() instanceof JSTypeDeclaration) {
            return null;
        }
        if (element instanceof JSTypeDeclarationOwner) {
            return ((JSTypeDeclarationOwner)element).getTypeElement();
        }
        if (element instanceof JSFunction) {
            return ((JSFunction)element).getReturnTypeElement();
        }
        return null;
    }

    @Override
    protected void processIntention(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/JSRemoveTypeDeclarationIntention", "processIntention"));
        }
        if (!PREDICATE.satisfiedBy(element)) {
            return;
        }
        ASTNode variableNode = element.getNode();
        ASTNode colonNode = variableNode.findChildByType(JSTokenTypes.COLON);
        if (colonNode == null) {
            return;
        }
        variableNode.removeChild(colonNode);
        PsiElement typeElement = JSRemoveTypeDeclarationIntention.getTypeElement(element);
        if (typeElement == null) {
            return;
        }
        JSElementFactory.removeElement((PsiElement)typeElement);
        JSElementFactory.reformat((PsiElement)element);
    }

    @Override
    @NotNull
    protected JSElementPredicate getElementPredicate() {
        JSElementPredicate jSElementPredicate = PREDICATE;
        if (jSElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/idea/lang/javascript/intention/initialization/JSRemoveTypeDeclarationIntention", "getElementPredicate"));
        }
        return jSElementPredicate;
    }
}

