/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.idea.lang.javascript.intention.initialization;

import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSForStatement;
import com.intellij.lang.javascript.psi.JSInitializerOwner;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptVariable;
import com.intellij.lang.javascript.psi.impl.ErrorUtil;
import com.intellij.lang.javascript.psi.impl.JSElementPredicate;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

abstract class TypeScriptVariableOrFieldPredicate
implements JSElementPredicate {
    TypeScriptVariableOrFieldPredicate() {
    }

    public boolean satisfiedBy(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/intellij/idea/lang/javascript/intention/initialization/TypeScriptVariableOrFieldPredicate", "satisfiedBy"));
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        if (!(element instanceof TypeScriptVariable) && !(element instanceof JSField)) {
            return false;
        }
        PsiElement statement = element.getParent();
        if (ErrorUtil.containsError((PsiElement)statement) || !(statement instanceof JSVarStatement)) {
            return false;
        }
        if (statement.getParent() instanceof JSForStatement) {
            return false;
        }
        return this.checkVariableOrField((JSInitializerOwner)element);
    }

    protected abstract boolean checkVariableOrField(@NotNull JSInitializerOwner var1);
}

