/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.reference;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.paths.PathReferenceManager;
import com.intellij.openapi.paths.PathReferenceProvider;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.patterns.XmlAttributeValuePattern;
import com.intellij.patterns.XmlPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.psi.css.impl.util.CssInHtmlClassOrIdReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdRefReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.IdReferenceProvider;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.struts2.reference.StaticStringValuesReferenceProvider;
import com.intellij.struts2.reference.TaglibUtil;
import com.intellij.struts2.reference.WrappedPropertiesReferenceProvider;
import com.intellij.struts2.reference.jsp.ActionPropertyReferenceProvider;
import com.intellij.struts2.reference.jsp.ActionReferenceProvider;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ProcessingContext;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class StrutsTaglibReferenceContributorBase
extends PsiReferenceContributor {
    protected static final PsiReferenceProvider CSS_CLASS_PROVIDER = new CssInHtmlClassOrIdReferenceProvider();
    private static final PsiReferenceProvider BOOLEAN_VALUE_REFERENCE_PROVIDER = new StaticStringValuesReferenceProvider(false, "false", "true");
    protected static final PsiReferenceProvider ACTION_REFERENCE_PROVIDER = new ActionReferenceProvider();
    protected static final PsiReferenceProvider ACTION_PROPERTY_REFERENCE_PROVIDER = new ActionPropertyReferenceProvider(true);
    protected static final PsiReferenceProvider RELATIVE_PATH_PROVIDER = new PsiReferenceProvider(){

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$1", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$1", "getReferencesByElement"));
            }
            String pathValue = ((XmlAttributeValue)element).getValue();
            PsiReference[] psiReferenceArray = PathReferenceManager.getInstance().createReferences(element, TaglibUtil.isDynamicExpression(pathValue), false, true, new PathReferenceProvider[0]);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$1", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    };
    protected static final PsiReferenceProvider HTML_ID_REFERENCE_PROVIDER = new PsiReferenceProvider(){

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$2", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$2", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new IdRefReference(element)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$2", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    };
    protected static final PsiReferenceProvider ID_REFERENCE_PROVIDER = new PsiReferenceProvider(){

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement psiElement, @NotNull ProcessingContext processingContext) {
            if (psiElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$3", "getReferencesByElement"));
            }
            if (processingContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processingContext", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$3", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new IdReferenceProvider.GlobalAttributeValueSelfReference(psiElement, false)};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$3", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    };
    protected final PsiReferenceProvider wrappedPropertiesProvider = new WrappedPropertiesReferenceProvider();
    private final XmlAttributeValuePattern jspElementPattern = (XmlAttributeValuePattern)((XmlAttributeValuePattern)XmlPatterns.xmlAttributeValue().inVirtualFile(StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.virtualFile().ofType((FileType)StdFileTypes.JSP), PlatformPatterns.virtualFile().ofType((FileType)StdFileTypes.JSPX)}))).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withNamespace(this.getNamespace()));

    @NonNls
    @NotNull
    protected abstract String getNamespace();

    protected void registerTags(PsiReferenceProvider provider, @NonNls String attributeName, PsiReferenceRegistrar registrar, String ... tagNames) {
        registrar.registerReferenceProvider(StandardPatterns.and((ElementPattern[])new ElementPattern[]{XmlPatterns.xmlAttributeValue().withLocalName(new String[]{attributeName}).withSuperParent(2, (ElementPattern)XmlPatterns.xmlTag().withLocalName(tagNames)), this.jspElementPattern}), provider);
    }

    protected void registerBoolean(@NonNls String attributeName, PsiReferenceRegistrar registrar, String ... tagNames) {
        this.registerTags(BOOLEAN_VALUE_REFERENCE_PROVIDER, attributeName, registrar, tagNames);
    }

    protected static class HtmlIdWithAdditionalVariantsReferenceProvider
    extends PsiReferenceProvider {
        private final String[] additionalVariants;

        protected HtmlIdWithAdditionalVariantsReferenceProvider(String ... additionalVariants) {
            Arrays.sort(additionalVariants);
            this.additionalVariants = additionalVariants;
        }

        @NotNull
        public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$HtmlIdWithAdditionalVariantsReferenceProvider", "getReferencesByElement"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$HtmlIdWithAdditionalVariantsReferenceProvider", "getReferencesByElement"));
            }
            PsiReference[] psiReferenceArray = new PsiReference[]{new IdRefReference(element){

                public PsiElement resolve() {
                    PsiElement resolve = super.resolve();
                    if (resolve != null) {
                        return resolve;
                    }
                    return Arrays.binarySearch(additionalVariants, ((XmlAttributeValue)this.myElement).getValue()) > -1 ? this.myElement : null;
                }

                @NotNull
                public Object[] getVariants() {
                    Object[] objectArray = ArrayUtil.mergeArrays((Object[])super.getVariants(), (Object[])additionalVariants);
                    if (objectArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$HtmlIdWithAdditionalVariantsReferenceProvider$1", "getVariants"));
                    }
                    return objectArray;
                }
            }};
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/reference/StrutsTaglibReferenceContributorBase$HtmlIdWithAdditionalVariantsReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
    }
}

