/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.gwt.web;

import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetType;
import com.intellij.facet.FacetTypeRegistry;
import com.intellij.gwt.facet.GwtFacet;
import com.intellij.gwt.facet.GwtFacetConfiguration;
import com.intellij.gwt.module.model.GwtModule;
import com.intellij.javaee.DeploymentDescriptorsConstants;
import com.intellij.javaee.web.WebRoot;
import com.intellij.javaee.web.WebUtil;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.descriptors.ConfigFileFactory;
import com.intellij.util.descriptors.ConfigFileMetaData;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GwtWebUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.gwt.web.GwtWebUtil");

    private GwtWebUtil() {
    }

    public static WebFacet createWebFacet(@NotNull GwtFacet facet, @NotNull VirtualFile root) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/intellij/gwt/web/GwtWebUtil", "createWebFacet"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/gwt/web/GwtWebUtil", "createWebFacet"));
        }
        Project project = facet.getModule().getProject();
        ConfigFileMetaData webXml = DeploymentDescriptorsConstants.WEB_XML_META_DATA;
        String webRootUrl = root.getUrl() + "/war";
        String webXmlUrl = webRootUrl + "/" + webXml.getDirectoryPath() + "/" + webXml.getFileName();
        FacetType webFacetType = FacetTypeRegistry.getInstance().findFacetType(WebFacet.ID);
        WebFacet webFacet = (WebFacet)FacetManager.getInstance((Module)facet.getModule()).addFacet(webFacetType, webFacetType.getDefaultFacetName(), null);
        webFacet.addWebRoot(webRootUrl, "/");
        ConfigFileFactory.getInstance().createFile(project, webXmlUrl, webXml.getDefaultVersion(), false);
        webFacet.getDescriptorsContainer().getConfiguration().replaceConfigFile(webXml, webXmlUrl);
        ((GwtFacetConfiguration)facet.getConfiguration()).setWebFacetName(webFacet.getName());
        return webFacet;
    }

    @NotNull
    public static String getOutputPath(@NotNull GwtModule gwtModule, @NotNull String relativePath) {
        if (gwtModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gwtModule", "com/intellij/gwt/web/GwtWebUtil", "getOutputPath"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "com/intellij/gwt/web/GwtWebUtil", "getOutputPath"));
        }
        String string = gwtModule.getOutputName() + "/" + relativePath;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/gwt/web/GwtWebUtil", "getOutputPath"));
        }
        return string;
    }

    @Nullable
    public static String getRelativeToWebRootPath(@NotNull VirtualFile htmlFile, @NotNull Project project) {
        VirtualFile rootFile;
        WebRoot webRoot;
        if (htmlFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlFile", "com/intellij/gwt/web/GwtWebUtil", "getRelativeToWebRootPath"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/gwt/web/GwtWebUtil", "getRelativeToWebRootPath"));
        }
        WebFacet webFacet = WebUtil.findFacetByFileUnderWebRoot((VirtualFile)htmlFile, (Project)project);
        if (webFacet != null && (webRoot = WebUtil.findParentWebRoot((VirtualFile)htmlFile, (List)webFacet.getWebRoots())) != null && (rootFile = webRoot.getFile()) != null) {
            return VfsUtilCore.getRelativePath((VirtualFile)htmlFile, (VirtualFile)rootFile, (char)'/');
        }
        return null;
    }
}

