/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.debugger.wip.extension;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.impl.http.DefaultRemoteContentProvider;
import com.intellij.util.ObjectUtils;
import com.intellij.util.UriUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.io.HttpRequests;
import com.intellij.util.io.RequestBuilder;
import com.intellij.util.net.NetUtils;
import com.jetbrains.debugger.wip.extension.ScriptSourceUrlAppender;
import com.jetbrains.debugger.wip.extension.ScriptSourceUrlAppenderKt;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.HttpRequestHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.rpc.CommandProcessorKt;
import org.jetbrains.wip.WipVm;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J \u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\r"}, d2={"Lcom/jetbrains/debugger/wip/extension/ScriptSourceUrlAppender;", "Lorg/jetbrains/ide/HttpRequestHandler;", "()V", "isSupported", "", "request", "Lio/netty/handler/codec/http/FullHttpRequest;", "process", "urlDecoder", "Lio/netty/handler/codec/http/QueryStringDecoder;", "inRequest", "context", "Lio/netty/channel/ChannelHandlerContext;", "ChromeConnector"})
final class ScriptSourceUrlAppender
extends HttpRequestHandler {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSupported(@NotNull FullHttpRequest request) {
        Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
        if (!super.isSupported(request)) return false;
        String string = request.uri();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"request.uri()");
        if (!HttpRequestHandler.Companion.checkPrefix(string, ScriptSourceUrlAppenderKt.access$getUUID$p())) return false;
        return true;
    }

    public boolean process(@NotNull QueryStringDecoder urlDecoder, @NotNull FullHttpRequest inRequest, @NotNull ChannelHandlerContext context) {
        Intrinsics.checkParameterIsNotNull((Object)urlDecoder, (String)"urlDecoder");
        Intrinsics.checkParameterIsNotNull((Object)inRequest, (String)"inRequest");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int index = ScriptSourceUrlAppenderKt.access$getUUID$p().length() + 2;
        int endIndex = StringsKt.indexOf$default((CharSequence)inRequest.uri(), (char)'/', (int)(index + 1), (boolean)false, (int)4, null);
        Channel channel = context.channel();
        String string = inRequest.uri();
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(index, endIndex);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        WipVm vm = ScriptSourceUrlAppenderKt.access$findVm(Integer.parseInt(string3));
        if (vm == null) {
            Channel channel2 = channel;
            Intrinsics.checkExpressionValueIsNotNull((Object)channel2, (String)"channel");
            Responses.send$default((HttpResponseStatus)HttpResponseStatus.INTERNAL_SERVER_ERROR, (Channel)channel2, (HttpRequest)((HttpRequest)inRequest), null, null, (int)12, null);
            return true;
        }
        Object object = inRequest.uri();
        int n = endIndex + 1;
        Base64.Decoder decoder = Base64.getDecoder();
        String string4 = object;
        if (string4 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string5 = string4.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
        String string6 = string5;
        byte[] byArray = decoder.decode(string6);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"Base64.getDecoder().deco\u2026.substring(endIndex + 1))");
        object = byArray;
        String originalUrl = new String((byte[])object, Charsets.UTF_8);
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(originalUrl, channel, inRequest){
            final /* synthetic */ String $originalUrl;
            final /* synthetic */ Channel $channel;
            final /* synthetic */ FullHttpRequest $inRequest;

            public final void run() {
                try {
                    DefaultRemoteContentProvider.addRequestTuner((Url)Urls.newFromEncoded((String)this.$originalUrl), (RequestBuilder)HttpRequests.request((String)this.$originalUrl)).connect(new HttpRequests.RequestProcessor(this){
                        final /* synthetic */ process.1 this$0;

                        @Nullable
                        public final Void process(@NotNull HttpRequests.Request request) {
                            Intrinsics.checkParameterIsNotNull((Object)request, (String)"request");
                            URLConnection connection = request.getConnection();
                            int contentLength = connection.getContentLength();
                            BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
                            NetUtils.copyStreamContent((ProgressIndicator)null, (InputStream)request.getInputStream(), (OutputStream)((OutputStream)out), (int)contentLength);
                            byte[] byArray = out.getInternalBuffer();
                            Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"out.internalBuffer");
                            byte[] byArray2 = byArray;
                            int n = 0;
                            int n2 = out.size();
                            Charset charset = CharsetToolkit.UTF8_CHARSET;
                            Intrinsics.checkExpressionValueIsNotNull((Object)charset, (String)"CharsetToolkit.UTF8_CHARSET");
                            Charset charset2 = charset;
                            String content = new String(byArray2, n, n2, charset2);
                            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, ByteBufUtil.encodeString((ByteBufAllocator)ByteBufAllocator.DEFAULT, (CharBuffer)CharBuffer.wrap(content + "\n//# sourceURL=" + UriUtil.trimParameters((String)this.this$0.$originalUrl)), (Charset)CharsetUtil.UTF_8));
                            Responses.addNoCache((HttpResponse)((HttpResponse)response));
                            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)connection.getHeaderField("Content-Type"));
                            String sourceMapHeader = (String)ObjectUtils.chooseNotNull((Object)connection.getHeaderField("X-SourceMap"), (Object)connection.getHeaderField("SourceMap"));
                            if (!StringUtil.isEmpty((String)sourceMapHeader)) {
                                response.headers().set("X-SourceMap", (Object)sourceMapHeader);
                                response.headers().set("SourceMap", (Object)sourceMapHeader);
                            }
                            HttpResponse httpResponse = (HttpResponse)response;
                            Channel channel = this.this$0.$channel;
                            Intrinsics.checkExpressionValueIsNotNull((Object)channel, (String)"channel");
                            Responses.send$default((HttpResponse)httpResponse, (Channel)channel, (HttpRequest)((HttpRequest)this.this$0.$inRequest), null, (int)4, null);
                            return null;
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                catch (IOException e) {
                    CommandProcessorKt.getLOG().error((Throwable)e);
                }
            }
            {
                this.$originalUrl = string;
                this.$channel = channel;
                this.$inRequest = fullHttpRequest;
            }
        });
        return true;
    }
}

