/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.batch.references;

import com.intellij.batch.model.BatchJobXmlModel;
import com.intellij.batch.model.BatchXmlDomModelManager;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.hash.HashSet;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BatchJobXmlFileReference
extends PsiReferenceBase<PsiElement> {
    public BatchJobXmlFileReference(PsiLiteral element) {
        this(element, ElementManipulators.getManipulator((PsiElement)element).getRangeInElement((PsiElement)element));
    }

    public BatchJobXmlFileReference(PsiLiteral element, TextRange range) {
        super((PsiElement)element, range);
    }

    public PsiElement resolve() {
        String value = this.getValue();
        for (XmlFile xmlFile : this.getAllJobXmlFiles()) {
            String name = xmlFile.getName();
            if (!FileUtil.getNameWithoutExtension((String)name).equals(value)) continue;
            return xmlFile;
        }
        return null;
    }

    @NotNull
    private Set<XmlFile> getAllJobXmlFiles() {
        HashSet files = new HashSet();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myElement);
        if (module != null) {
            for (BatchJobXmlModel jobXmlModel : BatchXmlDomModelManager.getInstance(module.getProject()).getAllBatchJobModels(module)) {
                files.addAll(jobXmlModel.getConfigFiles());
            }
        }
        HashSet hashSet = files;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/references/BatchJobXmlFileReference", "getAllJobXmlFiles"));
        }
        return hashSet;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/batch/references/BatchJobXmlFileReference", "bindToElement"));
        }
        return this.getElement();
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return super.handleElementRename(FileUtil.getNameWithoutExtension((String)newElementName));
    }

    @NotNull
    public Object[] getVariants() {
        ArrayList<LookupElementBuilder> lookups = new ArrayList<LookupElementBuilder>();
        for (XmlFile file : this.getAllJobXmlFiles()) {
            String fileName = file.getName();
            lookups.add(LookupElementBuilder.create((String)FileUtil.getNameWithoutExtension((String)fileName)).withTypeText(fileName));
        }
        Object[] objectArray = ArrayUtil.toObjectArray(lookups);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/batch/references/BatchJobXmlFileReference", "getVariants"));
        }
        return objectArray;
    }
}

