/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.engines.cxf;

import com.intellij.facet.FacetManager;
import com.intellij.javaee.web.facet.WebFacet;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.WsJavaExternalProcessHandler;
import com.intellij.ws.actions.EnableWebServicesSupportUtils;
import com.intellij.ws.engines.LibraryDescriptor;
import com.intellij.ws.engines.LibraryInfo;
import com.intellij.ws.engines.cxf.CxfUtils;
import com.intellij.ws.engines.wsengine.DeployWebServiceOptions;
import com.intellij.ws.engines.wsengine.GenerateJavaFromWsdlOptions;
import com.intellij.ws.engines.wsengine.GenerateWsdlFromJavaOptions;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.engines.wsengine.WSEngineUtils;
import com.intellij.ws.utils.CommonWsUtils;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.ExternalProcessHandler;
import com.intellij.ws.utils.FileUtils;
import com.intellij.ws.utils.InvokeExternalCodeUtil;
import com.intellij.ws.utils.LibUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CXFWSEngine
implements WSEngine {
    public static final String CXF_WADL_2_JAVA_FQN = "org.apache.cxf.tools.wadlto.WADLToJava";
    private static final String CXF_LIBRARY_NAME = "CXF";
    private static final String CXF_RT_LIBRARY_NAME = "CXF Runtime";
    private static final String JAXB_2_0_MAPPING_TYPE = "JAXB 2.0";
    private static final String CXF_PLATFORM = WSBundle.message("cxf.display.name", new Object[0]);
    @NonNls
    private static final String[] CXF_PATH_COMPONENTS = new String[]{"WEB-INF", "cxf-servlet.xml"};
    @NonNls
    private static final Set<String> ourExcludeJarNamesSet = new HashSet<String>();

    @Override
    public String getName() {
        return CXF_PLATFORM;
    }

    @Override
    public LibraryDescriptor[] getLibraryDescriptors(String bindingType, boolean isForGeneratedCode) {
        String xFirePath = WebServicesPluginSettings.getInstance().getCXFPath();
        File[] xfireLibFiles = CXFWSEngine.buildListOfJarsInLibDirectory(xFirePath + "/lib", bindingType, isForGeneratedCode);
        String[] xfireLibPathes = new String[xfireLibFiles.length];
        for (int i = 0; i < xfireLibFiles.length; ++i) {
            xfireLibPathes[i] = WSEngineUtils.stripPrefixPath(xfireLibFiles[i].getAbsolutePath(), xFirePath);
        }
        String libName = isForGeneratedCode ? CXF_RT_LIBRARY_NAME : CXF_LIBRARY_NAME;
        return new LibraryDescriptor[]{new LibraryInfo(libName, xfireLibPathes)};
    }

    private static File[] buildListOfJarsInLibDirectory(String s1, String bindingType, boolean generatedCode) {
        File[] xfireLibFiles = new File(s1).listFiles((file, filename) -> {
            boolean isjar = filename.endsWith(".jar");
            if (isjar) {
                for (String s : ourExcludeJarNamesSet) {
                    if (filename.indexOf(s) < 0) continue;
                    return false;
                }
                if (filename.indexOf("jaxb") != -1) {
                    if (generatedCode && filename.indexOf("xjc") != -1) {
                        return false;
                    }
                    if (JAXB_2_0_MAPPING_TYPE.equals(bindingType)) {
                        return filename.indexOf("-1.0") == -1;
                    }
                    return generatedCode && bindingType == null || filename.indexOf("xjc") != -1;
                }
            }
            return isjar;
        });
        return xfireLibFiles;
    }

    @Override
    public String getBasePath() {
        return WebServicesPluginSettings.getInstance().getCXFPath();
    }

    @Override
    public boolean hasSeparateClientServerJavaCodeGenerationOption() {
        return true;
    }

    @Override
    public boolean allowsTestCaseGeneration() {
        return false;
    }

    @Override
    @Nullable
    public String[] getSupportedMappingTypesForJavaFromWsdl() {
        return new String[]{JAXB_2_0_MAPPING_TYPE};
    }

    @Override
    public String getDeploymentServletName() {
        return "cxf";
    }

    @Override
    public String getDeploymentServletClassName() {
        return "org.apache.cxf.transport.servlet.CXFServlet";
    }

    @Override
    public void doAdditionalWSServerSetup(Module currentModule, WebFacet webFacet) {
        CommonWsUtils.addFileToModuleFromTemplate((Module)currentModule, (String[])CXF_PATH_COMPONENTS, (InputStream)LibUtils.getResourcesStream("cxf-servlet.xml"), (boolean)true, (boolean)false, (WebFacet)webFacet);
    }

    @Override
    public String checkNotAcceptableClassForGenerateWsdl(PsiClass clazz) {
        return null;
    }

    @Override
    public String checkNotAcceptableClassForDeployment(PsiClass clazz) {
        return null;
    }

    @Override
    public void generateWsdlFromJava(GenerateWsdlFromJavaOptions options, Consumer<File> onSuccessAction, Consumer<Exception> onException, Runnable editAgain) {
        File tempDir;
        PsiClass psiClass = options.getClassForOperation();
        String generateWsdlDir = psiClass.getContainingFile().getContainingDirectory().getVirtualFile().getPath();
        File tempFile = new File(generateWsdlDir + "/" + psiClass.getName() + ".wsdl");
        try {
            tempDir = FileUtils.createTempDir((String)"cxf");
        }
        catch (IOException e) {
            onException.consume((Object)e);
            return;
        }
        WsJavaExternalProcessHandler externalProcessHandler = this.buildGenerateWsdlFromJavaHandler(options, tempFile, psiClass, tempDir, onException);
        if (externalProcessHandler == null) {
            return;
        }
        InvokeExternalCodeUtil.invokeExternalProcess2((ExternalProcessHandler)externalProcessHandler, (Project)options.getModule().getProject(), () -> {
            try {
                FileUtils.copyWsdlWithReplacementOfSoapAddress((File)tempFile, (File)tempFile, (String)"http://localhost:9090/hello", (String)options.getWebServiceURL());
                options.getSuccessRunnable(onSuccessAction, tempFile).run();
            }
            catch (IOException ex) {
                onException.consume((Object)ex);
            }
        }, onException, options.isParametersStillValidPredicate(), (Runnable)editAgain);
    }

    private WsJavaExternalProcessHandler buildGenerateWsdlFromJavaHandler(GenerateWsdlFromJavaOptions options, File tempFile, PsiClass psiClass, File marshalledCodeDir, Consumer<Exception> onException) {
        String canonicalPath;
        Object[] classpath = options.getClassPathEntries();
        LinkedList<String> parameters = new LinkedList<String>();
        String className = CxfUtils.getJavaToWsdlClassName((String[])classpath);
        String title = "Generate CXF Wsdl";
        parameters.add("-o");
        parameters.add(tempFile.getPath());
        parameters.add("-t");
        parameters.add(options.getWebServiceNamespace());
        parameters.add("-cp");
        String cp = InvokeExternalCodeUtil.buildClasspathForModule((Module)options.getModule());
        try {
            canonicalPath = marshalledCodeDir.getCanonicalPath();
        }
        catch (IOException ex) {
            onException.consume((Object)ex);
            return null;
        }
        parameters.add(cp.concat(InvokeExternalCodeUtil.CLASS_PATH_SEPARATOR).concat(canonicalPath));
        classpath = (String[])ArrayUtil.append((Object[])classpath, (Object)canonicalPath);
        parameters.add("-s");
        parameters.add(canonicalPath);
        parameters.add("-classdir");
        parameters.add(canonicalPath);
        if (CxfUtils.isCxf21Home(this.getBasePath())) {
            parameters.add("-wsdl");
        }
        FileUtils.addClassAsCompilerResource((Project)options.getModule().getProject());
        parameters.add(psiClass.getQualifiedName());
        WsJavaExternalProcessHandler processHandler = new WsJavaExternalProcessHandler(title, className, (String[])classpath, ArrayUtil.toStringArray(parameters), options.getModule(), false);
        processHandler.addCommandLineProperty("java.util.logging.config.file", this.getBasePath() + "/etc/logging.properties");
        processHandler.setOutputConsumer(CXFWSEngine.createCxfOutputFilter());
        return processHandler;
    }

    public static InvokeExternalCodeUtil.OutputConsumer createCxfOutputFilter() {
        return new InvokeExternalCodeUtil.OutputConsumer(){

            public boolean handle(String output, String errOutput) throws InvokeExternalCodeUtil.ExternalCodeException {
                if (errOutput.indexOf("Error") != -1) {
                    throw new InvokeExternalCodeUtil.ExternalCodeException(errOutput);
                }
                if (output.length() > 0) {
                    throw new InvokeExternalCodeUtil.ExternalCodeException(output);
                }
                return false;
            }
        };
    }

    @Override
    public String[] getWebServicesOperations(String webServiceName, Module module) {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @Override
    public void deployWebService(DeployWebServiceOptions createOptions, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSuccessAction", "com/intellij/ws/engines/cxf/CXFWSEngine", "deployWebService"));
        }
        if (onExceptionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onExceptionAction", "com/intellij/ws/engines/cxf/CXFWSEngine", "deployWebService"));
        }
        DeployUtils.addToConfigFile(CXF_PATH_COMPONENTS, true, module, "<jaxws:endpoint\n        id=\"" + createOptions.getWsName() + "\"\n        implementor=\"" + createOptions.getWsClassName() + "\"\n        address=\"/" + createOptions.getWsName() + "\">\n                <jaxws:features>\n                     <bean class=\"org.apache.cxf.feature.LoggingFeature\"/>\n                </jaxws:features>\n    </jaxws:endpoint>", this);
        onSuccessAction.run();
    }

    @Override
    public void undeployWebService(String webServiceName, Module module, @NotNull Runnable onSuccessAction, @NotNull Consumer<Exception> onExceptionAction, Runnable restartAction) {
        if (onSuccessAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSuccessAction", "com/intellij/ws/engines/cxf/CXFWSEngine", "undeployWebService"));
        }
        if (onExceptionAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onExceptionAction", "com/intellij/ws/engines/cxf/CXFWSEngine", "undeployWebService"));
        }
        DeployUtils.removeFromConfigFile(CXF_PATH_COMPONENTS, true, module, (Processor<XmlTag>)((Processor)xmlTag -> webServiceName.equals(xmlTag.getAttributeValue("id"))));
        onSuccessAction.run();
    }

    @Override
    public String[] getAvailableWebServices(Module module) {
        ArrayList availableWS = new ArrayList(1);
        DeployUtils.processTagsInConfigFile(CXF_PATH_COMPONENTS, true, module, (Processor<XmlTag>)((Processor)xmlTag -> {
            String name = xmlTag.getAttributeValue("id");
            if (name != null) {
                availableWS.add(name);
            }
            return true;
        }));
        return ArrayUtil.toStringArray(availableWS);
    }

    @Override
    public ExternalProcessHandler getGenerateJavaFromWsdlHandler(GenerateJavaFromWsdlOptions options) {
        return this.getGenerateJavaFromWsdlHandlerForCxf(options);
    }

    @Override
    public boolean isConfigured() {
        return this.getBasePath() != null;
    }

    private ExternalProcessHandler getGenerateJavaFromWsdlHandlerForCxf(GenerateJavaFromWsdlOptions options) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-d");
        parameters.add(options.getOutputPath());
        parameters.add("-p");
        parameters.add(options.getPackagePrefix());
        if (options.isServersideSkeletonGeneration()) {
            parameters.add("-server");
        } else {
            parameters.add("-client");
        }
        File savedWsdlFile = options.getSavedWsdlFile();
        parameters.add(savedWsdlFile.getPath());
        WsJavaExternalProcessHandler processHandler = new WsJavaExternalProcessHandler("CXF Wsdl2Java", "org.apache.cxf.tools.wsdlto.WSDLToJava", LibUtils.getLibsUrlsFromLibInfos(this.getLibraryDescriptors(options.getBindingType(), false), this.getBasePath()), ArrayUtil.toStringArray(parameters), options.getSelectedModule(), false);
        processHandler.addCommandLineProperty("java.util.logging.config.file", this.getBasePath() + "/etc/logging.properties");
        return processHandler;
    }

    public ExternalProcessHandler getGenerateJavaFromWadlHandler(String outputPath, String packagePrefix, String wadlPath, Module selectedModule) {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-d");
        parameters.add(outputPath);
        parameters.add("-p");
        parameters.add(packagePrefix);
        parameters.add("-verbose");
        parameters.add(wadlPath);
        WsJavaExternalProcessHandler processHandler = new WsJavaExternalProcessHandler("CXF Wadl2Java", CXF_WADL_2_JAVA_FQN, LibUtils.getLibsUrlsFromLibInfos(this.getLibraryDescriptors(null, false), this.getBasePath()), ArrayUtil.toStringArray(parameters), selectedModule, false);
        processHandler.addCommandLineProperty("java.util.logging.config.file", this.getBasePath() + "/etc/logging.properties");
        return processHandler;
    }

    @Override
    public boolean supportsJaxWs2() {
        return false;
    }

    @Override
    public boolean deploymentSupported() {
        return true;
    }

    @Override
    public String getServiceInvocationTemplateName() {
        return "ixws";
    }

    @Override
    public String getWebServicesInterfaceTemplateName() {
        return "cxf.webservice.interface.java";
    }

    @Override
    public String getWebServicesTemplateName() {
        return "cxf.webservice.java";
    }

    public void registerRestfulService(String className, String packageQName, VirtualFile vfile, final Module module) {
        ArrayList<VirtualFile> filesToCompile = new ArrayList<VirtualFile>();
        VirtualFile interfaceFile = EnableWebServicesSupportUtils.createInterfaceFile(module, packageQName, className, "rest.cxf.webservice.interface.java");
        assert (interfaceFile != null);
        filesToCompile.add(interfaceFile);
        WebFacet webFacet = (WebFacet)FacetManager.getInstance((Module)module).getFacetByType(WebFacet.ID);
        this.doAdditionalWSServerSetup(module, webFacet);
        filesToCompile.add(vfile);
        final String qClassName = StringUtil.getQualifiedName((String)packageQName, (String)className);
        String iName = interfaceFile.getNameWithoutExtension();
        assert (iName.length() > 0);
        final String decapitalizedInterfaceName = Character.toLowerCase(iName.charAt(0)) + iName.substring(1);
        CompilerManager.getInstance((Project)module.getProject()).compile(VfsUtilCore.toVirtualFileArray(filesToCompile), new CompileStatusNotification(){

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (!aborted && errors == 0) {
                    DeployUtils.addToConfigFile(CXF_PATH_COMPONENTS, true, module, "<jaxrs:server id=\"base\" address=\"/\">\n        <jaxrs:serviceBeans>\n            <ref bean=\"" + decapitalizedInterfaceName + "\"/>\n        </jaxrs:serviceBeans>\n</jaxrs:server>\n", CXFWSEngine.this);
                    DeployUtils.addToConfigFile(CXF_PATH_COMPONENTS, true, module, "<bean id=\"" + decapitalizedInterfaceName + "\" class=\"" + qClassName + "\"/>", CXFWSEngine.this);
                }
            }
        });
    }

    static {
        ourExcludeJarNamesSet.add("servlet-api-");
        ourExcludeJarNamesSet.add("jetty-");
        ourExcludeJarNamesSet.add("-servlet_2.5_spec");
    }
}

