/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.access;

import com.intellij.concurrency.AsyncFutureFactory;
import com.intellij.concurrency.AsyncFutureResult;
import com.intellij.credentialStore.Credentials;
import com.intellij.database.access.DbCredentialManager;
import com.intellij.database.dataSource.DataSourceSshTunnelConfiguration;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.util.DbImplUtil;
import com.intellij.ide.passwordSafe.ui.PasswordPromptComponent;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.ExpirableRunnable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.PasswordUtil;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.util.concurrent.ExecutionException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DatabaseCredentials {
    private static final String DB_SSH_PWD = "db:ssh:pwd@";
    private static final String DB_SSH_PHR = "db:ssh:phr@";
    private static final DatabaseCredentials ourInstance = new DatabaseCredentials();
    private final DbCredentialManager dbCredentialManager = new DbCredentialManager();
    private static final Object ourEDTLock = new Object();

    public static DatabaseCredentials getInstance() {
        return ourInstance;
    }

    public static DatabaseCredentials newUIInstance() {
        return new DatabaseCredentials(){
            boolean myForceMemoryProvider;

            @Override
            public void persistCredentials(@NotNull DatabaseSystem info) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials$1", "persistCredentials"));
                }
                if (this.myForceMemoryProvider && info instanceof LocalDataSource && ((LocalDataSource)info).getSecretStorage() == StorageType.MASTER_KEY) {
                    ((LocalDataSource)info).setSecretStorage(StorageType.MEMORY);
                }
                super.persistCredentials(info);
            }
        };
    }

    @Nullable
    private static LocalDataSource getLocalDataSource(@Nullable DatabaseSystem info) {
        if (!(info instanceof LocalDataSource)) {
            return null;
        }
        if (!DbImplUtil.isAuthRequired((LocalDataSource)info)) {
            return null;
        }
        return (LocalDataSource)info;
    }

    protected static boolean isUseCredentialStore(@NotNull LocalDataSource dataSource, @NotNull StorageType storageType) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "isUseCredentialStore"));
        }
        if (storageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageType", "com/intellij/database/access/DatabaseCredentials", "isUseCredentialStore"));
        }
        return storageType != StorageType.EMBEDDED && dataSource.getUniqueId() != null;
    }

    @Nullable
    public Credentials getCredentials(@NotNull DatabaseSystem info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "getCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return null;
        }
        if (dataSource.getSecretStorage() == StorageType.EMBEDDED || dataSource.getUniqueId() == null) {
            return new Credentials(dataSource.getUsername(), dataSource.getPassword());
        }
        return new Credentials(dataSource.getUsername(), this.dbCredentialManager.getPasswordAsString(dataSource, null));
    }

    public boolean setCredentials(@NotNull DatabaseSystem info, @NotNull Credentials credentials) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "setCredentials"));
        }
        if (credentials == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "credentials", "com/intellij/database/access/DatabaseCredentials", "setCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return false;
        }
        dataSource.setUsername(credentials.getUserName());
        if (dataSource.getSecretStorage() == StorageType.EMBEDDED || dataSource.getUniqueId() == null) {
            dataSource.setPassword(credentials.getPasswordAsString());
        } else {
            this.dbCredentialManager.set(dataSource, credentials, dataSource.getSecretStorage() == StorageType.MEMORY);
        }
        return true;
    }

    public boolean removeCredentials(@NotNull DatabaseSystem info, @NotNull StorageType storageType) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "removeCredentials"));
        }
        if (storageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageType", "com/intellij/database/access/DatabaseCredentials", "removeCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null) {
            return false;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource, storageType)) {
            this.dbCredentialManager.set(dataSource, null);
        } else {
            dataSource.setPassword(null);
        }
        return true;
    }

    public void copyCredentials(@NotNull DatabaseSystem from, @NotNull DatabaseSystem to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/access/DatabaseCredentials", "copyCredentials"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/access/DatabaseCredentials", "copyCredentials"));
        }
        Credentials credentials = this.getCredentials(from);
        if (credentials != null && credentials.getUserName() != null) {
            this.setCredentials(to, credentials);
        }
    }

    public void persistCredentials(@NotNull DatabaseSystem info) {
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/access/DatabaseCredentials", "persistCredentials"));
        }
        LocalDataSource dataSource = DatabaseCredentials.getLocalDataSource(info);
        if (dataSource == null || dataSource.getSecretStorage() == StorageType.EMBEDDED) {
            return;
        }
        String uid = dataSource.getUsername();
        String pwd = dataSource.getPassword();
        dataSource.setPassword(null);
        dataSource.setUsername(uid);
        if (dataSource.getUniqueId() == null) {
            dataSource.setPassword(pwd);
        } else {
            this.dbCredentialManager.set(dataSource, new Credentials(uid, pwd), dataSource.getSecretStorage() == StorageType.MEMORY);
        }
    }

    @Nullable
    public Credentials askCredentialsWhenFailed(@NotNull Project project, @NotNull LocalDataSource dataSource, @NotNull String message, String userNameDef) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/access/DatabaseCredentials", "askCredentialsWhenFailed"));
        }
        if (DatabaseCredentials.getLocalDataSource((DatabaseSystem)dataSource) == null) {
            return null;
        }
        Credentials c1 = this.getCredentials((DatabaseSystem)dataSource);
        return (Credentials)this.invokeAndWait(() -> {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$0"));
            }
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$0"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/access/DatabaseCredentials", "lambda$askCredentialsWhenFailed$0"));
            }
            Credentials c2 = this.getCredentials((DatabaseSystem)dataSource);
            if (!Comparing.equal((Object)c1, (Object)c2)) {
                return c2;
            }
            PasswordPromptComponent component = new PasswordPromptComponent(dataSource.getSecretStorage() == StorageType.EMBEDDED || dataSource.getUniqueId() == null, message);
            component.setUserName(StringUtil.notNullize((String)userNameDef));
            DialogBuilder builder = new DialogBuilder(project);
            builder.setTitle("Connecting to '" + dataSource.getName() + "'...");
            builder.setCenterPanel(component.getComponent());
            builder.setPreferredFocusComponent(component.getPreferredFocusedComponent());
            builder.addOkAction();
            builder.addCancelAction();
            if (builder.show() != 0) {
                return null;
            }
            Credentials credentials = new Credentials(component.getUserName(), component.getPassword());
            dataSource.setUsername(credentials.getUserName());
            if (dataSource.getUniqueId() == null) {
                dataSource.setPassword(new String(component.getPassword()));
            } else {
                boolean remember = component.isRememberSelected();
                this.dbCredentialManager.set(dataSource, credentials, !remember);
                if (remember) {
                    dataSource.setSecretStorage(StorageType.MASTER_KEY);
                }
            }
            return credentials;
        }, project.getDisposed());
    }

    public <T, E extends Throwable> T invokeAndWait(final @NotNull ThrowableComputable<T, E> computable, final @NotNull Condition<?> expired) throws E {
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "com/intellij/database/access/DatabaseCredentials", "invokeAndWait"));
        }
        if (expired == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expired", "com/intellij/database/access/DatabaseCredentials", "invokeAndWait"));
        }
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            return (T)computable.compute();
        }
        final AsyncFutureResult future = AsyncFutureFactory.getInstance().createAsyncFutureResult();
        ExpirableRunnable runnable = new ExpirableRunnable(){

            public boolean isExpired() {
                boolean b = expired.value(null);
                if (b) {
                    future.setException((Throwable)new ProcessCanceledException());
                }
                return b;
            }

            public void run() {
                try {
                    future.set(computable.compute());
                }
                catch (Throwable e) {
                    future.setException(e);
                }
            }
        };
        ProgressIndicator indicator = ProgressIndicatorProvider.getGlobalProgressIndicator();
        Object object = ourEDTLock;
        synchronized (object) {
            if (indicator != null && indicator.isModal()) {
                UIUtil.invokeLaterIfNeeded(() -> {
                    if (!runnable.isExpired()) {
                        runnable.run();
                    }
                });
            } else {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(runnable);
            }
            try {
                return (T)future.get();
            }
            catch (InterruptedException e) {
                throw new ProcessCanceledException((Throwable)e);
            }
            catch (ExecutionException e) {
                throw e.getCause();
            }
        }
    }

    public void setSshCredentials(@NotNull LocalDataSource dataSource, char[] pwd, char[] phr) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "setSshCredentials"));
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        if (ssh == null || ssh.getSecretStorage() == StorageType.EMBEDDED || dataSource.getUniqueId() == null) {
            return;
        }
        this.dbCredentialManager.set(dataSource, new Credentials(dataSource.getUsername(), pwd), false, DB_SSH_PWD);
        this.dbCredentialManager.set(dataSource, new Credentials(dataSource.getUsername(), phr), false, DB_SSH_PHR);
    }

    public void removeSshCredentials(@NotNull LocalDataSource dataSource, @NotNull StorageType storageType) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "removeSshCredentials"));
        }
        if (storageType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageType", "com/intellij/database/access/DatabaseCredentials", "removeSshCredentials"));
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource, storageType)) {
            this.dbCredentialManager.set(dataSource, null, false, DB_SSH_PWD);
            this.dbCredentialManager.set(dataSource, null, false, DB_SSH_PHR);
        }
    }

    @NotNull
    public Pair<String, String> getSshCredentials(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
        }
        DataSourceSshTunnelConfiguration ssh = dataSource.getSshConfiguration();
        if (ssh == null) {
            Pair pair = Pair.create((Object)"", (Object)"");
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
            }
            return pair;
        }
        if (DatabaseCredentials.isUseCredentialStore(dataSource, ssh.getSecretStorage())) {
            String pwd = this.dbCredentialManager.getPasswordAsString(dataSource, DB_SSH_PWD);
            String phr = this.dbCredentialManager.getPasswordAsString(dataSource, DB_SSH_PHR);
            Pair pair = Pair.create((Object)StringUtil.notNullize((String)pwd), (Object)StringUtil.notNullize((String)phr));
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
            }
            return pair;
        }
        Pair pair = Pair.create((Object)PasswordUtil.decodePassword((String)ssh.getPassword()), (Object)PasswordUtil.decodePassword((String)ssh.getPassphrase()));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/access/DatabaseCredentials", "getSshCredentials"));
        }
        return pair;
    }

    public static enum StorageType {
        EMBEDDED,
        MEMORY,
        MASTER_KEY;

    }
}

