/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.actions;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.ui.CsvFormatUISettings;
import com.intellij.database.csv.ui.CsvFormatsSelectionUI;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.dbimport.DataImporter;
import com.intellij.database.dbimport.ImportDatabaseTableEditorWrapper;
import com.intellij.database.dbimport.ImportDialog;
import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportTablePreview;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeNamespace;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.editors.DatabaseEditorState;
import com.intellij.database.view.ui.AbstractDbRefactoringDialog;
import com.intellij.database.view.ui.DbRefactoringHelper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImportAction
extends DumbAwareAction {
    private static final int MAX_CHARACTERS = 10000;

    @Nullable
    private static ImportInfo showDataFormatEditorDialog(@NotNull Project project, @NotNull String text, @NotNull String fileName, @NotNull DatabaseDialect dialect, @NotNull DbElement element) throws IOException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (fileName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileName", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/actions/ImportAction", "showDataFormatEditorDialog"));
        }
        Disposable disposable = Disposer.newDisposable();
        CsvFormatUISettings settings = element instanceof DasTable ? CsvFormatUISettings.IMPORT_IN_TABLE : CsvFormatUISettings.DEFAULT;
        CsvFormatsSelectionUI formats = CsvFormatsSelectionUI.createDatabaseSettingsBackedForm(disposable, settings);
        CsvFormat selectedFormat = (CsvFormat)ObjectUtils.assertNotNull((Object)formats.getSelectedFormat());
        ImportTablePreview preview = new ImportTablePreview(project, selectedFormat, text, disposable, element instanceof DasTable);
        DatabaseEditorContext context = DbRefactoringHelper.createContext((DasObject)element, null);
        if (context == null) {
            return null;
        }
        DataGrid grid = preview.getGrid();
        grid.getDataHookup().getLoader().loadFirstPage(new GridRequestSource<DataConsumer.Row, DataConsumer.Column>(grid, null));
        ImportDatabaseTableEditorWrapper editor = ImportAction.createDatabaseTableEditorWrapper(project, context, element, disposable);
        if (editor == null) {
            return null;
        }
        DeModel model = AbstractDbRefactoringDialog.createModel(context);
        DbNamespaceImpl namespace = DatabaseView.getLowestSchema(element);
        DeNamespace deNamespace = namespace == null ? null : (DeNamespace)model.getExportHelper().export((DasObject)namespace, false);
        ImportDialog dialog = new ImportDialog(project, formats, preview, editor, dialect, (DatabaseSystem)element.getDataSource(), model, fileName, element, disposable, deNamespace);
        Disposer.register((Disposable)disposable, (Disposable)dialog.getDisposable());
        boolean selected = dialog.showAndGet();
        Disposer.dispose((Disposable)disposable);
        return !selected ? null : dialog.getImportInfo();
    }

    @Nullable
    private static ImportDatabaseTableEditorWrapper createDatabaseTableEditorWrapper(@NotNull Project project, @NotNull DatabaseEditorContext context, @Nullable DbElement element, @NotNull Disposable parent) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/actions/ImportAction", "createDatabaseTableEditorWrapper"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/actions/ImportAction", "createDatabaseTableEditorWrapper"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/actions/ImportAction", "createDatabaseTableEditorWrapper"));
        }
        DatabaseDialectEx dialect = (DatabaseDialectEx)DbImplUtil.getSqlDialect(project, (DatabaseSystem)context.getDataSource()).getDatabaseDialect();
        DatabaseEditorCapabilities.TableEditorCaps caps = ImportAction.createCapabilities(dialect, element);
        DatabaseEditorState state = new DatabaseEditorState(context);
        return new ImportDatabaseTableEditorWrapper(project, state, caps, parent);
    }

    @NotNull
    private static DatabaseEditorCapabilities.TableEditorCaps createCapabilities(@NotNull DatabaseDialectEx dialect, @Nullable DbElement element) {
        if (dialect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialect", "com/intellij/database/actions/ImportAction", "createCapabilities"));
        }
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = element instanceof DasTable ? ImportAction.createEmptyCapabilities() : ImportAction.createNewTableCapabilities(dialect);
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "createCapabilities"));
        }
        return tableEditorCaps;
    }

    @NotNull
    private static DatabaseEditorCapabilities.TableEditorCaps createNewTableCapabilities(@NotNull DatabaseDialectEx dialectEx) {
        if (dialectEx == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dialectEx", "com/intellij/database/actions/ImportAction", "createNewTableCapabilities"));
        }
        DatabaseEditorCapabilities.TableEditorCaps base = dialectEx.getSchemaEditor().getDbEditorCaps().getTableEditorCaps(false);
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(base.getRename(), base.getComment(), DatabaseEditorCapabilities.ListCapability.get(true, false, false, false), base.getIndices(), base.getForeignKeys(), base.getPrimaryKey(), base.getAltKeys(), base.getConstraints(), ImportAction.createRenameOnlyColumnEditorCaps(base.getColumnCaps(true)), ImportAction.createRenameOnlyColumnEditorCaps(base.getColumnCaps(false)), base.getKeyCaps(false), base.getKeyCaps(true), base.getIndexCaps(false), base.getIndexCaps(true), base.getForeignKeyCaps(false), base.getForeignKeyCaps(true));
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "createNewTableCapabilities"));
        }
        return tableEditorCaps;
    }

    @NotNull
    private static DatabaseEditorCapabilities.TableEditorCaps createEmptyCapabilities() {
        DatabaseEditorCapabilities.ListCapability listCapability = DatabaseEditorCapabilities.ListCapability.get(true, false, false, false);
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = ImportAction.getUnsupportedColumnEditorCaps();
        DatabaseEditorCapabilities.KeyEditorCaps keyEditorCaps = ImportAction.createUnsupportedKeyEditorCaps();
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = ImportAction.createUnsupportedIndexEditorCaps();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = ImportAction.createUnsupportedForeignKeyEditorCaps();
        DatabaseEditorCapabilities.TableEditorCaps tableEditorCaps = new DatabaseEditorCapabilities.TableEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, listCapability, listCapability, listCapability, listCapability, listCapability, listCapability, columnEditorCaps, columnEditorCaps, keyEditorCaps, keyEditorCaps, indexEditorCaps, indexEditorCaps, foreignKeyEditorCaps, foreignKeyEditorCaps);
        if (tableEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "createEmptyCapabilities"));
        }
        return tableEditorCaps;
    }

    @NotNull
    private static DatabaseEditorCapabilities.ColumnEditorCaps getUnsupportedColumnEditorCaps() {
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = new DatabaseEditorCapabilities.ColumnEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED);
        if (columnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "getUnsupportedColumnEditorCaps"));
        }
        return columnEditorCaps;
    }

    @NotNull
    private static DatabaseEditorCapabilities.ColumnEditorCaps createRenameOnlyColumnEditorCaps(@NotNull DatabaseEditorCapabilities.ColumnEditorCaps caps) {
        if (caps == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caps", "com/intellij/database/actions/ImportAction", "createRenameOnlyColumnEditorCaps"));
        }
        DatabaseEditorCapabilities.ColumnEditorCaps columnEditorCaps = new DatabaseEditorCapabilities.ColumnEditorCaps(caps.getRename(), caps.getComment(), caps.getDataType(), caps.getAutoInc(), caps.getDefault(), caps.getNotNull());
        if (columnEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "createRenameOnlyColumnEditorCaps"));
        }
        return columnEditorCaps;
    }

    @NotNull
    private static DatabaseEditorCapabilities.KeyEditorCaps createUnsupportedKeyEditorCaps() {
        DatabaseEditorCapabilities.KeyEditorCaps keyEditorCaps = new DatabaseEditorCapabilities.KeyEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, new DatabaseEditorCapabilities.TableKeyColumnEditorCaps());
        if (keyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "createUnsupportedKeyEditorCaps"));
        }
        return keyEditorCaps;
    }

    @NotNull
    private static DatabaseEditorCapabilities.IndexEditorCaps createUnsupportedIndexEditorCaps() {
        DatabaseEditorCapabilities.IndexEditorCaps indexEditorCaps = new DatabaseEditorCapabilities.IndexEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, new DatabaseEditorCapabilities.IndexColumnEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED));
        if (indexEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "createUnsupportedIndexEditorCaps"));
        }
        return indexEditorCaps;
    }

    @NotNull
    private static DatabaseEditorCapabilities.ForeignKeyEditorCaps createUnsupportedForeignKeyEditorCaps() {
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.RuleAction> valuesCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.RuleAction.class);
        DatabaseEditorCapabilities.ValuesCapability<DasForeignKey.Deferrability> deferrabilityCapability = DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class);
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.UNSUPPORTED, DatabaseEditorCapabilities.Capability.UNSUPPORTED, deferrabilityCapability, valuesCapability, valuesCapability);
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "createUnsupportedForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @NotNull
    private static String loadPartOfFile(@NotNull VirtualFile file) throws IOException {
        String string;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/actions/ImportAction", "loadPartOfFile"));
        }
        char[] buffer = new char[10000];
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file.getPath()), file.getCharset()));){
            int count = reader.read(buffer, 0, 10000);
            String string2 = count == -1 ? "" : StringUtil.convertLineSeparators((String)String.valueOf(buffer, 0, count));
            string = string2;
        }
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/actions/ImportAction", "loadPartOfFile"));
        }
        return string;
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "update"));
        }
        DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
        e.getPresentation().setEnabledAndVisible(DatabaseView.getLowestSchema(element) != null && DbImplUtil.canConnectToAndModify(element));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/database/actions/ImportAction", "actionPerformed"));
        }
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        DbElement element = (DbElement)ContainerUtil.getFirstItem(DatabaseView.getSelectedElements(e.getDataContext(), DbElement.class));
        if (element == null) {
            return;
        }
        FileChooserDescriptor descriptor = new FileChooserDescriptor(true, false, false, false, false, false);
        FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null, file -> {
            DatabaseDialect dialect = DbImplUtil.getSqlDialect(project, (DatabaseSystem)element.getDataSource()).getDatabaseDialect();
            try {
                ImportInfo info = ImportAction.showDataFormatEditorDialog(project, ImportAction.loadPartOfFile(file), file.getName(), dialect, element);
                new DataImporter(project, element, (VirtualFile)file, info).importData();
            }
            catch (IOException ex) {
                DataSourceUiUtil.showNotification(project, "Can't access file", ex.getMessage(), true);
            }
        });
    }
}

