/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.LogicalType;
import com.intellij.database.data.types.domain.Cardinality;
import org.jetbrains.annotations.NotNull;

public abstract class Compatibility
implements Comparable<Compatibility> {
    private static final Compatibility UNCOMPATIBLE = new Uncompatible();
    private final Cardinality myCardinality;
    private final int myPriority;
    private final boolean myCompatible;
    private final int myLabelSimilarity;

    protected Compatibility(@NotNull Cardinality cardinality, int labelSimilarity, int priority, boolean compatible) {
        if (cardinality == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility", "<init>"));
        }
        this.myCardinality = cardinality;
        this.myPriority = priority;
        this.myCompatible = compatible;
        this.myLabelSimilarity = labelSimilarity;
    }

    boolean isCompatible() {
        return this.myCompatible;
    }

    public int getPriority() {
        return this.myPriority;
    }

    Cardinality getCardinality() {
        return this.myCardinality;
    }

    int getLabelSimilarity() {
        return this.myLabelSimilarity;
    }

    @Override
    public int compareTo(Compatibility o) {
        int byLabel = Integer.compare(o.myLabelSimilarity, this.myLabelSimilarity);
        if (byLabel != 0) {
            return byLabel;
        }
        int byPriority = Integer.compare(o.getPriority(), this.myPriority);
        if (byPriority != 0) {
            return byPriority;
        }
        return this.myCardinality.compareTo(o.myCardinality);
    }

    @NotNull
    public static Compatibility full(@NotNull Cardinality c, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/data/types/domain/Compatibility", "full"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/database/data/types/domain/Compatibility", "full"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/database/data/types/domain/Compatibility", "full"));
        }
        Full full = new Full(c, first.getSuitability(second));
        if (full == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Compatibility", "full"));
        }
        return full;
    }

    @NotNull
    public static Compatibility compatibleLossy(@NotNull Cardinality c, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/data/types/domain/Compatibility", "compatibleLossy"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/database/data/types/domain/Compatibility", "compatibleLossy"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/database/data/types/domain/Compatibility", "compatibleLossy"));
        }
        CompatibleLossy compatibleLossy = new CompatibleLossy(c, first.getSuitability(second));
        if (compatibleLossy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Compatibility", "compatibleLossy"));
        }
        return compatibleLossy;
    }

    @NotNull
    public static Compatibility uncompatibleLossless(@NotNull Cardinality c, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossless"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossless"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossless"));
        }
        UncompatibleLossless uncompatibleLossless = new UncompatibleLossless(c, first.getSuitability(second));
        if (uncompatibleLossless == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossless"));
        }
        return uncompatibleLossless;
    }

    @NotNull
    public static Compatibility uncompatibleLossy(@NotNull Cardinality c, @NotNull LogicalType first, @NotNull LogicalType second) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossy"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossy"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossy"));
        }
        UncompatibleLossy uncompatibleLossy = new UncompatibleLossy(c, first.getSuitability(second));
        if (uncompatibleLossy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Compatibility", "uncompatibleLossy"));
        }
        return uncompatibleLossy;
    }

    @NotNull
    public static Compatibility uncompatible() {
        Compatibility compatibility = UNCOMPATIBLE;
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/Compatibility", "uncompatible"));
        }
        return compatibility;
    }

    private static class Uncompatible
    extends Compatibility {
        protected Uncompatible() {
            super(Cardinality.EMPTY, 0, 1, false);
        }
    }

    private static class UncompatibleLossy
    extends Compatibility {
        protected UncompatibleLossy(@NotNull Cardinality cardinality, int label) {
            if (cardinality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$UncompatibleLossy", "<init>"));
            }
            super(cardinality, label, 2, true);
        }

        @Override
        public int compareTo(Compatibility o) {
            if (!(o instanceof UncompatibleLossy)) {
                return super.compareTo(o);
            }
            int byLabel = Integer.compare(o.getLabelSimilarity(), this.getLabelSimilarity());
            if (byLabel != 0) {
                return byLabel;
            }
            return o.getCardinality().compareTo(this.getCardinality());
        }
    }

    private static class UncompatibleLossless
    extends Compatibility {
        protected UncompatibleLossless(@NotNull Cardinality cardinality, int label) {
            if (cardinality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$UncompatibleLossless", "<init>"));
            }
            super(cardinality, label, 3, true);
        }
    }

    private static class CompatibleLossy
    extends Compatibility {
        protected CompatibleLossy(@NotNull Cardinality cardinality, int label) {
            if (cardinality == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cardinality", "com/intellij/database/data/types/domain/Compatibility$CompatibleLossy", "<init>"));
            }
            super(cardinality, label, 4, true);
        }

        @Override
        public int compareTo(Compatibility o) {
            if (!(o instanceof CompatibleLossy)) {
                return super.compareTo(o);
            }
            int byLabel = Integer.compare(o.getLabelSimilarity(), this.getLabelSimilarity());
            if (byLabel != 0) {
                return byLabel;
            }
            return o.getCardinality().compareTo(this.getCardinality());
        }
    }

    private static class Full
    extends Compatibility {
        private Full(@NotNull Cardinality c, int label) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/data/types/domain/Compatibility$Full", "<init>"));
            }
            super(c, label, 5, true);
        }
    }
}

