/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.data.types.domain;

import com.intellij.database.data.types.ConversionPoint;
import com.intellij.database.data.types.domain.Cardinality;
import com.intellij.database.data.types.domain.Compatibility;
import com.intellij.database.data.types.domain.Domain;
import com.intellij.database.data.types.domain.Number2Domain;
import com.intellij.database.data.types.domain.PhysicalDomainType;
import org.jetbrains.annotations.NotNull;

public abstract class NumberDomain
extends Domain {
    private final double myMinValue;
    private final double myMaxValue;

    /*
     * WARNING - void declaration
     */
    protected NumberDomain(@NotNull String name, @NotNull ConversionPoint descriptor, double minValue, double d) {
        void maxValue;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/data/types/domain/NumberDomain", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/data/types/domain/NumberDomain", "<init>"));
        }
        super(descriptor, PhysicalDomainType.NUMBER, name);
        this.myMinValue = minValue;
        this.myMaxValue = maxValue;
    }

    @Override
    @NotNull
    public Compatibility getCompatibility(@NotNull Domain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/NumberDomain", "getCompatibility"));
        }
        if (!(domain instanceof Number2Domain) && !(domain instanceof NumberDomain)) {
            Compatibility compatibility = Compatibility.uncompatible();
            if (compatibility == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/NumberDomain", "getCompatibility"));
            }
            return compatibility;
        }
        Compatibility compatibility = domain instanceof Number2Domain ? Compatibility.compatibleLossy(this.cardinality(), this.getLogicType(), domain.getLogicType()) : (this.checkSingleParameter((NumberDomain)domain) ? Compatibility.full(this.cardinality(), domain.getLogicType(), this.getLogicType()) : Compatibility.compatibleLossy(this.cardinality(), domain.getLogicType(), this.getLogicType()));
        if (compatibility == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/data/types/domain/NumberDomain", "getCompatibility"));
        }
        return compatibility;
    }

    @Override
    @NotNull
    public abstract Cardinality cardinality();

    public double getMinValue() {
        return this.myMinValue;
    }

    public double getMaxValue() {
        return this.myMaxValue;
    }

    private boolean checkSingleParameter(@NotNull NumberDomain domain) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "com/intellij/database/data/types/domain/NumberDomain", "checkSingleParameter"));
        }
        return Double.compare(domain.getMinValue(), this.myMinValue) >= 0 && Double.compare(domain.getMaxValue(), this.myMaxValue) <= 0;
    }
}

