/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.dataSource.DatabaseModelLoader;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.introspection.DBIntrospectionOptions;
import com.intellij.database.introspection.DBIntrospector;
import com.intellij.database.introspection.DBIntrospectorFactory;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicNamespace;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.LoaderContext;
import com.intellij.dbm.common.IntrospectionScope;
import com.intellij.dbm.common.IntrospectionScopes;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Mssql;
import org.jetbrains.dekaf.Mysql;
import org.jetbrains.dekaf.Oracle;
import org.jetbrains.dekaf.Postgres;
import org.jetbrains.dekaf.Sybase;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.util.Version;

class DatabaseModelModernLoader {
    static final Map<String, Version> SUPPORTED_VERSIONS = ImmutableMap.of((Object)Postgres.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Oracle.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Mssql.RDBMS.code, (Object)Version.of((int[])new int[]{9}), (Object)Sybase.RDBMS.code, (Object)Version.of((int[])new int[]{15}), (Object)Mysql.RDBMS.code, (Object)Version.of((int[])new int[]{5, 1}));
    static final Version UNATTAINABLE_FUTURE = Version.of((int[])new int[]{Integer.MAX_VALUE});
    private static final Logger LOG = Logger.getInstance(DatabaseModelModernLoader.class);
    public static final BasicNamespace[] NO_NAMESPACES = new BasicNamespace[0];

    DatabaseModelModernLoader() {
    }

    static void performModernIntrospection(@NotNull ModelFactory modelFactory, @NotNull DBFacade facade, @NotNull LoaderContext context, @NotNull DasModel dasModel, @NotNull ProgressIndicator indicator, @NotNull DBIntrospectionOptions options, boolean forceLegacy) {
        boolean modern;
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (dasModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dasModel", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/database/dataSource/DatabaseModelModernLoader", "performModernIntrospection"));
        }
        boolean bl = modern = !forceLegacy;
        if (modern) {
            Version serverVersion = facade.getConnectionInfo().serverVersion;
            Version supportedVersion = (Version)ObjectUtils.notNull((Object)SUPPORTED_VERSIONS.get(facade.rdbms().code), (Object)UNATTAINABLE_FUTURE);
            modern = serverVersion.compareTo(supportedVersion) >= 0;
        }
        DBIntrospector introspector = DBIntrospectorFactory.createIntrospector(modelFactory, facade, !modern);
        introspector.setOptions(options);
        LocalDataSource dataSource = context.getDataSource();
        String extra = context.isSchemaListOnly() ? " [schemas only]" : "";
        BasicModModel model = (BasicModModel)ObjectUtils.tryCast((Object)dasModel, BasicModModel.class);
        indicator.setText("Preparing to " + (model == null ? "complete" : "incremental") + " introspection (" + facade.rdbms().code + ")");
        introspector.init(model);
        model = introspector.getModel();
        if (model != dasModel && dataSource != null) {
            dataSource.setModel(model);
        }
        introspector.setProgressIndicator(indicator);
        BasicNamespace[] array = DatabaseModelModernLoader.getNamespacesToIntrospect(context, model);
        DatabaseModelModernLoader.performIntrospectionNewWay(dataSource, introspector, context.isSchemaListOnly(), array);
        indicator.setText("Finishing introspection (" + facade.rdbms().code + ")" + extra);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private static BasicNamespace[] getNamespacesToIntrospect(@NotNull LoaderContext context, BasicModModel model) {
        List namespaces;
        boolean allSchemas;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
        }
        if (context.isSchemaListOnly()) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        if (context.getSelection().contains("*")) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        boolean inverted = DatabaseModelLoader.isScopeInverted(context.getFamilyId());
        JBIterable fromDasObjects = JBIterable.from(context.getSelection()).filter(DasObject.class).transform(DasUtil::getSchemaObject).filter(o -> o.getDbParent() != null).transform(o -> inverted ? IntrospectionScopes.scopeOf(o.getName(), "*") : IntrospectionScopes.scopeOf(o.getDbParent().getName(), o.getName()));
        @NotNull JBIterable fromStringPatterns = JBIterable.from(context.getSelection()).filter(String.class).transform(s -> IntrospectionScopes.fromSchemaPattern(s));
        List scopes = fromStringPatterns.append((Iterable)fromDasObjects).unique().toList();
        boolean bl = allSchemas = !JBIterable.from((Iterable)scopes).filter(s -> s.containsSchema("*", "*")).isEmpty();
        if (allSchemas) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        JBIterable visibleNamespaces = ((JBTreeTraverser)model.traverser().expand(object -> object.getKind() != ObjectKind.SCHEMA)).filter(BasicNamespace.class).filter(BasicNamespace::isVisible);
        int nonLimitedCount = visibleNamespaces.filter(n -> n.getKind() == ObjectKind.SCHEMA || n.getKind() == ObjectKind.DATABASE && !n.hasChildren()).size();
        if (nonLimitedCount == (namespaces = visibleNamespaces.filter(object -> {
            if (object.getKind() == ObjectKind.SCHEMA) {
                for (IntrospectionScope scope : scopes) {
                    if (!DatabaseModelLoader.schemaMatches(object, scope, inverted)) continue;
                    return true;
                }
            }
            if (object.getKind() == ObjectKind.DATABASE && !object.hasChildren()) {
                for (IntrospectionScope scope : scopes) {
                    if (!scope.containsDatabase(object.getName())) continue;
                    return true;
                }
            }
            return false;
        }).toList()).size()) {
            if (NO_NAMESPACES == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
            }
            return NO_NAMESPACES;
        }
        BasicNamespace[] basicNamespaceArray = namespaces.toArray(new BasicNamespace[namespaces.size()]);
        if (basicNamespaceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/DatabaseModelModernLoader", "getNamespacesToIntrospect"));
        }
        return basicNamespaceArray;
    }

    private static void performIntrospectionNewWay(LocalDataSource dataSource, DBIntrospector introspector, boolean schemasOnly, BasicNamespace ... namespaces) {
        try {
            if (dataSource != null) {
                dataSource.performBatch(schemasOnly ? introspector::introspectNamespaces : () -> introspector.introspectAuto(namespaces));
            } else if (schemasOnly) {
                introspector.introspectNamespaces();
            } else {
                introspector.introspectAuto(namespaces);
            }
        }
        catch (RuntimeException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

