/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.srcStorage;

import com.intellij.database.dataSource.srcStorage.DbSrcFileSystem;
import com.intellij.database.dataSource.srcStorage.DbSrcPath;
import com.intellij.database.dataSource.srcStorage.DbSrcStorage;
import com.intellij.database.dataSource.srcStorage.DbSrcStorageLayout;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystem;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipFileSystemProvider;
import com.intellij.database.dataSource.srcStorage.zipfs.ZipPath;
import com.intellij.database.model.ObjectKind;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.ZipHandler;
import com.intellij.util.Alarm;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import java.util.zip.ZipError;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbSrcStorageLayouts {
    private static FileSystemProvider ourZipProvider = new ZipFileSystemProvider();
    public static final Map<String, Function<DbSrcStorage.FsAccess, DbSrcStorageLayout>> ourLayouts = ContainerUtil.immutableMapBuilder().put((Object)"schema-zip", SchemaZipLayout::new).put((Object)"plain", PlainLayout::new).build();
    public static final String VFS_SEP = String.valueOf('/');
    public static final String[] ESCAPE_FROM = new String[]{"/", "&", ".", "!", "\"", "\\", "<", ">", "|", "*", "?"};
    public static final String[] ESCAPE_TO = new String[]{"&slash;", "&amp;", "&dot;", "&#33;", "&quot;", "&#92;", "&lt;", "&gt;", "&#124;", "&#42;", "&#63;"};

    private static String pathForFs(String path, FileSystem fs) {
        String sep = fs.getSeparator();
        if (sep != VFS_SEP) {
            path = path.replace(VFS_SEP, sep);
        }
        return path;
    }

    @Nullable
    public static DbSrcStorageLayout createLayout(@Nullable String id, @NotNull DbSrcStorage.FsAccess fs) {
        if (fs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts", "createLayout"));
        }
        Function<DbSrcStorage.FsAccess, DbSrcStorageLayout> function = ourLayouts.get(id);
        return function == null ? null : (DbSrcStorageLayout)function.fun((Object)fs);
    }

    public static String escape(String s) {
        if (s == null) {
            return null;
        }
        return StringUtil.replace((String)s, (String[])ESCAPE_FROM, (String[])ESCAPE_TO);
    }

    private static String unescape(String s) {
        if (s == null) {
            return null;
        }
        return StringUtil.replace((String)s, (String[])ESCAPE_TO, (String[])ESCAPE_FROM);
    }

    private static boolean isEmpty(@NotNull Path path) throws IOException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts", "isEmpty"));
        }
        try (Stream<Path> list = Files.list(path);){
            boolean bl = !list.findAny().isPresent();
            return bl;
        }
    }

    public static abstract class PathLayout
    extends DbSrcStorageLayout {
        private final DbSrcStorage.FsAccess myFsAccess;

        public PathLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "<init>"));
            }
            this.myFsAccess = fs;
        }

        @Override
        @NotNull
        public DbSrcStorageLayout.Item getLocation(@NotNull VirtualFile root2, @NotNull DbSrcPath object) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            Pair<String, String> path = this.buildPath(object, true);
            Pair<String, String> path2 = this.buildPath(object, false);
            String rootPath = root2.getPath();
            FileItem fileItem = new FileItem((Pair<String, String>)Pair.create((Object)(rootPath + "/" + (String)path.first), (Object)path.second), object, (Pair<String, String>)Pair.create((Object)(rootPath + "/" + (String)path2.first), (Object)path2.second), this);
            if (fileItem == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getLocation"));
            }
            return fileItem;
        }

        @NotNull
        protected abstract Pair<String, String> buildPath(@Nullable DbSrcPath var1, boolean var2);

        @Nullable
        protected VirtualFile compose(@NotNull VirtualFile root2, @Nullable Pair<String, String> path) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "compose"));
            }
            if (path == null || !root2.isValid()) {
                return null;
            }
            VirtualFile local = root2.findFileByRelativePath((String)path.first);
            if (local == null || !local.isValid()) {
                return null;
            }
            if (path.second == null) {
                return local;
            }
            VirtualFile zip = this.getZipRoot(local);
            return zip == null || !zip.isValid() ? null : zip.findFileByRelativePath((String)path.second);
        }

        @Nullable
        protected VirtualFile getZipRoot(@NotNull VirtualFile f) {
            if (f == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "f", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getZipRoot"));
            }
            return this.myFsAccess.getJarRootForLocalFile(f);
        }

        @Override
        @Nullable
        public DbSrcPath getObject(@NotNull VirtualFile root2, @NotNull VirtualFile file) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getObject"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getObject"));
            }
            Pair<List<String>, List<String>> path = this.splitPath(root2.getPath(), file.getPath());
            if (path == null) {
                return null;
            }
            return this.detectObject((List)path.first, (List)path.second);
        }

        @Nullable
        protected abstract DbSrcPath detectObject(@NotNull List<String> var1, @Nullable List<String> var2);

        @Override
        @NotNull
        public DbSrcStorage.FsAccess getFsAccess() {
            DbSrcStorage.FsAccess fsAccess = this.myFsAccess;
            if (fsAccess == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "getFsAccess"));
            }
            return fsAccess;
        }

        @Nullable
        protected Pair<List<String>, List<String>> splitPath(@NotNull String root2, @NotNull String child) {
            String zipPath;
            String localPath;
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "splitPath"));
            }
            if (child == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "splitPath"));
            }
            if (!child.startsWith(root2)) {
                return null;
            }
            if (child.length() == root2.length()) {
                return Pair.create(Collections.emptyList(), null);
            }
            if (root2.endsWith("/")) {
                child = child.substring(root2.length());
            } else if (child.charAt(root2.length()) == '/') {
                child = child.substring(root2.length() + 1);
            } else {
                return null;
            }
            int idx = child.indexOf("!/");
            if (idx != -1) {
                localPath = child.substring(0, idx);
                zipPath = child.substring(idx + "!/".length());
            } else {
                localPath = child;
                zipPath = null;
            }
            return Pair.create(PathLayout.splitPath(localPath), PathLayout.splitPath(zipPath));
        }

        @Override
        @NotNull
        public DbSrcStorageLayout.WriteSession createSession() {
            ZipWriteSession zipWriteSession = new ZipWriteSession();
            if (zipWriteSession == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PathLayout", "createSession"));
            }
            return zipWriteSession;
        }

        @Contract(value="null->null")
        private static List<String> splitPath(@Nullable String localPath) {
            if (localPath == null) {
                return null;
            }
            return localPath.isEmpty() ? Collections.emptyList() : ContainerUtil.newArrayList(DbSrcFileSystem.splitPath(localPath));
        }
    }

    public static abstract class UniformPathLayout
    extends PathLayout {
        public UniformPathLayout(DbSrcStorage.FsAccess fs) {
            super(fs);
        }

        @Override
        @Nullable
        protected DbSrcPath detectObject(@NotNull List<String> local, @Nullable List<String> zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "detectObject"));
            }
            Iterable<String> path = this.glue(null, local, zip);
            if (path == null) {
                return null;
            }
            return this.detectObject(null, path);
        }

        @Nullable
        protected abstract DbSrcPath detectObject(@Nullable DbSrcPath var1, @NotNull Iterable<String> var2);

        @Nullable
        protected abstract Iterable<String> glue(@Nullable DbSrcPath var1, @NotNull List<String> var2, @Nullable List<String> var3);

        @Override
        @NotNull
        public Iterable<DbSrcPath> getExistingChildren(@NotNull VirtualFile root2, @Nullable DbSrcPath object, @Nullable String group2) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
            }
            Pair<String, String> path = this.buildPath(object, false);
            VirtualFile file = this.compose(root2, path);
            if (file == null) {
                List<DbSrcPath> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
                }
                return list;
            }
            JBIterable<VirtualFile> children = this.getExistingChildren(object, file, group2);
            Set set = children.transform(f -> {
                Pair<List<String>, List<String>> subPath = this.splitPath(file.getPath(), f.getPath());
                if (subPath == null) {
                    return null;
                }
                Iterable<String> sub = this.glue(object, (List)subPath.first, (List)subPath.second);
                if (sub == null) {
                    return null;
                }
                return this.detectObject(object, sub);
            }).filter(Conditions.notNull()).toSet();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingChildren"));
            }
            return set;
        }

        @Override
        @NotNull
        public Iterable<String> getExistingGroups(@NotNull VirtualFile root2, @Nullable DbSrcPath object) {
            if (root2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingGroups"));
            }
            Pair<String, String> path = this.buildPath(object, false);
            VirtualFile file = this.compose(root2, path);
            if (file == null) {
                List<String> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingGroups"));
                }
                return list;
            }
            JBIterable<String> jBIterable = this.getExistingGroups(object, file);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$UniformPathLayout", "getExistingGroups"));
            }
            return jBIterable;
        }

        @NotNull
        protected abstract JBIterable<VirtualFile> getExistingChildren(@Nullable DbSrcPath var1, @NotNull VirtualFile var2, @Nullable String var3);

        @NotNull
        protected abstract JBIterable<String> getExistingGroups(@Nullable DbSrcPath var1, @NotNull VirtualFile var2);
    }

    public static abstract class GroupedByKindLayout
    extends UniformPathLayout {
        private final String myZipStart;

        public GroupedByKindLayout(@Nullable String zipStart, DbSrcStorage.FsAccess fs) {
            super(fs);
            this.myZipStart = zipStart;
        }

        @Override
        @Nullable
        protected DbSrcPath detectObject(@Nullable DbSrcPath parent, @NotNull Iterable<String> path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "detectObject"));
            }
            if (!path.iterator().hasNext()) {
                return parent;
            }
            ArrayList kinds = ContainerUtil.newArrayListWithCapacity((int)(parent == null ? 1 : parent.size() + 1));
            ArrayList names = ContainerUtil.newArrayListWithCapacity((int)(parent == null ? 1 : parent.size() + 1));
            if (parent != null) {
                for (int i2 = 0; i2 < parent.size(); ++i2) {
                    kinds.add(parent.kind(i2));
                    names.add(parent.name(i2));
                }
            }
            String disambiguator = null;
            Iterator<String> it = path.iterator();
            while (it.hasNext()) {
                String code = it.next();
                if (code.indexOf(46) != -1) {
                    return null;
                }
                kinds.add(DbSrcStorageLayouts.unescape(code));
                if (!it.hasNext()) {
                    return null;
                }
                String name = it.next();
                int pt = name.indexOf(".");
                if (pt != -1) {
                    if (it.hasNext()) {
                        return null;
                    }
                    disambiguator = DbSrcStorageLayouts.unescape(name.substring(pt + 1));
                    name = name.substring(0, pt);
                }
                names.add(DbSrcStorageLayouts.unescape(name));
            }
            return names.isEmpty() ? null : new DbSrcPath(names, kinds, disambiguator);
        }

        @Override
        @Nullable
        protected Iterable<String> glue(@Nullable DbSrcPath parent, @NotNull List<String> local, @Nullable List<String> zip) {
            if (local == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "local", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "glue"));
            }
            if (zip == null) {
                String last = (String)ContainerUtil.getLastItem(local);
                if (last != null && last.endsWith(".zip")) {
                    return null;
                }
                return JBIterable.from(GroupedByKindLayout.trimExt(local, ".sql"));
            }
            if (local.isEmpty()) {
                return JBIterable.from(GroupedByKindLayout.trimExt(zip, ".sql"));
            }
            return JBIterable.from(GroupedByKindLayout.trimExt(local, ".zip")).append(GroupedByKindLayout.trimExt(zip, ".sql"));
        }

        @NotNull
        private static Iterable<String> trimExt(@NotNull List<String> list, @NotNull String ext) {
            if (list == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            if (ext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ext", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            String last = (String)ContainerUtil.getLastItem(list);
            if (last == null) {
                List<String> list2 = Collections.emptyList();
                if (list2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
                }
                return list2;
            }
            if (!last.endsWith(ext)) {
                List<String> list3 = list;
                if (list3 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
                }
                return list3;
            }
            JBIterable jBIterable = JBIterable.from(list).take(list.size() - 1).append((Object)StringUtil.trimEnd((String)last, (String)ext));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "trimExt"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected JBIterable<VirtualFile> getExistingChildren(@Nullable DbSrcPath object, @NotNull VirtualFile file, @Nullable String group2) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingChildren"));
            }
            JBIterable groupIt = group2 == null ? JBIterable.of((Object[])file.getChildren()) : JBIterable.of((Object)file.findChild(DbSrcStorageLayouts.escape(group2)));
            JBIterable jBIterable = groupIt.flatten(f -> JBIterable.of((Object[])f.getChildren())).transform(f -> f.getName().endsWith(".zip") ? this.getZipRoot((VirtualFile)f) : f).filter(Conditions.notNull());
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingChildren"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected JBIterable<String> getExistingGroups(@Nullable DbSrcPath object, @NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingGroups"));
            }
            JBIterable jBIterable = JBIterable.of((Object[])file.getChildren()).transform(f -> DbSrcStorageLayouts.unescape(f.getName()));
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "getExistingGroups"));
            }
            return jBIterable;
        }

        @Override
        @NotNull
        protected Pair<String, String> buildPath(@Nullable DbSrcPath object, boolean src) {
            if (object == null) {
                Pair pair = Pair.create((Object)"", null);
                if (pair == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "buildPath"));
                }
                return pair;
            }
            StringBuilder res = new StringBuilder();
            String local = null;
            int end = object.size();
            for (int i2 = 0; i2 < end; ++i2) {
                String kind = object.kind(i2);
                String name = object.name(i2);
                if (res.length() != 0) {
                    res.append("/");
                }
                res.append(DbSrcStorageLayouts.escape(kind)).append("/").append(DbSrcStorageLayouts.escape(name));
                if (!kind.equals(this.myZipStart) || i2 == end - 1 && src) continue;
                if (local != null) {
                    throw new AssertionError((Object)"passed zip start twice");
                }
                res.append(".zip");
                local = res.toString();
                res.setLength(0);
            }
            if (src) {
                if (object.getDisambiguator() != null) {
                    res.append(".").append(DbSrcStorageLayouts.escape(object.getDisambiguator()));
                }
                res.append(".sql");
            }
            Pair pair = local == null ? Pair.create((Object)res.toString(), null) : Pair.create(local, (Object)res.toString());
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$GroupedByKindLayout", "buildPath"));
            }
            return pair;
        }
    }

    public static class SchemaZipLayout
    extends GroupedByKindLayout {
        public static final String ID = "schema-zip";

        public SchemaZipLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$SchemaZipLayout", "<init>"));
            }
            super(ObjectKind.SCHEMA.code(), fs);
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$SchemaZipLayout", "getId"));
            }
            return ID;
        }
    }

    public static class PlainLayout
    extends GroupedByKindLayout {
        public static final String ID = "plain";

        public PlainLayout(@NotNull DbSrcStorage.FsAccess fs) {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PlainLayout", "<init>"));
            }
            super(null, fs);
        }

        @Override
        @NotNull
        public String getId() {
            if (ID == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$PlainLayout", "getId"));
            }
            return ID;
        }
    }

    public static class FileItem
    implements DbSrcStorageLayout.Item {
        protected final Pair<String, String> myPath;
        protected final Pair<String, String> myChildrenPath;
        private final DbSrcPath myObject;
        protected final DbSrcStorageLayout myLayout;

        public FileItem(@NotNull Pair<String, String> path, @NotNull DbSrcPath object, @Nullable Pair<String, String> childrenPath, @NotNull DbSrcStorageLayout layout) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            if (object == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            if (layout == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "layout", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "<init>"));
            }
            this.myPath = path;
            this.myChildrenPath = childrenPath;
            this.myObject = object;
            this.myLayout = layout;
        }

        @Override
        @NotNull
        public DbSrcStorageLayout getLayout() {
            DbSrcStorageLayout dbSrcStorageLayout = this.myLayout;
            if (dbSrcStorageLayout == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getLayout"));
            }
            return dbSrcStorageLayout;
        }

        @Override
        @NotNull
        public DbSrcPath getObject() {
            DbSrcPath dbSrcPath = this.myObject;
            if (dbSrcPath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getObject"));
            }
            return dbSrcPath;
        }

        @Override
        @Nullable
        public VirtualFile getSrcFile() {
            return this.toVirtualFile(this.myPath);
        }

        @Override
        public boolean hasChildren() {
            return this.toVirtualFile(this.myChildrenPath) != null;
        }

        @Nullable
        private VirtualFile toVirtualFile(@Nullable Pair<String, String> path) {
            if (path == null) {
                return null;
            }
            VirtualFile local = this.myLayout.getFsAccess().findFileByPath((String)path.first);
            if (local == null || path.second == null) {
                return local;
            }
            VirtualFile root2 = this.myLayout.getFsAccess().getJarRootForLocalFile(local);
            if (root2 == null) {
                return null;
            }
            return root2.findFileByRelativePath((String)path.second);
        }

        @Override
        @NotNull
        public OutputStream getOutputStream(@Nullable Object requestor, @Nullable DbSrcStorageLayout.WriteSession someSession) throws IOException {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myPath.second == null) {
                OutputStream outputStream = FileItem.ensureExistsLocal(this.myLayout.getFsAccess(), (String)this.myPath.first, requestor).getOutputStream(requestor);
                if (outputStream == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getOutputStream"));
                }
                return outputStream;
            }
            final ZipWriteSession session = (ZipWriteSession)ObjectUtils.tryCast((Object)someSession, ZipWriteSession.class);
            OutputStream outputStream = new OutputStream(){
                private ZipFileSystem myFs = null;
                private OutputStream myOutputStream = null;
                {
                    this.myFs = ZipWriteSession.create(session, (String)myPath.first);
                    try {
                        ZipPath path = this.myFs.getPath(DbSrcStorageLayouts.pathForFs((String)myPath.second, this.myFs), new String[0]);
                        Files.createDirectories(path.getParent(), new FileAttribute[0]);
                        this.myOutputStream = Files.newOutputStream(path, StandardOpenOption.CREATE);
                    }
                    finally {
                        if (this.myOutputStream == null) {
                            ZipWriteSession.close(session, this.myFs, (String)myPath.first);
                        }
                    }
                }

                @Override
                public void write(int b) throws IOException {
                    this.myOutputStream.write(b);
                }

                @Override
                public void close() throws IOException {
                    try {
                        this.myOutputStream.close();
                    }
                    finally {
                        ZipWriteSession.close(session, this.myFs, (String)myPath.first);
                    }
                }
            };
            if (outputStream == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getOutputStream"));
            }
            return outputStream;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void delete(@Nullable Object requestor, @Nullable DbSrcStorageLayout.WriteSession someSession) throws IOException {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myPath.second == null) {
                Path path;
                FileSystem defaultFs = FileSystems.getDefault();
                String fsPath = DbSrcStorageLayouts.pathForFs((String)this.myPath.first, defaultFs);
                Path stop = path = defaultFs.getPath(fsPath, new String[0]);
                int cnt = this.myObject.size() * 2;
                for (int i2 = 0; i2 < cnt && stop != null; stop = stop.getParent(), ++i2) {
                }
                FileItem.deleteUpwards(path, stop);
                VirtualFile vFile = this.myLayout.getFsAccess().findFileByPath((String)this.myPath.first);
                if (vFile != null) {
                    VfsUtil.markDirty((boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{vFile});
                }
                return;
            }
            ZipWriteSession session = (ZipWriteSession)ObjectUtils.tryCast((Object)someSession, ZipWriteSession.class);
            ZipFileSystem fs = ZipWriteSession.create(session, (String)this.myPath.first);
            try {
                ZipPath path = fs.getPath(DbSrcStorageLayouts.pathForFs((String)this.myPath.second, fs), new String[0]);
                FileItem.deleteUpwards(path, null);
            }
            finally {
                ZipWriteSession.close(session, fs, (String)this.myPath.first);
            }
        }

        private static void deleteUpwards(@NotNull Path path, @Nullable Path until) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "deleteUpwards"));
            }
            try {
                Files.deleteIfExists(path);
                for (path = path.getParent(); path != null && !path.equals(until) && Files.exists(path, new LinkOption[0]) && DbSrcStorageLayouts.isEmpty(path) && Files.deleteIfExists(path); path = path.getParent()) {
                }
            }
            catch (DirectoryNotEmptyException | NotDirectoryException fileSystemException) {
                // empty catch block
            }
        }

        @Override
        @NotNull
        public String getSrcPath() {
            String string = this.myPath.second == null ? (String)this.myPath.first : (String)this.myPath.first + "!/" + (String)this.myPath.second;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "getSrcPath"));
            }
            return string;
        }

        @NotNull
        protected static VirtualFile ensureExistsLocal(@NotNull DbSrcStorage.FsAccess fs, @NotNull String filePath, @Nullable Object requestor) throws IOException {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExistsLocal"));
            }
            if (filePath == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExistsLocal"));
            }
            FileSystem defaultFs = FileSystems.getDefault();
            String fsPath = DbSrcStorageLayouts.pathForFs(filePath, defaultFs);
            Path toCreate = defaultFs.getPath(fsPath, new String[0]).getParent();
            try {
                Files.createDirectories(toCreate, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                // empty catch block
            }
            VirtualFile path = fs.findFileByPath(filePath);
            if (path == null) {
                VirtualFile parent;
                String dir = VfsUtil.getParentDir((String)filePath);
                VirtualFile virtualFile = parent = dir == null ? null : VfsUtil.createDirectories((String)dir);
                if (parent == null) {
                    throw new IOException("Directory creation failed");
                }
                path = parent.findOrCreateChildData(requestor, PathUtil.getFileName((String)filePath));
            }
            VirtualFile virtualFile = path;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$FileItem", "ensureExistsLocal"));
            }
            return virtualFile;
        }
    }

    private static class ZipWriteSession
    implements DbSrcStorageLayout.WriteSession {
        private static final Map<String, ZipFileSystem> ourFailed = ContainerUtil.newHashMap();
        private static final Logger LOG = Logger.getInstance(ZipWriteSession.class);
        private static final Alarm myFailedAlarm = new Alarm();
        public ZipFileSystem myFs = null;
        public String myPath = null;

        private ZipWriteSession() {
        }

        private ZipFileSystem renewOrContinue(@NotNull String path) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "renewOrContinue"));
            }
            if (path.equals(this.myPath)) {
                return this.myFs;
            }
            try {
                this.close();
                this.myPath = null;
            }
            catch (IOException e) {
                LOG.warn((Throwable)e);
            }
            this.myFs = ZipWriteSession.create(path);
            this.myPath = path;
            return this.myFs;
        }

        public static ZipFileSystem create(@Nullable ZipWriteSession session, @NotNull String path) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "create"));
            }
            return session == null ? ZipWriteSession.create(path) : session.renewOrContinue(path);
        }

        private static ZipFileSystem create(@NotNull String path) throws IOException {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "create"));
            }
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            ZipFileSystem failed = ourFailed.remove(path);
            if (failed != null) {
                LOG.warn("Reusing non-closed FS for " + path);
                return failed;
            }
            ZipWriteSession.tryToCloseFailed(false);
            FileSystem defaultFs = FileSystems.getDefault();
            path = DbSrcStorageLayouts.pathForFs(path, defaultFs);
            return ZipWriteSession.createOrBackupZipFile(defaultFs.getPath(path, new String[0]));
        }

        private static ZipFileSystem createOrBackupZipFile(Path zipPath) throws IOException {
            Files.createDirectories(zipPath.getParent(), new FileAttribute[0]);
            URI zipUri = URI.create("jar:" + zipPath.toUri().toString());
            Map<String, String> env = Collections.singletonMap("create", "true");
            try {
                return (ZipFileSystem)ourZipProvider.newFileSystem(zipUri, env);
            }
            catch (ZipError e) {
                block4: {
                    LOG.warn("Failed to open zip " + zipPath + ": " + e.getMessage());
                    Path backup = null;
                    try {
                        backup = Files.createTempFile(zipPath.getParent(), String.valueOf(zipPath.getFileName()), ".bak", new FileAttribute[0]);
                        Files.move(zipPath, backup, StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException ex) {
                        LOG.warn("Backup failed: " + ex.getMessage());
                        if (backup == null) break block4;
                        Files.deleteIfExists(backup);
                    }
                }
                return (ZipFileSystem)ourZipProvider.newFileSystem(zipUri, env);
            }
        }

        private static void tryToCloseFailed(boolean rescheduleOnFail) {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            ZipHandler.clearFileAccessorCache();
            boolean hasFailed = false;
            Iterator<Map.Entry<String, ZipFileSystem>> it = ourFailed.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, ZipFileSystem> entry = it.next();
                ZipFileSystem fs = entry.getValue();
                try {
                    fs.sync();
                    it.remove();
                    ZipWriteSession.closeAndRemoveEmpty(fs, entry.getKey());
                }
                catch (IOException e) {
                    hasFailed |= fs.isOpen();
                    LOG.warn((fs.isOpen() ? "Sync failed, rescheduling " : "Close thrown exception") + entry.getKey() + "\n" + e.getMessage());
                }
            }
            if (rescheduleOnFail && hasFailed) {
                ZipWriteSession.scheduleClosing(30000, false);
            }
        }

        public static void close(@Nullable ZipWriteSession session, @NotNull ZipFileSystem fs, @NotNull String path) throws IOException {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "close"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "close"));
            }
            if (session == null) {
                ZipWriteSession.close(fs, path);
            }
        }

        private static void close(@NotNull ZipFileSystem fs, @NotNull String path) throws IOException {
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "close"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "close"));
            }
            try {
                ZipWriteSession.tryToCloseFailed(false);
            }
            finally {
                try {
                    fs.sync();
                    ZipWriteSession.closeAndRemoveEmpty(fs, path);
                }
                catch (IOException e) {
                    if (fs.isOpen()) {
                        LOG.warn("Adding to failed map: " + e.getMessage());
                        ourFailed.put(path, fs);
                        ZipWriteSession.scheduleClosing(5000, true);
                    }
                    LOG.warn("OK, closed: " + e.getMessage());
                }
            }
        }

        private static void scheduleClosing(int delay, final boolean retry) {
            myFailedAlarm.cancelAllRequests();
            myFailedAlarm.addRequest(() -> new WriteAction(){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession$1", "run"));
                    }
                    ZipWriteSession.tryToCloseFailed(retry);
                }
            }.execute(), delay, ModalityState.defaultModalityState());
        }

        private static void closeAndRemoveEmpty(@NotNull ZipFileSystem fs, @NotNull String path) throws IOException {
            boolean empty;
            if (fs == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fs", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "closeAndRemoveEmpty"));
            }
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "closeAndRemoveEmpty"));
            }
            try {
                empty = JBIterable.from(fs.getRootDirectories()).filter(p -> ZipWriteSession.isNotEmpty(p)).isEmpty();
            }
            finally {
                fs.close();
            }
            if (empty) {
                FileSystem defaultFs = FileSystems.getDefault();
                path = DbSrcStorageLayouts.pathForFs(path, defaultFs);
                Path zipPath = defaultFs.getPath(path, new String[0]);
                try {
                    Files.deleteIfExists(zipPath);
                }
                catch (IOException e) {
                    LOG.warn("Failed to delete: " + e.getMessage());
                }
            }
        }

        private static boolean isNotEmpty(@NotNull Path path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dataSource/srcStorage/DbSrcStorageLayouts$ZipWriteSession", "isNotEmpty"));
            }
            try {
                return !DbSrcStorageLayouts.isEmpty(path);
            }
            catch (IOException e) {
                return true;
            }
        }

        @Override
        public void close() throws IOException {
            ApplicationManager.getApplication().assertWriteAccessAllowed();
            if (this.myFs == null) {
                return;
            }
            ZipWriteSession.close(this.myFs, this.myPath);
            this.myPath = null;
        }
    }
}

