/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dbimport.state;

import com.intellij.database.dbimport.ImportInfo;
import com.intellij.database.dbimport.ImportManager;
import com.intellij.database.dbimport.state.AbstractTransactionStateHolder;
import com.intellij.util.ThrowableRunnable;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class CommitOnBatchStateHolder
extends AbstractTransactionStateHolder {
    public CommitOnBatchStateHolder(@NotNull ImportManager manager, @NotNull ImportInfo info, boolean transactionsSupported) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "<init>"));
        }
        if (info == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "<init>"));
        }
        super(info, manager, transactionsSupported, false);
    }

    @Override
    public void executed(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "executed"));
        }
        this.commit(connection);
    }

    @Override
    public void onExecuteError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "onExecuteError"));
        }
        this.rollback(connection);
    }

    @Override
    public void batchExecuted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "batchExecuted"));
        }
        super.batchExecuted(connection);
        this.commit(connection);
    }

    @Override
    public void onExecuteBatchError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "onExecuteBatchError"));
        }
        super.onExecuteBatchError(connection);
        this.rollback(connection);
    }

    @Override
    public void batchStarted(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "batchStarted"));
        }
        super.batchStarted(connection);
        this.commit(connection);
    }

    @Override
    public void onAddBatchRecordError(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "onAddBatchRecordError"));
        }
        super.onAddBatchRecordError(connection);
        this.rollback(connection);
    }

    @Override
    public boolean isTransactionSupported() {
        return this.mySupportTransactions;
    }

    private void commit(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "commit"));
        }
        if (!this.isTransactionSupported()) {
            return;
        }
        this.run((ThrowableRunnable<SQLException>)((ThrowableRunnable)() -> {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "lambda$commit$0"));
            }
            connection.commit();
            this.lock(connection);
        }), SAVE_ERROR);
    }

    private void rollback(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "rollback"));
        }
        if (!this.isTransactionSupported()) {
            return;
        }
        this.run((ThrowableRunnable<SQLException>)((ThrowableRunnable)() -> {
            if (connection == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dbimport/state/CommitOnBatchStateHolder", "lambda$rollback$1"));
            }
            connection.rollback();
            this.lock(connection);
        }), ROLLBACK_ERROR);
    }
}

