/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dump.dbdump.component;

import com.intellij.database.dump.dbdump.DbDumpUtil;
import com.intellij.database.dump.dbdump.DumpCommandLineLexeme;
import com.intellij.database.dump.dbdump.DumpContextDescriptor;
import com.intellij.database.dump.dbdump.argument.StringDumpArgument;
import com.intellij.database.dump.dbdump.component.DumpUneditableTextField;
import com.intellij.database.psi.DbElement;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public class DumpMultiParametersUneditableTextField
extends DumpUneditableTextField {
    private final List<String> myStrings = ContainerUtil.newArrayList();

    public DumpMultiParametersUneditableTextField(StringDumpArgument argument) {
        super(argument);
    }

    @Override
    public void configure(@NotNull Collection<DbElement> elements, @NotNull DumpContextDescriptor cd) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "configure"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "configure"));
        }
        this.myStrings.clear();
        this.myStrings.addAll(((StringDumpArgument)this.getArgument()).getStringsFromElements(elements, cd));
        this.myField.setText(StringUtil.join(this.myStrings, (String)", "));
    }

    @Override
    public void changeState(@NotNull String text, @NotNull DumpCommandLineLexeme current, @NotNull DumpCommandLineLexeme next, @NotNull DumpContextDescriptor cd) {
        String value;
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "changeState"));
        }
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "changeState"));
        }
        if (next == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "next", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "changeState"));
        }
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "changeState"));
        }
        if (!cd.checkedOut(this)) {
            this.myField.setText("");
            this.myStrings.clear();
        }
        if ((value = ((StringDumpArgument)this.getArgument()).getComponentValue(text, current, next, cd)) == null) {
            return;
        }
        String parameter = DbDumpUtil.clearString(value, ((StringDumpArgument)this.getArgument()).getUnquoter());
        this.myStrings.add(parameter);
        this.myField.setText(StringUtil.join(this.myStrings, (String)", "));
    }

    @Override
    public void reset(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "reset"));
        }
        super.reset(cd);
        this.myStrings.clear();
    }

    @Override
    @NotNull
    public String getFullArgument(@NotNull DumpContextDescriptor cd) {
        if (cd == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cd", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "getFullArgument"));
        }
        Function<String, String> quoter = ((StringDumpArgument)this.getArgument()).getQuoter();
        String string = this.myStrings.isEmpty() ? "" : DbDumpUtil.fromListToArgument(this.myStrings, ((StringDumpArgument)this.getArgument()).getPrefix(), quoter);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dump/dbdump/component/DumpMultiParametersUneditableTextField", "getFullArgument"));
        }
        return string;
    }
}

