/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.basic;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicRoot;
import com.intellij.database.model.properties.IdentityAndKind;
import com.intellij.database.model.properties.SourceError;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface BasicSourceAware
extends BasicElement {
    @Nullable
    default public String getSourceText() {
        return null;
    }

    default public boolean isInvalid() {
        return false;
    }

    @NotNull
    default public List<SourceError> getErrors() {
        List<SourceError> list = ModelConsts.NO_ERRORS;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/basic/BasicSourceAware", "getErrors"));
        }
        return list;
    }

    default public List<IdentityAndKind> getSourcePath() {
        LinkedList<IdentityAndKind> path = new LinkedList<IdentityAndKind>();
        for (BasicElement step = this; step != null && !(step instanceof BasicRoot); step = step.getDbParent()) {
            path.add(new IdentityAndKind(step.identity(), step.getKind()));
        }
        return path;
    }
}

