/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mssql;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModRoutine;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingIdentifyingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.families.PositioningNamingFamily;
import com.intellij.database.model.mssql.MsModArgument;
import com.intellij.database.model.mssql.MsModMajorObject;
import com.intellij.database.model.mssql.MsModSchema;
import com.intellij.database.model.mssql.MsModSourceAware;
import com.intellij.database.model.mssql.MsRoutine;
import com.intellij.database.model.properties.MsRoutineType;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MsModRoutine
extends MsRoutine,
BasicModRoutine,
MsModMajorObject,
MsModSourceAware {
    @Override
    @NotNull
    public MsModSchema getSchema();

    @Override
    @NotNull
    default public MsModSchema getDbParent() {
        MsModSchema msModSchema = this.getSchema();
        if (msModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModRoutine", "getDbParent"));
        }
        return msModSchema;
    }

    @Override
    @NotNull
    public ModNamingIdentifyingFamily<? extends MsModRoutine> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends MsModArgument> getArguments();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<PositioningNamingFamily> list = Collections.singletonList(this.getArguments());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModRoutine", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.from((Iterable)this.getArguments());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mssql/MsModRoutine", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setObjectId(long var1);

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setCreatedTimestamp(@Nullable Date var1);

    @Override
    public void setModifiedTimestamp(@Nullable Date var1);

    @Override
    public void setRoutineKind(@NotNull DasRoutine.Kind var1);

    public void setRoutineType(@Nullable MsRoutineType var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mssql/MsModRoutine", "importProperties"));
        }
        String objectId = properties.get("ObjectId");
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String createdTimestamp = properties.get("CreatedTimestamp");
        String modifiedTimestamp = properties.get("ModifiedTimestamp");
        String routineKind = properties.get("RoutineKind");
        String routineType = properties.get("RoutineType");
        if (objectId != null) {
            this.setObjectId(PropertyConverter.importLong(objectId));
        }
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (createdTimestamp != null) {
            this.setCreatedTimestamp(PropertyConverter.importDate(createdTimestamp));
        }
        if (modifiedTimestamp != null) {
            this.setModifiedTimestamp(PropertyConverter.importDate(modifiedTimestamp));
        }
        if (routineKind != null) {
            this.setRoutineKind(PropertyConverter.importDasRoutineKind(routineKind));
        }
        if (routineType != null) {
            this.setRoutineType(PropertyConverter.importMsRoutineType(routineType));
        }
    }
}

