/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.mysql;

import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.families.ModFamily;
import com.intellij.database.model.families.ModNamingFamily;
import com.intellij.database.model.families.ModPositioningNamingFamily;
import com.intellij.database.model.mysql.MysqlModCheck;
import com.intellij.database.model.mysql.MysqlModForeignKey;
import com.intellij.database.model.mysql.MysqlModIndex;
import com.intellij.database.model.mysql.MysqlModKey;
import com.intellij.database.model.mysql.MysqlModLikeTable;
import com.intellij.database.model.mysql.MysqlModSchema;
import com.intellij.database.model.mysql.MysqlModTableColumn;
import com.intellij.database.model.mysql.MysqlModTrigger;
import com.intellij.database.model.mysql.MysqlTable;
import com.intellij.database.model.properties.MysqlEngine;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MysqlModTable
extends MysqlTable,
MysqlModLikeTable {
    @Override
    @NotNull
    public MysqlModSchema getSchema();

    @Override
    @NotNull
    default public MysqlModSchema getDbParent() {
        MysqlModSchema mysqlModSchema = this.getSchema();
        if (mysqlModSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModTable", "getDbParent"));
        }
        return mysqlModSchema;
    }

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModTable> getParentFamily();

    @Override
    @NotNull
    public ModPositioningNamingFamily<? extends MysqlModTableColumn> getColumns();

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModIndex> getIndices();

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModKey> getKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModForeignKey> getForeignKeys();

    @Override
    @NotNull
    public ModNamingFamily<? extends MysqlModCheck> getChecks();

    @NotNull
    public ModNamingFamily<? extends MysqlModTrigger> getTriggers();

    @Override
    @NotNull
    default public List<? extends ModFamily<? extends BasicModElement>> getFamilies() {
        List<ModFamily> list = Arrays.asList(this.getColumns(), this.getIndices(), this.getKeys(), this.getForeignKeys(), this.getChecks(), this.getTriggers());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModTable", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public JBIterable<? extends BasicModElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty().append((Iterable)this.getColumns()).append((Iterable)this.getIndices()).append((Iterable)this.getKeys()).append((Iterable)this.getForeignKeys()).append((Iterable)this.getChecks()).append((Iterable)this.getTriggers());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/mysql/MysqlModTable", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    public void setName(@NotNull String var1);

    @Override
    public void setNameSurrogate(boolean var1);

    @Override
    public void setComment(@Nullable String var1);

    @Override
    public void setSystem(boolean var1);

    public void setEngine(@NotNull MysqlEngine var1);

    @Override
    default public void importProperties(@NotNull Map<String, String> properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/database/model/mysql/MysqlModTable", "importProperties"));
        }
        String name = properties.get("Name");
        String nameSurrogate = properties.get("NameSurrogate");
        String comment = properties.get("Comment");
        String system = properties.get("System");
        String engine = properties.get("Engine");
        if (name != null) {
            this.setName(PropertyConverter.importString(name));
        }
        if (nameSurrogate != null) {
            this.setNameSurrogate(PropertyConverter.importBoolean(nameSurrogate));
        }
        if (comment != null) {
            this.setComment(PropertyConverter.importString(comment));
        }
        if (system != null) {
            this.setSystem(PropertyConverter.importBoolean(system));
        }
        if (engine != null) {
            this.setEngine(PropertyConverter.importMysqlEngine(engine));
        }
    }
}

