/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.model.postgres;

import com.intellij.database.model.ModelConsts;
import com.intellij.database.model.NameValueConsumer;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicKey;
import com.intellij.database.model.basic.BasicLeaf;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.families.NamingIdentifyingFamily;
import com.intellij.database.model.postgres.PostgresConstraint;
import com.intellij.database.model.postgres.PostgresSchema;
import com.intellij.database.model.postgres.PostgresTable;
import com.intellij.database.model.properties.PropertyConverter;
import com.intellij.util.containers.JBIterable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PostgresKey
extends PostgresConstraint,
BasicKey,
BasicLeaf {
    @Override
    @NotNull
    default public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresKey", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public PostgresTable getTable();

    @Override
    @Nullable
    default public PostgresTable getDbParent() {
        return this.getTable();
    }

    @Override
    @Nullable
    default public PostgresTable getMajorObject() {
        return this.getTable();
    }

    default public @Nullable NamingIdentifyingFamily<@NotNull ? extends PostgresKey> getParentFamily() {
        return null;
    }

    @Override
    @Nullable
    default public PostgresSchema getSchema() {
        PostgresTable table = this.getTable();
        return table != null ? table.getSchema() : null;
    }

    @Override
    @NotNull
    default public List<ObjectKind> getFamilyKinds() {
        List<ObjectKind> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresKey", "getFamilyKinds"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull List<@NotNull ? extends Family<@NotNull ? extends BasicElement>> getFamilies() {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresKey", "getFamilies"));
        }
        return list;
    }

    @Override
    @NotNull
    default public @NotNull JBIterable<@NotNull ? extends BasicElement> getDbChildren() {
        JBIterable jBIterable = JBIterable.empty();
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresKey", "getDbChildren"));
        }
        return jBIterable;
    }

    @Override
    default public long getObjectId() {
        return Long.MIN_VALUE;
    }

    @Override
    @NotNull
    default public String getName() {
        String string = ModelConsts.NO_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresKey", "getName"));
        }
        return string;
    }

    @Override
    default public boolean isNameSurrogate() {
        return false;
    }

    @Override
    @Nullable
    default public String getComment() {
        return null;
    }

    @Override
    @NotNull
    default public List<String> getColNames() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresKey", "getColNames"));
        }
        return list;
    }

    @Override
    default public boolean isDeferrable() {
        return false;
    }

    @Override
    default public boolean isInitiallyDeferred() {
        return false;
    }

    @Override
    @Nullable
    default public String getUnderlyingIndexName() {
        return null;
    }

    @Override
    default public boolean isPrimary() {
        return false;
    }

    @Override
    default public void exportProperties(@NotNull NameValueConsumer<String> consumer) {
        boolean primary;
        String underlyingIndexName;
        boolean initiallyDeferred;
        boolean deferrable;
        List<String> colNames;
        String comment;
        boolean nameSurrogate;
        String name;
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/intellij/database/model/postgres/PostgresKey", "exportProperties"));
        }
        long objectId = this.getObjectId();
        if (objectId != Long.MIN_VALUE) {
            consumer.accept("ObjectId", PropertyConverter.export(objectId));
        }
        if ((name = this.getName()) != null && name != ModelConsts.NO_NAME) {
            consumer.accept("Name", PropertyConverter.export(name));
        }
        if (nameSurrogate = this.isNameSurrogate()) {
            consumer.accept("NameSurrogate", PropertyConverter.export(nameSurrogate));
        }
        if ((comment = this.getComment()) != null) {
            consumer.accept("Comment", PropertyConverter.export(comment));
        }
        if (!(colNames = this.getColNames()).isEmpty()) {
            consumer.accept("ColNames", PropertyConverter.exportListOfString(colNames));
        }
        if (deferrable = this.isDeferrable()) {
            consumer.accept("Deferrable", PropertyConverter.export(deferrable));
        }
        if (initiallyDeferred = this.isInitiallyDeferred()) {
            consumer.accept("InitiallyDeferred", PropertyConverter.export(initiallyDeferred));
        }
        if ((underlyingIndexName = this.getUnderlyingIndexName()) != null) {
            consumer.accept("UnderlyingIndexName", PropertyConverter.export(underlyingIndexName));
        }
        if (primary = this.isPrimary()) {
            consumer.accept("Primary", PropertyConverter.export(primary));
        }
    }

    @Override
    @NotNull
    default public List<String> getPropertyNames() {
        List<String> list = Arrays.asList("ObjectId", "Name", "NameSurrogate", "Comment", "ColNames", "Deferrable", "InitiallyDeferred", "UnderlyingIndexName", "Primary");
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/model/postgres/PostgresKey", "getPropertyNames"));
        }
        return list;
    }
}

