/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.plan.oracle;

import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.plan.oracle.OracleExplainPlanProvider;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class OracleExplainPlanComponent
implements ConfigurableUi<LocalDataSource> {
    private JPanel myPanel;
    private JTextField myPlanTable = new JBTextField();

    public OracleExplainPlanComponent() {
        JBLabel label = new JBLabel("Plan table:");
        this.myPlanTable.setColumns(20);
        this.myPanel = new JPanel((LayoutManager)new GridLayoutManager(1, 2));
        GridConstraints gc = new GridConstraints();
        gc.setUseParentLayout(true);
        gc.setAnchor(8);
        gc.setFill(1);
        this.myPanel.add((Component)label, gc);
        gc.setColumn(1);
        this.myPanel.add((Component)this.myPlanTable, gc);
    }

    public void apply(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/oracle/OracleExplainPlanComponent", "apply"));
        }
        OracleExplainPlanProvider.setExplainPlanTable(dataSource, StringUtil.nullize((String)this.myPlanTable.getText()));
    }

    public void reset(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/oracle/OracleExplainPlanComponent", "reset"));
        }
        this.myPlanTable.setText(OracleExplainPlanProvider.getExplainPlanTable(dataSource));
    }

    public boolean isModified(@NotNull LocalDataSource dataSource) {
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/plan/oracle/OracleExplainPlanComponent", "isModified"));
        }
        return !Comparing.equal((String)OracleExplainPlanProvider.getExplainPlanTable(dataSource), (String)StringUtil.nullize((String)this.myPlanTable.getText()));
    }

    @NotNull
    public JComponent getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/plan/oracle/OracleExplainPlanComponent", "getComponent"));
        }
        return jPanel;
    }
}

