/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.model.DeColumn;
import com.intellij.database.schemaEditor.model.DeColumnListBase;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.DasUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeForeignKey
extends DeColumnListBase
implements DasForeignKey {
    @Nullable
    public DeTable target;
    @NotNull
    public final List<Ref> refs;
    public DasForeignKey.RuleAction updateRule;
    public DasForeignKey.RuleAction deleteRule;
    public DasForeignKey.Deferrability deferrability;

    protected DeForeignKey(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeForeignKey", "<init>"));
        }
        super(model);
        this.refs = ContainerUtil.newArrayList();
        this.updateRule = DasForeignKey.RuleAction.RESTRICT;
        this.deleteRule = DasForeignKey.RuleAction.RESTRICT;
        this.deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    public DeForeignKey(@NotNull String name, @NotNull DeTable table, @NotNull DeModel model) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/schemaEditor/model/DeForeignKey", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/schemaEditor/model/DeForeignKey", "<init>"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeForeignKey", "<init>"));
        }
        super(name, table, model);
        this.refs = ContainerUtil.newArrayList();
        this.updateRule = DasForeignKey.RuleAction.RESTRICT;
        this.deleteRule = DasForeignKey.RuleAction.RESTRICT;
        this.deferrability = DasForeignKey.Deferrability.NOT_DEFERRABLE;
    }

    @Override
    @NotNull
    public DeObject copyFrom(@NotNull DeObject obj, boolean withChildren, @NotNull DeObject.DeCopier copier) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeForeignKey", "copyFrom"));
        }
        if (copier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "copier", "com/intellij/database/schemaEditor/model/DeForeignKey", "copyFrom"));
        }
        super.copyFrom(obj, withChildren, copier);
        DeForeignKey fk = (DeForeignKey)obj;
        this.target = copier.copy(fk.target, true);
        this.refs.clear();
        for (Ref ref : fk.refs) {
            DeColumn reference = copier.copy(ref.ref, false);
            DeColumn target = copier.copy(ref.target, false);
            this.refs.add(new Ref(reference, target));
        }
        this.updateRule = fk.updateRule;
        this.deleteRule = fk.deleteRule;
        this.deferrability = fk.deferrability;
        DeForeignKey deForeignKey = this;
        if (deForeignKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeForeignKey", "copyFrom"));
        }
        return deForeignKey;
    }

    @Override
    @NotNull
    public Iterable<DeColumn> getColumns() {
        JBIterable jBIterable = JBIterable.from(this.refs).transform(ref -> ref.ref);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeForeignKey", "getColumns"));
        }
        return jBIterable;
    }

    @NotNull
    public Iterable<DeColumn> getTargetColumns() {
        JBIterable jBIterable = JBIterable.from(this.refs).transform(ref -> ref.target);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeForeignKey", "getTargetColumns"));
        }
        return jBIterable;
    }

    @Override
    @NotNull
    public DeObject emptyClone(@NotNull DeModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/schemaEditor/model/DeForeignKey", "emptyClone"));
        }
        DeForeignKey deForeignKey = new DeForeignKey(model);
        if (deForeignKey == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeForeignKey", "emptyClone"));
        }
        return deForeignKey;
    }

    @Override
    public boolean isAlteredIgnoringChild(@NotNull DeObject other, @NotNull Collection<? extends DeObject> children, @NotNull Collection<? extends DasObject> otherChildren) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "other", "com/intellij/database/schemaEditor/model/DeForeignKey", "isAlteredIgnoringChild"));
        }
        if (children == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "children", "com/intellij/database/schemaEditor/model/DeForeignKey", "isAlteredIgnoringChild"));
        }
        if (otherChildren == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "otherChildren", "com/intellij/database/schemaEditor/model/DeForeignKey", "isAlteredIgnoringChild"));
        }
        DeForeignKey otherFk = (DeForeignKey)other;
        return this.updateRule != otherFk.updateRule || this.deleteRule != otherFk.deleteRule || this.deferrability != otherFk.deferrability || DeForeignKey.isObjectIdentityAltered(this.target, otherFk.target) || DeForeignKey.isObjectsIdentityAltered(this.getTargetColumns(), otherFk.getTargetColumns()) || super.isAlteredIgnoringChild(other, children, otherChildren);
    }

    public String getRefTableName() {
        return this.target == null ? null : this.target.name;
    }

    public String getRefTableSchema() {
        DasObject schema = DasUtil.getParentOfKind((DasObject)this.target, (ObjectKind)ObjectKind.SCHEMA, (boolean)true);
        return schema == null ? null : schema.getName();
    }

    public String getRefTableCatalog() {
        return null;
    }

    @Nullable
    public DasTable getRefTable() {
        return this.target;
    }

    @NotNull
    public MultiRef<? extends DasTypedObject> getRefColumns() {
        MultiRef multiRef = DasUtil.asRef(this.getTargetColumns());
        if (multiRef == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeForeignKey", "getRefColumns"));
        }
        return multiRef;
    }

    public DasForeignKey.RuleAction getDeleteRule() {
        return this.deleteRule;
    }

    public DasForeignKey.RuleAction getUpdateRule() {
        return this.updateRule;
    }

    public DasForeignKey.Deferrability getDeferrability() {
        return this.deferrability;
    }

    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.FOREIGN_KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeForeignKey", "getKind"));
        }
        return objectKind;
    }

    public static class Ref {
        public final DeColumn ref;
        public final DeColumn target;

        public Ref(DeColumn ref, DeColumn target) {
            this.ref = ref;
            this.target = target;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Ref ref1 = (Ref)o;
            if (this.ref != null ? !this.ref.equals(ref1.ref) : ref1.ref != null) {
                return false;
            }
            return !(this.target != null ? !this.target.equals(ref1.target) : ref1.target != null);
        }

        public int hashCode() {
            int result = this.ref != null ? this.ref.hashCode() : 0;
            result = 31 * result + (this.target != null ? this.target.hashCode() : 0);
            return result;
        }
    }
}

