/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.schemaEditor.model;

import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.schemaEditor.SchemaExportHelper;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.schemaEditor.model.DeTable;
import com.intellij.database.util.Casing;
import com.intellij.database.util.DasUtil;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeModel
implements DasModel {
    public static final DeModel STUB = new DeModel(null, null);
    private final DasModel myModel;
    private final SchemaExportHelper myHelper;
    private final Set<DeObject> myRoots = ContainerUtil.newLinkedHashSet();

    public DeModel(@Nullable DasModel model, @Nullable SchemaExportHelper helper) {
        this.myModel = model;
        this.myHelper = helper;
    }

    @NotNull
    public JBIterable<? extends DasObject> getModelRoots() {
        JBIterable jBIterable = JBIterable.from(this.myRoots);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeModel", "getModelRoots"));
        }
        return jBIterable;
    }

    @Nullable
    public DasNamespace getCurrentRootNamespace() {
        throw new AssertionError((Object)"todo");
    }

    @NotNull
    public JBTreeTraverser<DasObject> traverser() {
        JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)DasUtil.dasTraverser().withRoots(this.getModelRoots());
        if (jBTreeTraverser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeModel", "traverser"));
        }
        return jBTreeTraverser;
    }

    @NotNull
    public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
        if (this.myModel == null || this.myModel == DasUtil.emptyModel() || this.myHelper == null) {
            JBIterable jBIterable = this.traverser().filter(DasForeignKey.class).filter(key -> key.getRefTable() == table);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeModel", "getExportedKeys"));
            }
            return jBIterable;
        }
        DeTable deTable = (DeTable)ObjectUtils.tryCast((Object)table, DeTable.class);
        if (deTable == null || deTable.editedObject == null) {
            JBIterable jBIterable = JBIterable.empty();
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeModel", "getExportedKeys"));
            }
            return jBIterable;
        }
        JBIterable jBIterable = this.myModel.getExportedKeys((DasTable)deTable.editedObject).filter((Condition)new Condition<DasConstraint>(){

            public boolean value(DasConstraint constraint) {
                return DeModel.this.myHelper.canExport((DasObject)constraint);
            }
        }).transform((Function)new Function<DasConstraint, DasConstraint>(){

            public DasConstraint fun(DasConstraint constraint) {
                DeModel.this.myHelper.export((DasObject)constraint.getTable(), true);
                return (DasConstraint)DeModel.this.myHelper.export((DasObject)constraint, true);
            }
        });
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeModel", "getExportedKeys"));
        }
        return jBIterable;
    }

    @NotNull
    public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/schemaEditor/model/DeModel", "getCasing"));
        }
        Casing casing = this.myModel == null ? DasUtil.CASING_EXACT : this.myModel.getCasing(kind, context);
        if (casing == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeModel", "getCasing"));
        }
        return casing;
    }

    @NotNull
    public DeModel addRoot(@NotNull DeObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeModel", "addRoot"));
        }
        this.myRoots.add(obj);
        DeModel deModel = this;
        if (deModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/schemaEditor/model/DeModel", "addRoot"));
        }
        return deModel;
    }

    public void removeRoot(@NotNull DeObject obj) {
        if (obj == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "obj", "com/intellij/database/schemaEditor/model/DeModel", "removeRoot"));
        }
        this.myRoots.remove(obj);
    }

    public DasModel getModel() {
        return this.myModel;
    }

    public SchemaExportHelper getExportHelper() {
        return this.myHelper;
    }
}

