/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.serialization;

import com.intellij.database.model.ModelFun;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicModElement;
import com.intellij.database.model.basic.BasicModModel;
import com.intellij.database.model.basic.BasicModNamedElement;
import com.intellij.database.model.basic.BasicModRoot;
import com.intellij.database.model.families.Family;
import com.intellij.database.model.impl.ModelFactory;
import com.intellij.database.serialization.ImportException;
import com.intellij.database.serialization.ModelConverters;
import com.intellij.database.serialization.ModelElementMem;
import com.intellij.database.serialization.ModelMem;
import com.intellij.database.serialization.ModelSerializationFun;
import com.intellij.database.serialization.ModelSerializationVersions;
import com.intellij.database.serialization.MutableNameAndValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.ErrorWriter;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.Rdbms;
import org.jetbrains.dekaf.util.Version;

public final class ModelImporter {
    private static final ModelConverters ourConverters = new ModelConverters();
    private static final Logger LOG = Logger.getInstance(ModelImporter.class);
    @NotNull
    private final ModelFactory myModelFactory;
    public Set<String> myUnconsumedProperties;

    public ModelImporter(@NotNull ModelFactory modelFactory) {
        if (modelFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelFactory", "com/intellij/database/serialization/ModelImporter", "<init>"));
        }
        this.myUnconsumedProperties = null;
        this.myModelFactory = modelFactory;
    }

    @NotNull
    public ModelMem deserializeModel(@NotNull HierarchicalStreamReader reader) throws ImportException {
        Version formatVersion;
        Rdbms rdbms;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "deserializeModel"));
        }
        String rootNodeName = reader.getNodeName();
        if (!rootNodeName.equalsIgnoreCase("database-model")) {
            throw new ImportException("The root node of the database model must be database-model, but found " + rootNodeName);
        }
        String rdbmsCode = reader.getAttribute("rdbms");
        if (rdbmsCode == null) {
            throw new ImportException("RDBMS is not specified int the model file");
        }
        if (rdbmsCode.equalsIgnoreCase("POSTGRE")) {
            rdbmsCode = "POSTGRES";
        }
        if ((rdbms = ModelImporter.findRdbms(rdbmsCode)) == null) {
            throw new ImportException("Error reading RDBMS: unable to find " + rdbmsCode);
        }
        try {
            String formatVersionString = reader.getAttribute("format-version");
            formatVersion = formatVersionString == null ? Version.ZERO : Version.of((String)formatVersionString);
        }
        catch (Exception e) {
            throw new ImportException("Error reading format version: " + e.getMessage(), e);
        }
        ModelMem mm = new ModelMem();
        mm.setRdbms(rdbms);
        mm.setVersion(formatVersion);
        int n = reader.getAttributeCount();
        for (int i2 = 0; i2 < n; ++i2) {
            String attrValue;
            String attrName = reader.getAttributeName(i2);
            if (attrName.equalsIgnoreCase("rdbms") || attrName.equalsIgnoreCase("format-version") || (attrValue = reader.getAttribute(i2)) == null || attrValue.isEmpty()) continue;
            mm.getProperties().put(attrName, attrValue);
        }
        if (formatVersion.compareTo(ModelSerializationVersions.MIN_VERSION) < 0 || formatVersion.compareTo(ModelSerializationVersions.CURRENT_VERSION) > 0) {
            String message = "Unsupported format version " + formatVersion + " (the " + ModelSerializationVersions.CURRENT_VERSION + " is expected)";
            reader.appendErrors((ErrorWriter)new ConversionException(message));
        } else {
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                ModelElementMem mem = ModelImporter.deserializeObject(reader);
                mm.getNodes().add(mem);
                reader.moveUp();
            }
        }
        ModelMem modelMem = mm;
        if (modelMem == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelImporter", "deserializeModel"));
        }
        return modelMem;
    }

    private static Rdbms findRdbms(String rdbmsCode) {
        for (Rdbms cur : ModelFun.getAllRdbms()) {
            if (!cur.code.equals(rdbmsCode)) continue;
            return cur;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ModelElementMem deserializeObject(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "deserializeObject"));
        }
        String kind = reader.getNodeName();
        Integer id = ModelImporter.parseId(reader);
        Integer parentId = ModelImporter.parseParentId(reader);
        String name = StringUtil.nullize((String)reader.getAttribute("name"));
        ModelElementMem em = new ModelElementMem();
        em.setKind(kind);
        em.setId(id);
        em.setParentId(parentId);
        em.setName(name);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            try {
                String key = reader.getNodeName();
                key = ModelSerializationFun.normalize(key);
                String value = reader.getValue();
                value = ModelSerializationFun.normalize(value);
                if (key == null || value == null || key.equalsIgnoreCase("name")) continue;
                em.getProperties().add(new MutableNameAndValue(key, value));
            }
            finally {
                reader.moveUp();
            }
        }
        return em;
    }

    private static Integer parseId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "parseId"));
        }
        String str = reader.getAttribute("id");
        if (StringUtil.isEmpty((String)str)) {
            throw new ImportException("The node " + reader.getNodeName() + " has no id");
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse id", nfe);
        }
    }

    private static Integer parseParentId(@NotNull HierarchicalStreamReader reader) throws ImportException {
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/intellij/database/serialization/ModelImporter", "parseParentId"));
        }
        String str = reader.getAttribute("parent");
        if (StringUtil.isEmpty((String)str)) {
            return null;
        }
        try {
            return new Integer(str.trim());
        }
        catch (NumberFormatException nfe) {
            throw new ImportException("Failed to parse parent id", nfe);
        }
    }

    public BasicModModel importModel(@NotNull ModelMem modelMem) throws ImportException {
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "importModel"));
        }
        ourConverters.convertMem(modelMem);
        BasicModModel model = this.createModel2(modelMem.getRdbms());
        model.modify(BasicModRoot.class, root2 -> {
            if (modelMem == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "lambda$importModel$0"));
            }
            this.populateModel(modelMem, (BasicModRoot)root2);
        });
        ourConverters.convertModel(model, modelMem.getVersion());
        return model;
    }

    private BasicModModel createModel2(@NotNull Rdbms rdbms) {
        if (rdbms == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rdbms", "com/intellij/database/serialization/ModelImporter", "createModel2"));
        }
        return this.myModelFactory.createModel(rdbms);
    }

    private void populateModel(@NotNull ModelMem modelMem, @NotNull BasicModRoot root2) {
        BasicModElement element;
        if (modelMem == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelMem", "com/intellij/database/serialization/ModelImporter", "populateModel"));
        }
        if (root2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/database/serialization/ModelImporter", "populateModel"));
        }
        HashMap<Integer, BasicModRoot> elements = new HashMap<Integer, BasicModRoot>(modelMem.getNodes().size());
        for (ModelElementMem mem : modelMem.getNodes()) {
            ObjectKind kind = (ObjectKind)ObjectKind.ourKinds.get(mem.getKind());
            if (kind == null) {
                throw new AssertionError((Object)("ObjectKind " + mem.getKind() + " not found"));
            }
            if (mem.getParentId() == null) {
                if (kind != ObjectKind.ROOT) {
                    throw new ImportException("Only a root object can be a root of the tree. However, found " + mem.getKind() + " without a parent");
                }
                element = root2;
            } else {
                BasicModElement parent = (BasicModElement)elements.get(mem.getParentId());
                if (parent == null) {
                    throw new ImportException("Object " + mem.getId() + " references parent " + mem.getParentId() + " that is not found or not processed yet");
                }
                Family family = parent.familyOf(kind);
                if (family == null) continue;
                element = family.createNewOne();
                if (element instanceof BasicModNamedElement) {
                    ((BasicModNamedElement)element).setRealName(mem.getName());
                }
            }
            elements.put(mem.getId(), (BasicModRoot)element);
        }
        TreeMap<String, String> propertiesMap = new TreeMap<String, String>();
        for (ModelElementMem mem : modelMem.getNodes()) {
            element = (BasicModElement)elements.get(mem.getId());
            if (element == null) {
                LOG.error("An element " + mem + " was not instantiated or lost");
                continue;
            }
            propertiesMap.clear();
            for (MutableNameAndValue p : mem.getProperties()) {
                propertiesMap.put(ModelImporter.nameFromXmlToHumps(p.getName()), p.getValue());
            }
            element.importProperties(propertiesMap);
            Set<String> unconsumedProperties = this.myUnconsumedProperties;
            if (unconsumedProperties == null) continue;
            propertiesMap.keySet().removeAll(element.getPropertyNames());
            if (propertiesMap.isEmpty()) continue;
            String className = element.getModel().getClass().getSimpleName() + '.' + element.getClass().getSimpleName() + '.';
            for (String propName : propertiesMap.keySet()) {
                unconsumedProperties.add(className + propName);
            }
        }
    }

    public void setUnconsumedProperties(Set<String> unconsumedProperties) {
        this.myUnconsumedProperties = unconsumedProperties;
    }

    @NotNull
    static String nameFromXmlToHumps(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/serialization/ModelImporter", "nameFromXmlToHumps"));
        }
        String string = StringUtil.capitalizeWords((String)name, (String)"-", (boolean)true, (boolean)true).replace("-", "");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/serialization/ModelImporter", "nameFromXmlToHumps"));
        }
        return string;
    }
}

