/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.view.editors.DatabaseEditorBase;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DatabaseEditorState {
    public final DatabaseEditorContext context;
    private final Set<DatabaseEditorBase> myInvalidEditors;
    public final EventDispatcher<EditorModelBase.Listener> validationTopic;

    public DatabaseEditorState(@NotNull DatabaseEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/editors/DatabaseEditorState", "<init>"));
        }
        this.myInvalidEditors = ContainerUtil.newHashSet();
        this.validationTopic = EventDispatcher.create(EditorModelBase.Listener.class);
        this.context = context;
    }

    public void markInvalid(@NotNull DatabaseEditorBase editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseEditorState", "markInvalid"));
        }
        this.myInvalidEditors.add(editor);
    }

    public void markValid(@NotNull DatabaseEditorBase editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/database/view/editors/DatabaseEditorState", "markValid"));
        }
        if (this.myInvalidEditors.isEmpty()) {
            return;
        }
        this.myInvalidEditors.remove(editor);
        if (this.myInvalidEditors.isEmpty()) {
            ((EditorModelBase.Listener)this.validationTopic.getMulticaster()).changed();
        }
    }

    public boolean areAllEditorsValid() {
        return this.myInvalidEditors.isEmpty();
    }
}

