/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.editors;

import com.intellij.database.schemaEditor.SchemaEditorHelper;
import com.intellij.database.schemaEditor.model.DeModel;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.view.DatabaseDialogsHelper;
import com.intellij.database.view.editors.DatabaseEditorContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.ui.EditorTextField;
import com.intellij.util.Function;
import com.intellij.util.Processor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class DdlPreviewBase {
    protected final EditorTextField myPreview;
    protected final DatabaseEditorContext myContext;
    private final Function<Runnable, ActionCallback> myAsyncProcessor;

    public DdlPreviewBase(@NotNull DatabaseEditorContext context, @NotNull Function<Runnable, ActionCallback> asyncProcessor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/editors/DdlPreviewBase", "<init>"));
        }
        if (asyncProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "asyncProcessor", "com/intellij/database/view/editors/DdlPreviewBase", "<init>"));
        }
        this.myContext = context;
        this.myAsyncProcessor = asyncProcessor;
        this.myPreview = DatabaseDialogsHelper.createLanguageEditorArea(this.myContext, "");
    }

    @NotNull
    public JComponent getComponent() {
        EditorTextField editorTextField = this.myPreview;
        if (editorTextField == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DdlPreviewBase", "getComponent"));
        }
        return editorTextField;
    }

    @NotNull
    public JComponent getPreferredFocusedComponent() {
        JComponent jComponent = this.myPreview.getFocusTarget();
        if (jComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DdlPreviewBase", "getPreferredFocusedComponent"));
        }
        return jComponent;
    }

    public boolean updatePreview(@NotNull Processor<SchemaEditorHelper> codeBuilder, @NotNull DeModel model) {
        String statement;
        boolean valid;
        if (codeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "codeBuilder", "com/intellij/database/view/editors/DdlPreviewBase", "updatePreview"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/view/editors/DdlPreviewBase", "updatePreview"));
        }
        try {
            DdlBuilder builder = DatabaseDialogsHelper.createDdlBuilder(this.myContext, false);
            SchemaEditorHelper helper = new SchemaEditorHelper(this.myContext);
            valid = codeBuilder.process((Object)helper);
            helper.fix().generate(builder, model, this.myAsyncProcessor);
            statement = DatabaseDialogsHelper.concatQueries(builder);
        }
        catch (UnsupportedOperationException e) {
            statement = "-- " + e.getMessage();
            valid = false;
        }
        this.myPreview.setText(statement);
        this.scrollToBeginning();
        return valid;
    }

    protected void scrollToBeginning() {
        Editor editor = this.myPreview.getEditor();
        if (editor != null) {
            editor.getScrollingModel().scrollVertically(0);
            editor.getCaretModel().moveToOffset(0);
        }
    }

    @NotNull
    public String getPreviewText() {
        String string = this.myPreview.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/editors/DdlPreviewBase", "getPreviewText"));
        }
        return string;
    }
}

