/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.models;

import com.intellij.database.model.DasObject;
import com.intellij.database.schemaEditor.model.DeObject;
import com.intellij.database.view.models.EditorModelBase;
import com.intellij.database.view.models.EditorModelsCache;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.JBIterable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObjectEditorModel<Impl extends DeObject>
extends EditorModelBase {
    @NotNull
    protected final Impl myObject;

    public ObjectEditorModel(@NotNull Impl object, @NotNull EditorModelsCache models) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/database/view/models/ObjectEditorModel", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/intellij/database/view/models/ObjectEditorModel", "<init>"));
        }
        super(((DeObject)object).model, models);
        this.myObject = object;
    }

    @NotNull
    public Impl getObject() {
        Impl Impl2 = this.myObject;
        if (Impl2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ObjectEditorModel", "getObject"));
        }
        return Impl2;
    }

    public void setName(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/view/models/ObjectEditorModel", "setName"));
        }
        if (name.equals(((DeObject)this.myObject).name)) {
            return;
        }
        ((DeObject)this.myObject).name = name;
        this.modify();
    }

    public void setComment(@Nullable String comment) {
        if (Comparing.equal((String)((DeObject)this.myObject).comment, (String)comment)) {
            return;
        }
        ((DeObject)this.myObject).comment = comment;
        this.modify();
    }

    @NotNull
    public String getName() {
        String string = ((DeObject)this.myObject).name;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ObjectEditorModel", "getName"));
        }
        return string;
    }

    @Nullable
    public String getComment() {
        return ((DeObject)this.myObject).comment;
    }

    @Nullable
    public DasObject getEditedObject() {
        return ((DeObject)this.myObject).editedObject;
    }

    @NotNull
    public JBIterable<Impl> getEditedObjects() {
        JBIterable jBIterable = JBIterable.of(this.myObject);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/models/ObjectEditorModel", "getEditedObjects"));
        }
        return jBIterable;
    }
}

