/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.editor;

import com.intellij.codeInsight.editorActions.JavaLikeQuoteHandler;
import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.sql.psi.SqlTokens;
import org.jetbrains.annotations.NotNull;

public class SqlQuoteHandler
extends SimpleTokenSetQuoteHandler {
    public SqlQuoteHandler() {
        super(new IElementType[]{SqlTokens.SQL_STRING_TOKEN, SqlTokens.SQL_IDENT_DELIMITED, SqlTokens.SQL_UNCLOSED_TOKEN, SqlTokens.SQL_CUSTOM_QUOTED_STRING_TOKEN});
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        return SqlTokens.SQL_UNCLOSED_TOKEN == iterator.getTokenType() && offset == iterator.getStart() + 1 || super.isOpeningQuote(iterator, offset);
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        return iterator.getTokenType() == SqlTokens.SQL_UNCLOSED_TOKEN || super.isNonClosedLiteral(iterator, chars);
    }

    public static class Plus
    extends Concat {
        @Override
        public String getStringConcatenationOperatorRepresentation() {
            return "+";
        }
    }

    public static class Concat
    extends SqlQuoteHandler
    implements JavaLikeQuoteHandler {
        private static final TokenSet CONCAT_SET = TokenSet.create((IElementType[])new IElementType[]{SqlTokens.SQL_STRING_TOKEN});

        public TokenSet getConcatenatableStringTokenTypes() {
            return CONCAT_SET;
        }

        public String getStringConcatenationOperatorRepresentation() {
            return "||";
        }

        public TokenSet getStringTokenTypes() {
            return null;
        }

        public boolean isAppropriateElementTypeForLiteral(@NotNull IElementType tokenType) {
            if (tokenType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tokenType", "com/intellij/sql/editor/SqlQuoteHandler$Concat", "isAppropriateElementTypeForLiteral"));
            }
            return true;
        }

        public boolean needParenthesesAroundConcatenation(PsiElement element) {
            return false;
        }
    }
}

