/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.formatter.settings;

import com.intellij.application.options.CodeStyleAbstractPanel;
import com.intellij.application.options.IndentOptionsEditor;
import com.intellij.application.options.TabbedLanguageCodeStylePanel;
import com.intellij.application.options.codeStyle.OptionTableWithPreviewPanel;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.formatter.settings.SqlCodeGenerationMainPanel;
import com.intellij.sql.formatter.settings.SqlCodeStyleSettings;
import com.intellij.sql.highlighting.SqlSyntaxHighlighter;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;

public class SqlCodeStyleMainPanel
extends TabbedLanguageCodeStylePanel {
    private static final SqlLanguageDialect DIALECT = (SqlLanguageDialect)ObjectUtils.assertNotNull((Object)DbSqlUtil.findDialectById("MySQL"));
    private final JBCheckBox myDisableCb = new JBCheckBox("Disable formatting");
    private final JPanel myWrapper = new JPanel(new BorderLayout());

    protected SqlCodeStyleMainPanel(CodeStyleSettings currentSettings, CodeStyleSettings settings) {
        super((Language)SqlLanguage.INSTANCE, currentSettings, settings);
        final JComponent panel = super.getPanel();
        assert (panel != null);
        this.myWrapper.add((Component)panel, "Center");
        this.myDisableCb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(@NotNull ChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel$1", "stateChanged"));
                }
                UIUtil.setEnabled((Component)panel, (!SqlCodeStyleMainPanel.this.myDisableCb.isSelected() ? 1 : 0) != 0, (boolean)true);
            }
        });
        this.myDisableCb.setSelected(SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)this.getCurrentSettings()).DISABLE_FORMATTING);
        this.myDisableCb.setBorder(IdeBorderFactory.createEmptyBorder((int)4, (int)0, (int)0, (int)0));
        this.myWrapper.add((Component)this.myDisableCb, "South");
    }

    public void apply(CodeStyleSettings settings) throws ConfigurationException {
        super.apply(settings);
        SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING = this.myDisableCb.isSelected();
        DatabaseSettings.fireSettingsChanged();
    }

    protected void initTabs(CodeStyleSettings settings) {
        IndentOptionsEditor indentOptionsEditor;
        this.addTab((CodeStyleAbstractPanel)new SqlSpecificPanel(settings));
        LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)SqlLanguage.INSTANCE);
        IndentOptionsEditor indentOptionsEditor2 = indentOptionsEditor = provider != null ? provider.getIndentOptionsEditor() : null;
        if (indentOptionsEditor != null) {
            this.addTab((CodeStyleAbstractPanel)new SqlIndentOptionsWrapper(settings, provider, indentOptionsEditor));
        }
        this.addTab((CodeStyleAbstractPanel)new SqlSpacesPanel(settings));
        this.addTab((CodeStyleAbstractPanel)new SqlWrappingAndBracesPanel(settings));
        this.addTab((CodeStyleAbstractPanel)new SqlBlankLinesPanel(settings));
        this.addTab(new SqlCodeGenerationMainPanel(settings));
    }

    public boolean isModified(CodeStyleSettings settings) {
        return super.isModified(settings) || SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING != this.myDisableCb.isSelected();
    }

    protected void resetImpl(CodeStyleSettings settings) {
        super.resetImpl(settings);
        this.myDisableCb.setSelected(SqlCodeStyleMainPanel.getSqlSettings((CodeStyleSettings)settings).DISABLE_FORMATTING);
    }

    public JComponent getPanel() {
        return this.myWrapper;
    }

    @NotNull
    private static SqlCodeStyleSettings getSqlSettings(@NotNull CodeStyleSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel", "getSqlSettings"));
        }
        SqlCodeStyleSettings sqlCodeStyleSettings = (SqlCodeStyleSettings)settings.getCustomSettings(SqlCodeStyleSettings.class);
        if (sqlCodeStyleSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/sql/formatter/settings/SqlCodeStyleMainPanel", "getSqlSettings"));
        }
        return sqlCodeStyleSettings;
    }

    protected static PsiFile createSqlFile(Project project, String text) {
        return PsiFileFactory.getInstance((Project)project).createFileFromText("a.sql", (Language)DIALECT, (CharSequence)text);
    }

    private static EditorHighlighter createSqlHighlighter(EditorColorsScheme scheme) {
        return new LexerEditorHighlighter((SyntaxHighlighter)new SqlSyntaxHighlighter(DIALECT, null), scheme);
    }

    public static class SqlSpecificPanel
    extends OptionTableWithPreviewPanel {
        private static final String ALIGNMENT = "Alignment";
        private static final String INDENT = "Indent";
        private static final String NEW_LINE_BEFORE = "New line before";
        private static final String NEW_LINE_AFTER = "New line after";
        private static final String CASE_OPTIONS = "Word Case";

        public SqlSpecificPanel(CodeStyleSettings settings) {
            super(settings);
            this.init();
        }

        protected void initTables() {
            this.showSqlCustomOption("KEYWORD_CASE", "Keywords", CASE_OPTIONS, SqlCodeStyleSettings.TOKEN_CASE_NAMES, SqlCodeStyleSettings.TOKEN_CASE);
            this.showSqlCustomOption("TYPE_CASE", "Types", CASE_OPTIONS, SqlCodeStyleSettings.TOKEN_CASE_NAMES_EXT, SqlCodeStyleSettings.TOKEN_CASE_EXT);
            this.showSqlCustomOption("IDENTIFIER_CASE", "Identifiers", CASE_OPTIONS, SqlCodeStyleSettings.TOKEN_CASE_NAMES, SqlCodeStyleSettings.TOKEN_CASE);
            this.showSqlCustomOption("QUOTED_IDENTIFIER_CASE", "Quoted identifiers", CASE_OPTIONS, SqlCodeStyleSettings.TOKEN_CASE_NAMES, SqlCodeStyleSettings.TOKEN_CASE);
            this.showSqlCustomOption("QUOTE_IDENTIFIER", "Identifier quotation", null, SqlCodeStyleSettings.QUOTE_OPTIONS_NAMES, SqlCodeStyleSettings.QUOTE_OPTIONS);
            this.showSqlCustomOption("NEW_LINE_AFTER_SELECT_2", "Select items", NEW_LINE_BEFORE, SqlCodeStyleSettings.NEW_LINE_AFTER_SELECT_NAMES, SqlCodeStyleSettings.NEW_LINE_AFTER_SELECT_VALUES);
            this.showSqlCustomOption("NEW_LINE_BEFORE_FROM", "From clause", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_JOIN", "Join expression", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_JOIN_CONDITION", "Join condition", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_WHERE", "Where clause", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_GROUP_BY", "Group by clause", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_ORDER_BY", "Order by clause", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_HAVING", "Having clause", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_ELSE", "Else clause", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_THEN", "Then clause", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_OTHER_CLAUSES", "Other clauses", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_COMMA", "Comma (in select items)", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_QUERY_INSIDE_PARENTHESIS", "Query expression inside parenthesis", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_BEFORE_QUERY_INSIDE_DML", "Query expression inside DML statements", NEW_LINE_BEFORE, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_AFTER_SELECT_ITEM", "Each selected item", NEW_LINE_AFTER, new Object[0]);
            this.showSqlCustomOption("NEW_LINE_AROUND_SEMICOLON", "New line around semicolon", null, new Object[0]);
            this.showSqlCustomOption("ALIGN_AS_IN_SELECT_STATEMENT", "`as` inside select statement", ALIGNMENT, new Object[0]);
            this.showSqlCustomOption("ALIGN_TYPE_IN_CREATE_STATEMENT", "Types inside create table", ALIGNMENT, new Object[0]);
            this.showSqlCustomOption("ALIGN_TYPE_IN_BLOCK_STATEMENT", "Types in variable declarations", ALIGNMENT, new Object[0]);
            this.showSqlCustomOption("ALIGN_TYPE_IN_ARGUMENT_DEFINITION", "Types in procedure definition", ALIGNMENT, new Object[0]);
            this.showSqlCustomOption("ALIGN_INSIDE_BINARY_EXPRESSION", "Inside binary expression", ALIGNMENT, new Object[0]);
            this.showSqlCustomOption("ALIGN_INSIDE_QUERY_EXPRESSION", "Inside query expression", ALIGNMENT, new Object[0]);
            this.showSqlCustomOption("ALIGN_EQ_INSIDE_SET_CLAUSE", "`=` inside set clause", ALIGNMENT, new Object[0]);
            this.showSqlCustomOption("INDENT_JOIN", "Join expression", INDENT, new Object[0]);
            this.showSqlCustomOption("INDENT_JOIN_CONDITION", "Join condition", INDENT, new Object[0]);
            this.showSqlCustomOption("INDENT_SELECT_INTO_CLAUSE", "Into clause in select statement", INDENT, new Object[0]);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName, Object ... options) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, options);
        }

        public LanguageCodeStyleSettingsProvider.SettingsType getSettingsType() {
            return LanguageCodeStyleSettingsProvider.SettingsType.LANGUAGE_SPECIFIC;
        }

        protected String getPreviewText() {
            return SqlSpecificPanel.readFromFile(((Object)((Object)this)).getClass(), (String)"preview.sql.template");
        }

        protected void customizeSettings() {
            this.resetDefaultNames();
            LanguageCodeStyleSettingsProvider provider = LanguageCodeStyleSettingsProvider.forLanguage((Language)SqlLanguage.INSTANCE);
            if (provider != null) {
                provider.customizeSettings((CodeStyleSettingsCustomizable)this, this.getSettingsType());
            }
        }

        protected String getTabTitle() {
            return "General";
        }

        protected PsiFile createFileFromText(Project project, String text) {
            return SqlCodeStyleMainPanel.createSqlFile(project, text);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }
    }

    private class SqlWrappingAndBracesPanel
    extends TabbedLanguageCodeStylePanel.MyWrappingAndBracesPanel {
        private static final String WRAP_INSIDE = "Wrap inside";

        public SqlWrappingAndBracesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        protected PsiFile createFileFromText(Project project, String text) {
            return SqlCodeStyleMainPanel.createSqlFile(project, text);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }

        private void showSqlCustomOption(String fieldName, String title, String groupName, Object ... options) {
            this.showCustomOption(SqlCodeStyleSettings.class, fieldName, title, groupName, options);
        }

        private void showWrapOption(String fieldName, String title) {
            this.showWrapOption(fieldName, title, WRAP_INSIDE);
        }

        private void showWrapOption(String fieldName, String title, String groupName) {
            this.showSqlCustomOption(fieldName, title, groupName, CodeStyleSettingsCustomizable.WRAP_OPTIONS, CodeStyleSettingsCustomizable.WRAP_VALUES);
        }

        protected void initTables() {
            this.addOption("KEEP_LINE_BREAKS", ApplicationBundle.message((String)"wrapping.keep.line.breaks", (Object[])new Object[0]), WRAPPING_KEEP);
            this.addOption("KEEP_FIRST_COLUMN_COMMENT", ApplicationBundle.message((String)"wrapping.keep.comment.at.first.column", (Object[])new Object[0]), WRAPPING_KEEP);
            this.showStandardOptions(new String[]{"KEEP_LINE_BREAKS", "KEEP_FIRST_COLUMN_COMMENT"});
            this.showWrapOption("WRAP_INSIDE_CREATE_TABLE", "Create table");
            this.showWrapOption("WRAP_INSIDE_SELECT", "Select clause");
            this.showWrapOption("WRAP_INSIDE_JOIN_EXPRESSION", "From clause and join expression");
            this.showWrapOption("WRAP_INSIDE_GROUP_BY", "Group by clause");
            this.showWrapOption("WRAP_INSIDE_WHERE", "Where clause");
            this.showWrapOption("WRAP_INSIDE_ORDER_BY", "Order by clause");
            this.showWrapOption("WRAP_INSIDE_SET", "Set clause");
            this.showWrapOption("WRAP_INSIDE_BINARY_EXPRESSION", "Binary expression");
            this.showWrapOption("WRAP_INSIDE_ARGUMENT_DEFINITION", "Definition");
            this.showWrapOption("WRAP_INSIDE_CALL_EXPRESSION", "Call expression");
            this.showWrapOption("WRAP_INSIDE_VALUES_EXPRESSION", "Values expression");
            this.showWrapOption("WRAP_PARENTHESIZED_EXPRESSION_INSIDE_VALUES", "Groups inside values expression");
            this.showWrapOption("WRAP_VALUES_EXPRESSION", "Values expression", null);
        }

        protected void customizeSettings() {
        }
    }

    private class SqlIndentOptionsWrapper
    extends TabbedLanguageCodeStylePanel.MyIndentOptionsWrapper {
        protected SqlIndentOptionsWrapper(CodeStyleSettings settings, LanguageCodeStyleSettingsProvider provider, IndentOptionsEditor editor) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings, provider, editor);
        }

        protected PsiFile createFileFromText(Project project, String text) {
            return SqlCodeStyleMainPanel.createSqlFile(project, text);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }
    }

    private class SqlBlankLinesPanel
    extends TabbedLanguageCodeStylePanel.MyBlankLinesPanel {
        public SqlBlankLinesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        protected PsiFile createFileFromText(Project project, String text) {
            return SqlCodeStyleMainPanel.createSqlFile(project, text);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }
    }

    class SqlSpacesPanel
    extends TabbedLanguageCodeStylePanel.MySpacesPanel {
        public SqlSpacesPanel(CodeStyleSettings settings) {
            super((TabbedLanguageCodeStylePanel)SqlCodeStyleMainPanel.this, settings);
        }

        protected PsiFile createFileFromText(Project project, String text) {
            return SqlCodeStyleMainPanel.createSqlFile(project, text);
        }

        protected EditorHighlighter createHighlighter(EditorColorsScheme scheme) {
            return SqlCodeStyleMainPanel.createSqlHighlighter(scheme);
        }
    }
}

