/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model;

import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.openapi.util.UserDataHolderBase;
import org.gga.graph.maps.DataGraph;

public class DsmModelImpl<N>
extends UserDataHolderBase
implements DsmModel<N> {
    private final DataGraph<N, Integer> myGraph;
    private final DsmTreeStructure<N> myTreeStructure;
    private DsmModel.Colorer myColorer;
    private final Class<N> myNodeClass;

    public DsmModelImpl(DataGraph<N, Integer> graph, DsmTreeStructure<N> treeStructure, Class<N> nodeClass) {
        this.myGraph = graph;
        this.myTreeStructure = treeStructure;
        this.myNodeClass = nodeClass;
    }

    @Override
    public int getSize() {
        return this.myGraph.getIntGraph().V();
    }

    @Override
    public N getNode(int index) {
        return this.myGraph.getNode(index);
    }

    @Override
    public int getDependency(int from, int to) {
        Integer d = this.myGraph.edge(this.getNode(from), this.getNode(to));
        return d != null ? d : 0;
    }

    public void setColorer(DsmModel.Colorer colorer) {
        this.myColorer = colorer;
    }

    @Override
    public DsmModel.Colorer getColorer() {
        return this.myColorer;
    }

    @Override
    public DsmTreeStructure<N> getTreeStructure() {
        return this.myTreeStructure;
    }

    @Override
    public Class<N> getNodeClass() {
        return this.myNodeClass;
    }

    @Override
    public DataGraph<N, Integer> getGraph() {
        return this.myGraph;
    }
}

