/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.MaxWidthVisitor;
import com.intellij.dsm.ui.NodeVisitor;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Cache<N> {
    final List<DsmTreeStructure.TreeNode<N>> myRows;
    final Map<DsmTreeStructure.TreeNode<N>, Integer> rowIndices = new HashMap<DsmTreeStructure.TreeNode<N>, Integer>();
    final int maxRowHeaderWidth;
    final Map<DsmTreeStructure.TreeNode<N>, Rectangle> rowHeaderBounds = new HashMap<DsmTreeStructure.TreeNode<N>, Rectangle>();
    final int myBoxWidth;
    final int boxHeight;
    final Set<DsmTreeStructure.TreeNode<N>> overflowRows = new HashSet<DsmTreeStructure.TreeNode<N>>();
    final Map<DsmTreeStructure.TreeNode<N>, Point> rowTextStart = new HashMap<DsmTreeStructure.TreeNode<N>, Point>();
    private final DsmTableImpl<N> myDsmTable;
    final boolean isSmall;
    final boolean isSuperSmall;

    public Cache(DsmTableImpl<N> dsmTable) {
        this.myDsmTable = dsmTable;
        this.isSmall = dsmTable.myBoxSize < 8;
        this.isSuperSmall = dsmTable.myBoxSize < 3;
        MaxWidthVisitor mv = new MaxWidthVisitor(this.myDsmTable, this);
        this.myDsmTable.acceptNodes(mv);
        this.maxRowHeaderWidth = mv.myMaxWidth;
        this.myRows = mv.myRows;
        for (int i = 0; i < this.myRows.size(); ++i) {
            DsmTreeStructure.TreeNode<N> node = this.myRows.get(i);
            this.rowIndices.put(node, i);
        }
        final FontMetrics fontMetrics = this.myDsmTable.getFontMetrics(this.myDsmTable.getRowHeaderView().getFont());
        this.myDsmTable.acceptNodes(new NodeVisitor<N>(){

            @Override
            public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
                this.visitNode(node, x, y, height);
            }

            @Override
            public void visitExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isLast) {
                Rectangle r = new Rectangle(x, y, ((Cache)Cache.this).myDsmTable.myBoxSize, height);
                Cache.this.rowHeaderBounds.put(node, r);
                Point p = new Point(x + (((Cache)Cache.this).myDsmTable.myBoxSize - fontMetrics.getHeight()) / 2, y + ((Cache)Cache.this).myDsmTable.myBoxSize);
                Cache.this.rowTextStart.put(node, p);
                int stringWidth = fontMetrics.stringWidth(node.getShortName()) + ((Cache)Cache.this).myDsmTable.myBoxSize;
                if (stringWidth > height - p.y + y) {
                    Cache.this.overflowRows.add(node);
                }
            }

            @Override
            public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean last) {
                this.visitNode(node, x, y, height);
            }

            private void visitNode(DsmTreeStructure.TreeNode<N> node, int x, int y, int height) {
                Rectangle r = new Rectangle(x, y, Cache.this.maxRowHeaderWidth - x, height);
                Cache.this.rowHeaderBounds.put(node, r);
                int textX = x + ((Cache)Cache.this).myDsmTable.myBoxSize * 2;
                int textY = y + fontMetrics.getAscent() + (((Cache)Cache.this).myDsmTable.myBoxSize - fontMetrics.getHeight()) / 2;
                Cache.this.rowTextStart.put(node, new Point(textX, textY));
            }
        });
        this.myBoxWidth = this.myRows.size() * this.myDsmTable.myBoxSize + 1;
        this.boxHeight = this.myRows.size() * this.myDsmTable.myBoxSize + 1;
    }
}

