/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.cucumber.groovy;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.JavaModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.cucumber.BDDFrameworkType;
import org.jetbrains.plugins.cucumber.StepDefinitionCreator;
import org.jetbrains.plugins.cucumber.groovy.GrCucumberUtil;
import org.jetbrains.plugins.cucumber.groovy.steps.GrStepDefinition;
import org.jetbrains.plugins.cucumber.groovy.steps.GrStepDefinitionCreator;
import org.jetbrains.plugins.cucumber.psi.GherkinFile;
import org.jetbrains.plugins.cucumber.steps.AbstractStepDefinition;
import org.jetbrains.plugins.cucumber.steps.NotIndexedCucumberExtension;
import org.jetbrains.plugins.groovy.GroovyFileType;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;

public class GrCucumberExtension
extends NotIndexedCucumberExtension {
    public boolean isStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "isStepLikeFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "isStepLikeFile"));
        }
        return child instanceof GroovyFile && ((GroovyFile)child).getName().endsWith(".groovy");
    }

    public boolean isWritableStepLikeFile(@NotNull PsiElement child, @NotNull PsiElement parent) {
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "isWritableStepLikeFile"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "isWritableStepLikeFile"));
        }
        return this.isStepLikeFile(child, parent);
    }

    @NotNull
    public BDDFrameworkType getStepFileType() {
        BDDFrameworkType bDDFrameworkType = new BDDFrameworkType((FileType)GroovyFileType.GROOVY_FILE_TYPE);
        if (bDDFrameworkType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "getStepFileType"));
        }
        return bDDFrameworkType;
    }

    @NotNull
    public StepDefinitionCreator getStepDefinitionCreator() {
        GrStepDefinitionCreator grStepDefinitionCreator = new GrStepDefinitionCreator();
        if (grStepDefinitionCreator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "getStepDefinitionCreator"));
        }
        return grStepDefinitionCreator;
    }

    @Nullable
    private String getGlue(PsiElement stepDefinition) {
        GroovyFile groovyFile;
        VirtualFile vfile;
        if (stepDefinition != null && stepDefinition instanceof GrMethodCall && (vfile = (groovyFile = (GroovyFile)stepDefinition.getContainingFile()).getVirtualFile()) != null) {
            VirtualFile parentDir = vfile.getParent();
            return PathUtil.getLocalPath((VirtualFile)parentDir);
        }
        return null;
    }

    @NotNull
    public Collection<String> getGlues(@NotNull GherkinFile file, Set<String> gluesFromOtherFiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "getGlues"));
        }
        if (gluesFromOtherFiles == null) {
            gluesFromOtherFiles = ContainerUtil.newHashSet();
        }
        HashSet glues = gluesFromOtherFiles;
        for (AbstractStepDefinition stepDefinition : this.getAllStepDefinitions(file.getProject())) {
            PsiElement stepDefinitionElement = stepDefinition.getElement();
            String glue = this.getGlue(stepDefinitionElement);
            if (glue == null) continue;
            glues.add(glue);
        }
        HashSet hashSet = glues;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "getGlues"));
        }
        return hashSet;
    }

    protected void loadStepDefinitionRootsFromLibraries(Module module, List<PsiDirectory> roots, Set<String> directories) {
    }

    @NotNull
    public List<AbstractStepDefinition> getStepDefinitions(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "getStepDefinitions"));
        }
        ArrayList<AbstractStepDefinition> newDefs = new ArrayList<AbstractStepDefinition>();
        if (psiFile instanceof GroovyFile) {
            GrStatement[] statements;
            for (GrStatement statement : statements = ((GroovyFile)psiFile).getStatements()) {
                if (!GrCucumberUtil.isStepDefinition((PsiElement)statement)) continue;
                newDefs.add(GrStepDefinition.getStepDefinition((GrMethodCall)statement));
            }
        }
        ArrayList<AbstractStepDefinition> arrayList = newDefs;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "getStepDefinitions"));
        }
        return arrayList;
    }

    protected void collectAllStepDefsProviders(@NotNull List<VirtualFile> providers, @NotNull Project project) {
        Module[] modules;
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "providers", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "collectAllStepDefsProviders"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "collectAllStepDefsProviders"));
        }
        for (Module module : modules = ModuleManager.getInstance((Project)project).getModules()) {
            if (!(ModuleType.get((Module)module) instanceof JavaModuleType)) continue;
            Object[] roots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            ContainerUtil.addAll(providers, (Object[])roots);
        }
    }

    public void findRelatedStepDefsRoots(@NotNull Module module, @NotNull PsiFile featureFile, List<PsiDirectory> newStepDefinitionsRoots, Set<String> processedStepDirectories) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "findRelatedStepDefsRoots"));
        }
        if (featureFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "featureFile", "org/jetbrains/plugins/cucumber/groovy/GrCucumberExtension", "findRelatedStepDefsRoots"));
        }
        for (VirtualFile sfDirectory : ModuleRootManager.getInstance((Module)module).getSourceRoots()) {
            PsiDirectory sourceRoot;
            if (!sfDirectory.isDirectory() || processedStepDirectories.contains((sourceRoot = PsiDirectoryFactory.getInstance((Project)module.getProject()).createDirectory(sfDirectory)).getVirtualFile().getPath())) continue;
            newStepDefinitionsRoots.add(sourceRoot);
        }
    }
}

