/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.stylus.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.css.impl.util.CssUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.util.ProcessingContext;
import com.intellij.util.Processor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.stylus.StylusUtil;
import org.jetbrains.plugins.stylus.psi.StylusVariableDeclaration;
import org.jetbrains.plugins.stylus.psi.stubs.StylusVariableIndex;

public class StylusVariableCompletionProvider
extends CompletionProvider<CompletionParameters> {
    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "org/jetbrains/plugins/stylus/completion/StylusVariableCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/stylus/completion/StylusVariableCompletionProvider", "addCompletions"));
        }
        PsiElement position = parameters.getPosition();
        Project project = position.getProject();
        GlobalSearchScope scope = CssUtil.getCompletionAndResolvingScopeForElement((PsiElement)position);
        for (String name : StubIndex.getInstance().getAllKeys(StylusVariableIndex.KEY, project)) {
            StylusVariableIndex.process(name, project, scope, (Processor<? super StylusVariableDeclaration>)((Processor)declaration -> {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/plugins/stylus/completion/StylusVariableCompletionProvider", "lambda$addCompletions$0"));
                }
                result.addElement(StylusUtil.createVariableLookupItem(declaration, true));
                return true;
            }));
        }
    }
}

