/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.klint.checks;

import com.android.annotations.NonNull;
import com.android.annotations.Nullable;
import com.android.tools.klint.checks.CutPasteDetector;
import com.android.tools.klint.client.api.JavaEvaluator;
import com.android.tools.klint.detector.api.Category;
import com.android.tools.klint.detector.api.Detector;
import com.android.tools.klint.detector.api.Implementation;
import com.android.tools.klint.detector.api.Issue;
import com.android.tools.klint.detector.api.JavaContext;
import com.android.tools.klint.detector.api.Scope;
import com.android.tools.klint.detector.api.Severity;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.uast.UAnonymousClass;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.UVariable;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.expressions.UReferenceExpression;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;

public class RecyclerViewDetector
extends Detector
implements Detector.UastScanner {
    public static final Implementation IMPLEMENTATION = new Implementation(RecyclerViewDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue FIXED_POSITION = Issue.create("RecyclerView", "RecyclerView Problems", "`RecyclerView` will *not* call `onBindViewHolder` again when the position of the item changes in the data set unless the item itself is invalidated or the new position cannot be determined.\n\nFor this reason, you should *only* use the position parameter while acquiring the related data item inside this method, and should *not* keep a copy of it.\n\nIf you need the position of an item later on (e.g. in a click listener), use `getAdapterPosition()` which will have the updated adapter position.", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);
    public static final Issue DATA_BINDER = Issue.create("PendingBindings", "Missing Pending Bindings", "When using a `ViewDataBinding` in a `onBindViewHolder` method, you *must* call `executePendingBindings()` before the method exits; otherwise the data binding runtime will update the UI in the next animation frame causing a delayed update and potential jumps if the item resizes.", Category.CORRECTNESS, 8, Severity.ERROR, IMPLEMENTATION);
    private static final String VIEW_ADAPTER = "android.support.v7.widget.RecyclerView.Adapter";
    private static final String ON_BIND_VIEW_HOLDER = "onBindViewHolder";

    @Override
    @Nullable
    public List<String> applicableSuperClasses() {
        return Collections.singletonList(VIEW_ADAPTER);
    }

    @Override
    public void checkClass(@NonNull JavaContext context, @NonNull UClass declaration2) {
        JavaEvaluator evaluator = context.getEvaluator();
        for (PsiMethod method : declaration2.findMethodsByName(ON_BIND_VIEW_HOLDER, false)) {
            int size = evaluator.getParameterCount(method);
            if (size != 2 && size != 3) continue;
            RecyclerViewDetector.checkMethod(context, method, declaration2);
        }
        super.checkClass(context, declaration2);
    }

    private static void checkMethod(@NonNull JavaContext context, @NonNull PsiMethod declaration2, @NonNull PsiClass cls) {
        PsiParameter[] parameters2 = declaration2.getParameterList().getParameters();
        PsiParameter viewHolder = parameters2[0];
        PsiParameter parameter = parameters2[1];
        ParameterEscapesVisitor visitor = new ParameterEscapesVisitor(context, cls, parameter);
        UMethod method = context.getUastContext().getMethod(declaration2);
        method.accept(visitor);
        if (visitor.variableEscapes()) {
            RecyclerViewDetector.reportError(context, viewHolder, parameter);
        }
        List dataBinderReferences = visitor.getDataBinders();
        RecyclerViewDetector.checkDataBinders(context, method, dataBinderReferences);
    }

    private static void reportError(@NonNull JavaContext context, PsiParameter viewHolder, PsiParameter parameter) {
        String variablePrefix = viewHolder.getName();
        if (variablePrefix == null) {
            variablePrefix = "ViewHolder";
        }
        String message2 = String.format("Do not treat position as fixed; only use immediately and call `%1$s.getAdapterPosition()` to look it up later", variablePrefix);
        context.report(FIXED_POSITION, (PsiElement)parameter, context.getLocation((PsiElement)parameter), message2);
    }

    private static void checkDataBinders(@NonNull JavaContext context, @NonNull UMethod declaration2, List<UCallExpression> references) {
        if (references != null && !references.isEmpty()) {
            ArrayList targets = Lists.newArrayList();
            ArrayList sources = Lists.newArrayList();
            for (UCallExpression ref : references) {
                if (RecyclerViewDetector.isExecutePendingBindingsCall(ref)) {
                    targets.add(ref);
                    continue;
                }
                sources.add(ref);
            }
            HashMap parentToChildren = Maps.newHashMap();
            for (UCallExpression reference : sources) {
                UExpression statement = (UExpression)UastUtils.getParentOfType(reference, UExpression.class, true);
                if (statement == null) continue;
                parentToChildren.put(statement.getContainingElement(), reference);
            }
            for (UCallExpression source : parentToChildren.values()) {
                UExpression sourceBinderReference = source.getReceiver();
                PsiField sourceDataBinder = RecyclerViewDetector.getDataBinderReference(sourceBinderReference);
                assert (sourceDataBinder != null);
                boolean reachesTarget = false;
                for (UCallExpression target : targets) {
                    if (!sourceDataBinder.equals(RecyclerViewDetector.getDataBinderReference(target.getReceiver())) || !CutPasteDetector.isReachableFrom(declaration2, source, target)) continue;
                    reachesTarget = true;
                    break;
                }
                if (reachesTarget) continue;
                String message2 = String.format("You must call `%1$s.executePendingBindings()` before the `onBind` method exits, otherwise, the DataBinding library will update the UI in the next animation frame causing a delayed update & potential jumps if the item resizes.", sourceBinderReference.asSourceString());
                context.report(DATA_BINDER, source, context.getUastLocation(source), message2);
            }
        }
    }

    private static boolean isExecutePendingBindingsCall(UCallExpression call) {
        return "executePendingBindings".equals(call.getMethodName());
    }

    @Nullable
    private static PsiField getDataBinderReference(@Nullable UExpression element) {
        PsiField field;
        PsiElement resolved;
        if (element instanceof UReferenceExpression && (resolved = ((UReferenceExpression)element).resolve()) instanceof PsiField && "dataBinder".equals((field = (PsiField)resolved).getName())) {
            return field;
        }
        return null;
    }

    private static class ParameterEscapesVisitor
    extends AbstractUastVisitor {
        protected final JavaContext mContext;
        private final List<PsiVariable> mVariables;
        private final PsiClass mBindClass;
        private boolean mEscapes;
        private boolean mFoundInnerClass;
        private List<UCallExpression> mDataBinders = null;

        private ParameterEscapesVisitor(JavaContext context, @NonNull PsiClass bindClass, @NonNull PsiParameter variable2) {
            this.mContext = context;
            this.mVariables = Lists.newArrayList((Object[])new PsiVariable[]{variable2});
            this.mBindClass = bindClass;
        }

        private boolean variableEscapes() {
            return this.mEscapes;
        }

        @Override
        public boolean visitVariable(UVariable variable2) {
            PsiElement resolved;
            UExpression initializer = variable2.getUastInitializer();
            if (initializer instanceof UReferenceExpression && (resolved = ((UReferenceExpression)initializer).resolve()) != null && this.mVariables.contains(resolved)) {
                if (resolved instanceof PsiLocalVariable) {
                    this.mVariables.add(variable2);
                } else if (resolved instanceof PsiField) {
                    this.mEscapes = true;
                }
            }
            return super.visitVariable(variable2);
        }

        @Override
        public boolean visitBinaryExpression(UBinaryExpression node) {
            if (node.getOperator() instanceof UastBinaryOperator.AssignOperator) {
                PsiElement resolved;
                UExpression rhs = node.getRightOperand();
                boolean clearLhs = true;
                if (rhs instanceof UReferenceExpression && (resolved = ((UReferenceExpression)rhs).resolve()) != null && this.mVariables.contains(resolved)) {
                    clearLhs = false;
                    PsiElement resolvedLhs = UastUtils.tryResolve(node.getLeftOperand());
                    if (resolvedLhs instanceof PsiLocalVariable) {
                        PsiLocalVariable variable2 = (PsiLocalVariable)resolvedLhs;
                        this.mVariables.add((PsiVariable)variable2);
                    } else if (resolvedLhs instanceof PsiField) {
                        this.mEscapes = true;
                    }
                }
                if (clearLhs && (resolved = UastUtils.tryResolve(node.getLeftOperand())) != null && this.mVariables.contains(resolved)) {
                    this.mVariables.remove(resolved);
                }
            }
            return super.visitBinaryExpression(node);
        }

        @Override
        public boolean visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
            PsiClass outer;
            PsiElement resolved;
            if (this.mFoundInnerClass && (resolved = node.resolve()) != null && this.mVariables.contains(resolved) && !this.mBindClass.equals(outer = (PsiClass)UastUtils.getParentOfType(node, UClass.class, true))) {
                this.mEscapes = true;
            }
            return super.visitSimpleNameReferenceExpression(node);
        }

        @Override
        public boolean visitClass(UClass node) {
            if (node instanceof UAnonymousClass || !node.isStatic()) {
                this.mFoundInnerClass = true;
            }
            return super.visitClass(node);
        }

        @Nullable
        private List<UCallExpression> getDataBinders() {
            return this.mDataBinders;
        }

        @Override
        public boolean visitCallExpression(UCallExpression expression2) {
            UExpression methodExpression;
            PsiField dataBinder;
            if (UastExpressionUtils.isMethodCall(expression2) && (dataBinder = RecyclerViewDetector.getDataBinderReference(methodExpression = expression2.getReceiver())) != null) {
                if (this.mDataBinders == null) {
                    this.mDataBinders = Lists.newArrayList();
                }
                this.mDataBinders.add(expression2);
            }
            return super.visitCallExpression(expression2);
        }
    }
}

