/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.annotation;

import com.google.common.collect.Sets;
import com.intellij.openapi.util.Condition;
import com.intellij.util.Function;
import com.intellij.util.containers.JBIterable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class AnnotationCoordinator<T extends Annotation> {
    @NotNull
    private final Class<T> annotationClass;
    private Map<Set<Class<?>>, T> cache;

    public AnnotationCoordinator(@NotNull Class<T> annotationClass) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/jboss/jbpm/annotation/AnnotationCoordinator", "<init>"));
        }
        this.cache = new HashMap();
        this.annotationClass = annotationClass;
    }

    public AnnotationCoordinator(@NotNull Class<T> annotationClass, @NotNull T defaultValue) {
        if (annotationClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationClass", "com/intellij/jboss/jbpm/annotation/AnnotationCoordinator", "<init>"));
        }
        if (defaultValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultValue", "com/intellij/jboss/jbpm/annotation/AnnotationCoordinator", "<init>"));
        }
        this.cache = new HashMap();
        this.annotationClass = annotationClass;
    }

    public T getAnnotation(Iterable<Class<?>> classes) {
        HashSet set = Sets.newHashSet(classes);
        if (this.cache.containsKey(set)) {
            return (T)((Annotation)this.cache.get(set));
        }
        T result = this.getAnnotationImpl(classes);
        this.cache.put(set, result);
        return result;
    }

    private T getAnnotationImpl(Iterable<Class<?>> classes) {
        List annotations = JBIterable.from(classes).transform(new Function<Class<?>, T>(){

            public T fun(Class<?> aClass) {
                return AnnotationCoordinator.this.getAnnotationImpl(aClass);
            }
        }).filter(new Condition<T>(){

            public boolean value(T t) {
                return t != null;
            }
        }).toList();
        if (annotations.size() == 0) {
            return null;
        }
        Annotation result = (Annotation)annotations.get(0);
        for (Annotation annotation : JBIterable.from((Iterable)annotations).skip(1)) {
            assert (annotation.equals(result)) : "Found multiple annotations with type " + this.annotationClass.getName() + " and different values; you should annotate child class too to avoid this warning";
        }
        return (T)result;
    }

    public T getAnnotation(Class<?> clazz) {
        HashSet set = Sets.newHashSet((Object[])new Class[]{clazz});
        if (this.cache.containsKey(set)) {
            return (T)((Annotation)this.cache.get(set));
        }
        T result = this.getAnnotationImpl(clazz);
        this.cache.put(set, result);
        return result;
    }

    private T getAnnotationImpl(Class<?> clazz) {
        T annotation = clazz.getAnnotation(this.annotationClass);
        if (annotation != null) {
            return annotation;
        }
        return this.getAnnotationImpl((Iterable<Class<?>>)JBIterable.of(clazz.getSuperclass()).append((Object[])clazz.getInterfaces()).filter(new Condition<Class<?>>(){

            public boolean value(Class<?> aClass) {
                return aClass != null;
            }
        }));
    }
}

