/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jboss.jbpm.render.pictures;

import com.intellij.jboss.jbpm.providers.IconProvider;
import com.intellij.jboss.jbpm.providers.ProvidersCoordinator;
import com.intellij.jboss.jbpm.render.ChartNodeMainPanel;
import com.intellij.jboss.jbpm.render.ChartNodeRenderer;
import com.intellij.jboss.jbpm.render.RenderArgs;
import com.intellij.jboss.jbpm.render.pictures.RenderIcon;
import java.awt.Graphics;
import javax.swing.Icon;

public class ChartNodeIconRenderer<T>
implements ChartNodeRenderer<T, RenderIcon> {
    @Override
    public void renderComponent(final RenderIcon renderIcon, RenderArgs<T> renderArgs) {
        IconProvider iconProvider = ProvidersCoordinator.getInstance().getProvider(renderIcon.iconProvider());
        final Icon icon = iconProvider.getImage(renderArgs.chartNode, renderIcon);
        renderArgs.panel.addPainter(new ChartNodeMainPanel.Painter(){

            @Override
            public void paintComponent(ChartNodeMainPanel panel, Graphics graphics) {
                icon.paintIcon(panel, graphics, ChartNodeIconRenderer.getPosition(panel.getWidth(), icon.getIconWidth(), renderIcon.horizontalAlignment().ordinal()), ChartNodeIconRenderer.getPosition(panel.getHeight(), icon.getIconHeight(), renderIcon.verticalAlignment().ordinal()));
            }
        });
    }

    private static int getPosition(int frameSize, int iconSize, int alignmentOrdinal) {
        return (frameSize - iconSize) * alignmentOrdinal / 2;
    }

    @Override
    public Class<RenderIcon> getLayoutClass() {
        return RenderIcon.class;
    }
}

