/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.css.CssAtRule;
import com.intellij.psi.css.CssBlock;
import com.intellij.psi.css.CssCharset;
import com.intellij.psi.css.CssCustomMixin;
import com.intellij.psi.css.CssDeclaration;
import com.intellij.psi.css.CssElement;
import com.intellij.psi.css.CssFile;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssImport;
import com.intellij.psi.css.CssImportList;
import com.intellij.psi.css.CssMediaExpression;
import com.intellij.psi.css.CssMediaFeature;
import com.intellij.psi.css.CssNamespace;
import com.intellij.psi.css.CssNamespaceList;
import com.intellij.psi.css.CssOperation;
import com.intellij.psi.css.CssParenthesisedExpression;
import com.intellij.psi.css.CssPseudoSelector;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssRulesetList;
import com.intellij.psi.css.CssSelector;
import com.intellij.psi.css.CssSelectorList;
import com.intellij.psi.css.CssSimpleSelector;
import com.intellij.psi.css.CssString;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.CssTermList;
import com.intellij.psi.css.CssUri;
import com.intellij.psi.css.StylesheetFile;
import org.jetbrains.annotations.NotNull;

public class CssElementVisitor
extends PsiElementVisitor {
    public void visitCssBlock(CssBlock block) {
        this.visitCssElement(block);
    }

    public void visitCssElement(CssElement element) {
        this.visitElement(element);
    }

    public void visitStylesheetFile(StylesheetFile file) {
        if (file instanceof CssFile) {
            this.visitCssFile((CssFile)file);
        } else {
            this.visitFile(file);
        }
    }

    public void visitCssFile(CssFile file) {
        this.visitFile(file);
    }

    public void visitCssRuleset(CssRuleset ruleset) {
        this.visitCssElement(ruleset);
    }

    public void visitCssDeclaration(CssDeclaration declaration) {
        this.visitCssElement(declaration);
    }

    public void visitCssStylesheet(CssStylesheet stylesheet) {
        this.visitCssElement(stylesheet);
    }

    public void visitCssSelector(CssSelector selector) {
        this.visitCssElement(selector);
    }

    public void visitCssSimpleSelector(CssSimpleSelector selector) {
        this.visitCssElement(selector);
    }

    public void visitCssSelectorList(CssSelectorList selectorList) {
        this.visitCssElement(selectorList);
    }

    public void visitCssRulesetList(CssRulesetList rulesetList) {
        this.visitCssElement(rulesetList);
    }

    public void visitCssImport(CssImport _import) {
        this.visitCssElement(_import);
    }

    public void visitCssString(CssString _string) {
        this.visitCssElement(_string);
    }

    public void visitCssTerm(CssTerm _term) {
        this.visitCssElement(_term);
    }

    public void visitCssFunction(CssFunction _function) {
        this.visitCssElement(_function);
    }

    public void visitCssCharset(CssCharset charset) {
        this.visitCssElement(charset);
    }

    public void visitCssTermList(CssTermList cssTermList) {
        this.visitCssElement(cssTermList);
    }

    public void visitCssUri(CssUri uri) {
        this.visitCssElement(uri);
    }

    public void visitAtRule(CssAtRule atRule) {
        this.visitCssElement(atRule);
    }

    public void visitPseudoSelector(CssPseudoSelector pseudoSelector) {
        this.visitCssElement(pseudoSelector);
    }

    public void visitCssImportList(CssImportList importList) {
        this.visitCssElement(importList);
    }

    public void visitNamespaceList(CssNamespaceList namespaceList) {
        this.visitCssElement(namespaceList);
    }

    public void visitNamespace(CssNamespace namespace) {
        this.visitCssElement(namespace);
    }

    public void visitCssOperation(@NotNull CssOperation operation) {
        if (operation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operation", "com/intellij/psi/css/CssElementVisitor", "visitCssOperation"));
        }
        this.visitCssElement(operation);
    }

    public void visitMediaExpression(@NotNull CssMediaExpression mediaExpression) {
        if (mediaExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaExpression", "com/intellij/psi/css/CssElementVisitor", "visitMediaExpression"));
        }
        this.visitCssElement(mediaExpression);
    }

    public void visitMediaFeature(@NotNull CssMediaFeature mediaFeature) {
        if (mediaFeature == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mediaFeature", "com/intellij/psi/css/CssElementVisitor", "visitMediaFeature"));
        }
        this.visitCssElement(mediaFeature);
    }

    public void visitParenthesisedExpression(@NotNull CssParenthesisedExpression parenthesisedExpression) {
        if (parenthesisedExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parenthesisedExpression", "com/intellij/psi/css/CssElementVisitor", "visitParenthesisedExpression"));
        }
        this.visitCssElement(parenthesisedExpression);
    }

    public void visitCustomMixin(@NotNull CssCustomMixin customMixin) {
        if (customMixin == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customMixin", "com/intellij/psi/css/CssElementVisitor", "visitCustomMixin"));
        }
        this.visitCssElement(customMixin);
    }
}

