/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.GradleResolvedVariable;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrListOrMap;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCommandArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameterList;

public abstract class GradleDslElement {
    @NotNull
    protected final String myName;
    @Nullable
    protected GradleDslElement myParent;
    @NotNull
    private final String myQualifiedName;
    @NotNull
    private final GradleDslFile myDslFile;
    @Nullable
    private GroovyPsiElement myPsiElement;
    private volatile boolean myModified;

    protected GradleDslElement(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElement", "<init>"));
        }
        assert (parent != null || this instanceof GradleDslFile);
        this.myParent = parent;
        this.myPsiElement = psiElement;
        this.myName = name;
        this.myQualifiedName = parent == null || parent instanceof GradleDslFile ? name : parent.myQualifiedName + "." + name;
        this.myDslFile = parent == null ? (GradleDslFile)this : parent.myDslFile;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElement", "getName"));
        }
        return string;
    }

    @Nullable
    public GradleDslElement getParent() {
        return this.myParent;
    }

    @Nullable
    public GroovyPsiElement getPsiElement() {
        return this.myPsiElement;
    }

    public void setPsiElement(@Nullable GroovyPsiElement psiElement) {
        this.myPsiElement = psiElement;
    }

    @NotNull
    public String getQualifiedName() {
        String string = this.myQualifiedName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElement", "getQualifiedName"));
        }
        return string;
    }

    @NotNull
    public GradleDslFile getDslFile() {
        GradleDslFile gradleDslFile = this.myDslFile;
        if (gradleDslFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElement", "getDslFile"));
        }
        return gradleDslFile;
    }

    @NotNull
    public List<GradleResolvedVariable> getResolvedVariables() {
        ImmutableList.Builder resultBuilder = ImmutableList.builder();
        for (GradleDslElement child : this.getChildren()) {
            resultBuilder.addAll(child.getResolvedVariables());
        }
        ImmutableList immutableList = resultBuilder.build();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradleDslElement", "getResolvedVariables"));
        }
        return immutableList;
    }

    @Nullable
    public GroovyPsiElement create() {
        PsiElement addedElement;
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement != null) {
            return psiElement;
        }
        if (this.myParent == null) {
            return null;
        }
        GroovyPsiElement parentPsiElement = this.myParent.create();
        if (parentPsiElement == null) {
            return null;
        }
        Project project = parentPsiElement.getProject();
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance((Project)project);
        if (this.isNewEmptyBlockElement()) {
            return null;
        }
        String statementText = this.myName + (this.isBlockElement() ? " {\n}\n" : " \"abc\", \"xyz\"");
        GrStatement statement = factory.createStatementFromText((CharSequence)statementText);
        if (statement instanceof GrApplicationStatement) {
            ((GrApplicationStatement)statement).getArgumentList().delete();
        }
        PsiElement lineTerminator = factory.createLineTerminator(1);
        if (parentPsiElement instanceof GroovyFile) {
            addedElement = parentPsiElement.addAfter((PsiElement)statement, parentPsiElement.getLastChild());
            parentPsiElement.addBefore(lineTerminator, addedElement);
        } else {
            addedElement = parentPsiElement.addBefore((PsiElement)statement, parentPsiElement.getLastChild());
            parentPsiElement.addAfter(lineTerminator, addedElement);
        }
        if (this.isBlockElement()) {
            GrClosableBlock closableBlock = GradleDslElement.getClosableBlock(addedElement);
            if (closableBlock != null) {
                this.setPsiElement((GroovyPsiElement)closableBlock);
            }
        } else if (addedElement instanceof GrApplicationStatement) {
            this.setPsiElement((GroovyPsiElement)((GrApplicationStatement)addedElement));
        }
        return this.getPsiElement();
    }

    private boolean isNewEmptyBlockElement() {
        if (this.getPsiElement() != null) {
            return false;
        }
        if (!this.isBlockElement()) {
            return false;
        }
        Collection<GradleDslElement> children = this.getChildren();
        if (children.isEmpty()) {
            return true;
        }
        for (GradleDslElement child : children) {
            if (child.isNewEmptyBlockElement()) continue;
            return false;
        }
        return true;
    }

    protected void delete() {
        for (GradleDslElement element : this.getChildren()) {
            element.delete();
        }
        GroovyPsiElement psiElement = this.getPsiElement();
        if (psiElement == null || !psiElement.isValid()) {
            return;
        }
        PsiElement parent = psiElement.getParent();
        psiElement.delete();
        if (parent != null) {
            GradleDslElement.deleteIfEmpty(parent);
        }
        this.setPsiElement(null);
    }

    protected void setModified(boolean modified) {
        this.myModified = modified;
        if (this.myParent != null && modified) {
            this.myParent.setModified(true);
        }
    }

    public boolean isModified() {
        return this.myModified;
    }

    protected boolean isBlockElement() {
        return false;
    }

    @NotNull
    protected abstract Collection<GradleDslElement> getChildren();

    public final void applyChanges() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        this.apply();
        this.setModified(false);
    }

    protected abstract void apply();

    public final void resetState() {
        this.reset();
        this.setModified(false);
    }

    protected abstract void reset();

    @Nullable
    private static GrClosableBlock getClosableBlock(PsiElement element) {
        if (!(element instanceof GrMethodCallExpression)) {
            return null;
        }
        GrClosableBlock[] closureArguments = ((GrMethodCallExpression)element).getClosureArguments();
        if (closureArguments.length > 0) {
            return closureArguments[0];
        }
        return null;
    }

    protected static void deleteIfEmpty(@Nullable PsiElement element) {
        GrListOrMap listOrMap;
        if (element == null || !element.isValid()) {
            return;
        }
        PsiElement parent = element.getParent();
        if (element instanceof GrAssignmentExpression) {
            if (((GrAssignmentExpression)element).getRValue() == null) {
                element.delete();
            }
        } else if (element instanceof GrApplicationStatement) {
            if (((GrApplicationStatement)element).getArgumentList() == null) {
                element.delete();
            }
        } else if (element instanceof GrClosableBlock) {
            final Boolean[] isEmpty = new Boolean[]{true};
            ((GrClosableBlock)element).acceptChildren(new GroovyElementVisitor(){

                public void visitElement(GroovyPsiElement child) {
                    if (child instanceof GrParameterList && ((GrParameterList)child).getParameters().length == 0) {
                        return;
                    }
                    isEmpty[0] = false;
                }
            });
            if (isEmpty[0].booleanValue()) {
                element.delete();
            }
        } else if (element instanceof GrMethodCallExpression) {
            GrMethodCallExpression call = (GrMethodCallExpression)element;
            GrArgumentList argumentList = call.getArgumentList();
            GrClosableBlock[] closureArguments = call.getClosureArguments();
            if ((argumentList == null || argumentList.getAllArguments().length == 0) && closureArguments.length == 0) {
                element.delete();
            }
        } else if (element instanceof GrCommandArgumentList) {
            GrCommandArgumentList commandArgumentList = (GrCommandArgumentList)element;
            if (commandArgumentList.getAllArguments().length == 0) {
                commandArgumentList.delete();
            }
        } else if (element instanceof GrListOrMap && ((listOrMap = (GrListOrMap)element).isMap() && listOrMap.getNamedArguments().length == 0 || !listOrMap.isMap() && listOrMap.getInitializers().length == 0)) {
            listOrMap.delete();
        }
        if (!element.isValid()) {
            GradleDslElement.deleteIfEmpty(parent);
        }
    }
}

