/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.messages;

import com.android.builder.model.SyncIssue;
import com.android.ide.common.blame.Message;
import com.android.ide.common.blame.SourceFile;
import com.android.ide.common.blame.SourceFilePosition;
import com.android.ide.common.blame.SourcePosition;
import com.android.ide.common.blame.parser.PatternAwareOutputParser;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.GradleModel;
import com.android.tools.idea.gradle.customizer.dependency.DependencySetupErrors;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.messages.Message;
import com.android.tools.idea.gradle.output.parser.BuildOutputParser;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.project.compatibility.VersionCompatibilityService;
import com.android.tools.idea.gradle.project.subset.ProjectSubset;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.errors.UnsupportedGradleVersionErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixAndroidGradlePluginVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.structure.editors.AndroidProjectSettingsService;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.startup.AndroidStudioInitializer;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationManager;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.plugins.gradle.settings.GradleSettings;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyLexer;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class ProjectSyncMessages {
    private static final NotificationSource NOTIFICATION_SOURCE = NotificationSource.PROJECT_SYNC;
    @NotNull
    private final Project myProject;
    @NotNull
    private final ExternalSystemNotificationManager myNotificationManager;

    @NotNull
    public static ProjectSyncMessages getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getInstance"));
        }
        ProjectSyncMessages projectSyncMessages = (ProjectSyncMessages)ServiceManager.getService((Project)project, ProjectSyncMessages.class);
        if (projectSyncMessages == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getInstance"));
        }
        return projectSyncMessages;
    }

    public int getErrorCount() {
        return this.myNotificationManager.getMessageCount(null, NOTIFICATION_SOURCE, NotificationCategory.ERROR, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public ProjectSyncMessages(@NotNull Project project, @NotNull ExternalSystemNotificationManager manager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "<init>"));
        }
        this.myProject = project;
        this.myNotificationManager = manager;
    }

    public int getMessageCount(@NotNull String groupName) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getMessageCount"));
        }
        return this.myNotificationManager.getMessageCount(groupName, NOTIFICATION_SOURCE, null, GradleUtil.GRADLE_SYSTEM_ID);
    }

    public boolean isEmpty() {
        return this.myNotificationManager.getMessageCount(NOTIFICATION_SOURCE, null, GradleUtil.GRADLE_SYSTEM_ID) == 0;
    }

    public void reportComponentIncompatibilities() {
        VersionCompatibilityService compatibilityService = VersionCompatibilityService.getInstance();
        List<VersionCompatibilityService.VersionIncompatibilityMessage> messages = compatibilityService.checkComponentCompatibility(this.myProject);
        for (VersionCompatibilityService.VersionIncompatibilityMessage message : messages) {
            this.add(message.getMessage(), message.getQuickFixes());
        }
        if (!messages.isEmpty()) {
            Projects.setHasSyncErrors(this.myProject, true);
        }
    }

    public void reportSyncIssues(@NotNull Collection<SyncIssue> syncIssues, @NotNull Module module) {
        if (syncIssues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssues", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportSyncIssues"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportSyncIssues"));
        }
        if (syncIssues.isEmpty() || Projects.getSkipSyncIssueReporting(module.getProject())) {
            return;
        }
        boolean hasSyncErrors = false;
        VirtualFile buildFile = ProjectSyncMessages.getBuildFile(module);
        block5: for (SyncIssue syncIssue : syncIssues) {
            if (syncIssue.getSeverity() == 2) {
                hasSyncErrors = true;
            }
            switch (syncIssue.getType()) {
                case 2: {
                    this.reportUnresolvedDependency((String)Verify.verifyNotNull((Object)syncIssue.getData()), module, buildFile);
                    continue block5;
                }
                case 17: {
                    this.reportExternalNativeBuildIssues(syncIssue, module.getProject());
                    continue block5;
                }
                case 12: {
                    this.reportOldGradleVersion(syncIssue);
                    continue block5;
                }
            }
            String group = "Gradle Sync Issue";
            String text = syncIssue.getMessage();
            Message.Type severity = ProjectSyncMessages.getSeverityType(syncIssue);
            Message msg = buildFile != null ? new Message(module.getProject(), group, severity, buildFile, -1, -1, text) : new Message(group, severity, NonNavigatable.INSTANCE, text);
            this.add(msg, ProjectSyncMessages.getHyperlinks(this.myProject, text));
        }
        if (hasSyncErrors) {
            Projects.setHasSyncErrors(this.myProject, true);
        }
    }

    private void reportOldGradleVersion(@NotNull SyncIssue syncIssue) {
        if (syncIssue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssue", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportOldGradleVersion"));
        }
        String group = "Gradle Sync Issue";
        String text = syncIssue.getMessage();
        Message.Type severity = ProjectSyncMessages.getSeverityType(syncIssue);
        String gradleVersion = syncIssue.getData();
        this.add(new Message(group, severity, NonNavigatable.INSTANCE, text), UnsupportedGradleVersionErrorHandler.getQuickFixHyperlinks(this.myProject, gradleVersion));
    }

    @NotNull
    private static Message.Type getSeverityType(@NotNull SyncIssue syncIssue) {
        if (syncIssue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssue", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getSeverityType"));
        }
        Message.Type type = syncIssue.getSeverity() == 2 ? Message.Type.ERROR : Message.Type.WARNING;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getSeverityType"));
        }
        return type;
    }

    @NotNull
    private static List<NotificationHyperlink> getHyperlinks(@NotNull Project project, @NotNull String message) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getHyperlinks"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getHyperlinks"));
        }
        String version = UnsupportedGradleVersionErrorHandler.getSupportedGradleVersion(message);
        if (StringUtil.isNotEmpty((String)version)) {
            List<NotificationHyperlink> list = UnsupportedGradleVersionErrorHandler.getQuickFixHyperlinks(project, version);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getHyperlinks"));
            }
            return list;
        }
        List<NotificationHyperlink> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getHyperlinks"));
        }
        return list;
    }

    public void reportUnresolvedDependencies(@NotNull Collection<String> unresolvedDependencies, @NotNull Module module) {
        if (unresolvedDependencies == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "unresolvedDependencies", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependencies"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependencies"));
        }
        if (unresolvedDependencies.isEmpty() || Projects.getSkipSyncIssueReporting(module.getProject())) {
            return;
        }
        VirtualFile buildFile = ProjectSyncMessages.getBuildFile(module);
        for (String dep : unresolvedDependencies) {
            this.reportUnresolvedDependency(dep, module, buildFile);
        }
        Projects.setHasSyncErrors(this.myProject, true);
    }

    @Nullable
    private static VirtualFile getBuildFile(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "getBuildFile"));
        }
        AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
        if (gradleFacet != null && gradleFacet.getGradleModel() != null) {
            GradleModel gradleModel = gradleFacet.getGradleModel();
            return gradleModel.getBuildFile();
        }
        return null;
    }

    private void reportUnresolvedDependency(@NotNull String dependency, @NotNull Module module, @Nullable VirtualFile buildFile) {
        Message msg;
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependency"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportUnresolvedDependency"));
        }
        ArrayList hyperlinks = Lists.newArrayList();
        String group = "Unresolved Android dependencies";
        GradleCoordinate coordinate = GradleCoordinate.parseCoordinateString((String)dependency);
        RepoPackage constraintPackage = null;
        if (coordinate != null) {
            StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
            StudioSdkUtil.reloadRemoteSdkWithModalProgress();
            RepositoryPackages packages = AndroidSdkUtils.tryToChooseSdkHandler().getSdkManager((ProgressIndicator)progress).getPackages();
            constraintPackage = SdkMavenRepository.findBestPackageMatching((GradleCoordinate)coordinate, packages.getRemotePackages().values());
        }
        if (dependency.startsWith("com.android.support.constraint:constraint-layout:") && !ProjectSyncMessages.canGetConstraintLayoutFromSdkManager(module)) {
            hyperlinks.add(new FixAndroidGradlePluginVersionHyperlink(false));
        } else if (constraintPackage != null) {
            hyperlinks.add(new InstallArtifactHyperlink(constraintPackage.getPath()));
        } else if (dependency.startsWith("com.android.support")) {
            hyperlinks.add(new InstallRepositoryHyperlink(SdkMavenRepository.ANDROID));
        } else if (dependency.startsWith("com.google.android")) {
            hyperlinks.add(new InstallRepositoryHyperlink(SdkMavenRepository.GOOGLE));
        } else {
            group = "Unresolved dependencies";
            if (Projects.isOfflineBuildModeEnabled(this.myProject)) {
                NotificationHyperlink disableOfflineModeHyperlink = new NotificationHyperlink("disable.gradle.offline.mode", "Disable offline mode and Sync"){

                    @Override
                    protected void execute(@NotNull Project project) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$1", "execute"));
                        }
                        GradleSettings.getInstance((Project)ProjectSyncMessages.this.myProject).setOfflineWork(false);
                        GradleProjectImporter.getInstance().requestProjectSync(project, null);
                    }
                };
                hyperlinks.add(disableOfflineModeHyperlink);
            }
        }
        String text = "Failed to resolve: " + dependency;
        if (buildFile != null) {
            TextRange textRange;
            int lineNumber = -1;
            int column = -1;
            Document document = FileDocumentManager.getInstance().getDocument(buildFile);
            if (document != null && (textRange = ProjectSyncMessages.findDependency(dependency, document.getText())) != null && (lineNumber = document.getLineNumber(textRange.getStartOffset())) > -1) {
                int lineStartOffset = document.getLineStartOffset(lineNumber);
                column = textRange.getStartOffset() - lineStartOffset;
            }
            msg = new Message(module.getProject(), group, Message.Type.ERROR, buildFile, lineNumber, column, text);
            String hyperlinkText = lineNumber > -1 ? "Show in File" : "Open File";
            hyperlinks.add(new OpenFileHyperlink(buildFile.getPath(), hyperlinkText, lineNumber, column));
        } else {
            msg = new Message(group, Message.Type.ERROR, NonNavigatable.INSTANCE, text);
        }
        if (AndroidStudioInitializer.isAndroidStudio() && coordinate != null) {
            hyperlinks.add(new ShowDependencyInProjectStructureHyperlink(module, coordinate));
        }
        this.add(msg, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
    }

    private static boolean canGetConstraintLayoutFromSdkManager(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "canGetConstraintLayoutFromSdkManager"));
        }
        AndroidGradleModel gradleModel = AndroidGradleModel.get(module);
        if (gradleModel != null) {
            return gradleModel.getFeatures().isConstraintLayoutSdkLocationSupported();
        }
        return false;
    }

    @Nullable
    private static TextRange findDependency(@NotNull String dependency, @NotNull String contents) {
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "findDependency"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "findDependency"));
        }
        return (TextRange)ProjectSyncMessages.findStringLiteral(dependency, contents, pair -> {
            GroovyLexer lexer = (GroovyLexer)pair.getSecond();
            return TextRange.create((int)(lexer.getTokenStart() + 1), (int)(lexer.getTokenEnd() - 1));
        });
    }

    @Nullable
    private static <T> T findStringLiteral(@NotNull String textToSearchPrefix, @NotNull String fileContents, @NotNull Function<Pair<String, GroovyLexer>, T> consumer) {
        if (textToSearchPrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textToSearchPrefix", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "findStringLiteral"));
        }
        if (fileContents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileContents", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "findStringLiteral"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "findStringLiteral"));
        }
        GroovyLexer lexer = new GroovyLexer();
        lexer.start((CharSequence)fileContents);
        while (lexer.getTokenType() != null) {
            String text;
            IElementType type = lexer.getTokenType();
            if (type == GroovyTokenTypes.mSTRING_LITERAL && (text = StringUtil.unquoteString((String)lexer.getTokenText())).startsWith(textToSearchPrefix)) {
                return (T)consumer.fun((Object)Pair.create((Object)text, (Object)lexer));
            }
            lexer.advance();
        }
        return null;
    }

    public void reportDependencySetupErrors() {
        DependencySetupErrors setupErrors = Projects.getDependencySetupErrors(this.myProject);
        if (setupErrors != null) {
            this.reportModulesNotFoundErrors(setupErrors);
            Projects.setDependencySetupErrors(this.myProject, null);
        }
    }

    private void reportModulesNotFoundErrors(@NotNull DependencySetupErrors setupErrors) {
        String msg;
        if (setupErrors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "setupErrors", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportModulesNotFoundErrors"));
        }
        this.reportModulesNotFoundIssues("Missing dependencies between modules", setupErrors.getMissingModules());
        for (String dependent : setupErrors.getMissingNames()) {
            msg = String.format("Module '%1$s' depends on modules that do not have a name.", dependent);
            this.add(new Message("Failed to set up dependencies", Message.Type.ERROR, msg), new NotificationHyperlink[0]);
        }
        for (String dependent : setupErrors.getDependentsOnLibrariesWithoutBinaryPath()) {
            msg = String.format("Module '%1$s' depends on libraries that do not have a 'binary' path.", dependent);
            this.add(new Message("Failed to set up dependencies", Message.Type.ERROR, msg), new NotificationHyperlink[0]);
        }
        for (DependencySetupErrors.InvalidModuleDependency dependency : setupErrors.getInvalidModuleDependencies()) {
            msg = String.format("Ignoring dependency of module '%1$s' on module '%2$s'. %3$s", dependency.dependent, dependency.dependency.getName(), dependency.detail);
            VirtualFile buildFile = ProjectSyncMessages.getBuildFile(dependency.dependency);
            assert (buildFile != null);
            this.add(new Message("Failed to set up dependencies", Message.Type.WARNING, (Navigatable)new OpenFileDescriptor(dependency.dependency.getProject(), buildFile, 0), msg), new NotificationHyperlink[0]);
        }
        this.reportModulesNotFoundIssues("Failed to set up dependencies", setupErrors.getMissingModulesWithBackupLibraries());
    }

    private void reportModulesNotFoundIssues(@NotNull String groupName, @NotNull List<DependencySetupErrors.MissingModule> missingModules) {
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportModulesNotFoundIssues"));
        }
        if (missingModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missingModules", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportModulesNotFoundIssues"));
        }
        if (!missingModules.isEmpty()) {
            boolean hasSelection;
            Message.Type severity = Message.Type.ERROR;
            for (DependencySetupErrors.MissingModule missingModule : missingModules) {
                ArrayList messageLines = Lists.newArrayList();
                StringBuilder text = new StringBuilder();
                text.append(String.format("Unable to find module with Gradle path '%1$s' (needed by module", missingModule.dependencyPath));
                ProjectSyncMessages.addDependentsToText(text, missingModule.dependentNames);
                text.append(".)");
                messageLines.add(text.toString());
                String backupLibraryName = missingModule.backupLibraryName;
                if (StringUtil.isNotEmpty((String)backupLibraryName)) {
                    severity = Message.Type.WARNING;
                    String msg = String.format("Linking to library '%1$s' instead.", backupLibraryName);
                    messageLines.add(msg);
                }
                this.add(new Message(groupName, severity, ArrayUtil.toStringArray((Collection)messageLines)), new NotificationHyperlink[0]);
            }
            ProjectSubset projectSubset = ProjectSubset.getInstance(this.myProject);
            String[] selection = projectSubset.getSelection();
            boolean bl = hasSelection = selection != null && selection.length > 0;
            if (severity == Message.Type.ERROR && hasSelection && projectSubset.hasCachedModules()) {
                String msg = "The missing modules may have been excluded from the project subset.";
                this.add(new Message(groupName, Message.Type.INFO, msg), new IncludeMissingModulesHyperlink(missingModules));
            }
        }
    }

    private static void addDependentsToText(@NotNull StringBuilder text, @NotNull List<String> dependents) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "addDependentsToText"));
        }
        if (dependents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependents", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "addDependentsToText"));
        }
        assert (!dependents.isEmpty());
        if (dependents.size() == 1) {
            text.append(String.format(" '%1$s'", dependents.get(0)));
            return;
        }
        text.append("s: ");
        int i = 0;
        for (String dependent : dependents) {
            if (i++ > 0) {
                text.append(", ");
            }
            text.append(String.format("'%1$s'", dependent));
        }
    }

    private void reportExternalNativeBuildIssues(@NotNull SyncIssue syncIssue, @NotNull Project project) {
        if (syncIssue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "syncIssue", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportExternalNativeBuildIssues"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "reportExternalNativeBuildIssues"));
        }
        assert (syncIssue.getType() == 17);
        String group = "External Native Build Issues";
        String nativeToolOutput = syncIssue.getData();
        if (nativeToolOutput != null) {
            Iterable parsers = JpsServiceManager.getInstance().getExtensions(PatternAwareOutputParser.class);
            List compilerMessages = new BuildOutputParser(parsers).parseGradleOutput(nativeToolOutput);
            for (com.android.ide.common.blame.Message msg : compilerMessages) {
                Message.Type severity = ProjectSyncMessages.translateMessageKind(msg.getKind());
                List sourceFilePositions = msg.getSourceFilePositions();
                assert (!sourceFilePositions.isEmpty());
                VirtualFile sourceFile = null;
                SourceFile source = ((SourceFilePosition)sourceFilePositions.get(0)).getFile();
                if (source.getSourceFile() != null) {
                    sourceFile = VfsUtil.findFileByIoFile((File)source.getSourceFile(), (boolean)true);
                }
                SourcePosition position = ((SourceFilePosition)sourceFilePositions.get(0)).getPosition();
                int line = position.getStartLine();
                int column = position.getStartColumn();
                String text = msg.getText();
                if (severity != Message.Type.ERROR) {
                    Message message = sourceFile != null ? new Message(project, group, severity, sourceFile, line, column, text) : new Message(group, severity, NonNavigatable.INSTANCE, text);
                    this.add(message, new NotificationHyperlink[0]);
                    continue;
                }
                String filePath = sourceFile != null ? sourceFile.getPath() : null;
                NotificationCategory category = NotificationCategory.convert((int)severity.getValue());
                NotificationData notification = new NotificationData(group, text, category, NOTIFICATION_SOURCE, filePath, line, column, false);
                for (AbstractSyncErrorHandler handler : (AbstractSyncErrorHandler[])AbstractSyncErrorHandler.EP_NAME.getExtensions()) {
                    if (handler.handleError((List<String>)ImmutableList.of((Object)text), new ExternalSystemException(text), notification, project)) break;
                }
                this.myNotificationManager.showNotification(GradleUtil.GRADLE_SYSTEM_ID, notification);
            }
        }
        this.add(new Message(group, ProjectSyncMessages.getSeverityType(syncIssue), NonNavigatable.INSTANCE, syncIssue.getMessage()), new NotificationHyperlink[0]);
    }

    private static Message.Type translateMessageKind(@NotNull Message.Kind kind) {
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "translateMessageKind"));
        }
        switch (kind) {
            case ERROR: {
                return Message.Type.ERROR;
            }
            case WARNING: {
                return Message.Type.WARNING;
            }
            case SIMPLE: {
                return Message.Type.SIMPLE;
            }
        }
        return Message.Type.INFO;
    }

    public void add(@NotNull Message message, @NotNull List<NotificationHyperlink> hyperlinks) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        this.add(message, hyperlinks.toArray(new NotificationHyperlink[hyperlinks.size()]));
    }

    public void add(@NotNull Message message, NotificationHyperlink ... hyperlinks) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        if (hyperlinks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hyperlinks", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "add"));
        }
        Navigatable navigatable = message.getNavigatable();
        String title = message.getGroupName();
        String errorMsg = StringUtil.join((String[])message.getText(), (String)"\n");
        VirtualFile file = message.getFile();
        String filePath = file != null ? VfsUtilCore.virtualToIoFile((VirtualFile)file).getPath() : null;
        NotificationCategory category = NotificationCategory.convert((int)message.getType().getValue());
        NotificationData notification = new NotificationData(title, errorMsg, category, NOTIFICATION_SOURCE, filePath, message.getLine(), message.getColumn(), false);
        notification.setNavigatable(navigatable);
        if (hyperlinks.length > 0) {
            AbstractSyncErrorHandler.updateNotification(notification, this.myProject, title, errorMsg, hyperlinks);
        }
        this.myNotificationManager.showNotification(GradleUtil.GRADLE_SYSTEM_ID, notification);
    }

    public void removeMessages(String ... groupNames) {
        if (groupNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupNames", "com/android/tools/idea/gradle/messages/ProjectSyncMessages", "removeMessages"));
        }
        for (String groupName : groupNames) {
            this.myNotificationManager.clearNotifications(groupName, NOTIFICATION_SOURCE, GradleUtil.GRADLE_SYSTEM_ID);
        }
    }

    private static class IncludeMissingModulesHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Set<String> myModuleGradlePaths;

        IncludeMissingModulesHyperlink(@NotNull List<DependencySetupErrors.MissingModule> missingModules) {
            if (missingModules == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "missingModules", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$IncludeMissingModulesHyperlink", "<init>"));
            }
            super("include.missing.modules", "Find and include missing modules");
            this.myModuleGradlePaths = Sets.newHashSetWithExpectedSize((int)missingModules.size());
            for (DependencySetupErrors.MissingModule module : missingModules) {
                this.myModuleGradlePaths.add(module.dependencyPath);
            }
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$IncludeMissingModulesHyperlink", "execute"));
            }
            ProjectSubset.getInstance(project).findAndIncludeModules(this.myModuleGradlePaths);
        }
    }

    private static class InstallArtifactHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final String myPath;

        InstallArtifactHyperlink(@NotNull String path) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallArtifactHyperlink", "<init>"));
            }
            super("install.m2.artifact", "Install artifact and sync project");
            this.myPath = path;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallArtifactHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            requested.add(this.myPath);
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
            if (dialog != null) {
                dialog.setTitle("Install Missing Components");
                if (dialog.showAndGet()) {
                    GradleProjectImporter.getInstance().requestProjectSync(project, null);
                }
            }
        }
    }

    private static class InstallRepositoryHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final SdkMavenRepository myRepository;

        InstallRepositoryHyperlink(@NotNull SdkMavenRepository repository) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "<init>"));
            }
            super("install.m2.repo", "Install Repository and sync project");
            this.myRepository = repository;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$InstallRepositoryHyperlink", "execute"));
            }
            ArrayList requested = Lists.newArrayList();
            requested.add(this.myRepository.getPackageId());
            ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, requested);
            if (dialog != null) {
                dialog.setTitle("Install Missing Components");
                if (dialog.showAndGet()) {
                    GradleProjectImporter.getInstance().requestProjectSync(project, null);
                }
            }
        }
    }

    private static class ShowDependencyInProjectStructureHyperlink
    extends NotificationHyperlink {
        @NotNull
        private final Module myModule;
        @NotNull
        private final GradleCoordinate myDependency;

        ShowDependencyInProjectStructureHyperlink(@NotNull Module module, @NotNull GradleCoordinate dependency) {
            if (module == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$ShowDependencyInProjectStructureHyperlink", "<init>"));
            }
            if (dependency == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$ShowDependencyInProjectStructureHyperlink", "<init>"));
            }
            super("open.dependency.in.project.structure", "Show in Project Structure dialog");
            this.myModule = module;
            this.myDependency = dependency;
        }

        @Override
        protected void execute(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/messages/ProjectSyncMessages$ShowDependencyInProjectStructureHyperlink", "execute"));
            }
            ProjectSettingsService service = ProjectSettingsService.getInstance((Project)project);
            if (service instanceof AndroidProjectSettingsService) {
                ((AndroidProjectSettingsService)service).openAndSelectDependency(this.myModule, this.myDependency);
            }
        }
    }
}

