/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.run;

import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunUtils;
import com.android.tools.idea.gradle.actions.AndroidStudioGradleAction;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.intellij.execution.Executor;
import com.intellij.execution.ProgramRunnerUtil;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.Project;
import icons.AndroidIcons;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReRunAction
extends AndroidStudioGradleAction
implements AnAction.TransparentUpdate {
    public ReRunAction() {
        super("Rerun", "ReRun Selected Configuration", AllIcons.Actions.Restart);
    }

    @Override
    public void doUpdate(@NotNull AnActionEvent e, @NotNull Project project) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/run/ReRunAction", "doUpdate"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/ReRunAction", "doUpdate"));
        }
        Presentation presentation = e.getPresentation();
        boolean cleanBuild = ReRunAction.isCleanBuild(e);
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
        ProcessHandler processHandler = ReRunAction.getActiveProcessHandler(project, settings);
        boolean en = cleanBuild || processHandler != null;
        presentation.setEnabled(en);
        presentation.setIcon(cleanBuild ? AndroidIcons.RunIcons.CleanRerun : AllIcons.Actions.Restart);
        presentation.setText(ReRunAction.getActionText(cleanBuild, settings, processHandler));
    }

    @NotNull
    private static String getActionText(boolean cleanBuild, @Nullable RunnerAndConfigurationSettings settings, @Nullable ProcessHandler processHandler) {
        StringBuilder text = new StringBuilder(30);
        if (cleanBuild) {
            text.append("Clean and ");
        }
        text.append("Rerun");
        if (settings != null && processHandler != null) {
            text.append('\'');
            text.append(settings.getName());
            text.append('\'');
        }
        String string = text.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/run/ReRunAction", "getActionText"));
        }
        return string;
    }

    @Nullable
    private static ProcessHandler getActiveProcessHandler(@Nullable Project project, @Nullable RunnerAndConfigurationSettings settings) {
        if (project == null || settings == null) {
            return null;
        }
        AndroidSessionInfo session = ReRunAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            return null;
        }
        ProcessHandler processHandler = session.getProcessHandler();
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            return null;
        }
        return processHandler;
    }

    @Override
    public void doPerform(@NotNull AnActionEvent e, @NotNull Project project) {
        Executor executor;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/run/ReRunAction", "doPerform"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/run/ReRunAction", "doPerform"));
        }
        RunnerAndConfigurationSettings settings = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
        if (settings == null) {
            InstantRunManager.LOG.warn("Rerun could not locate current run config settings");
            return;
        }
        AndroidSessionInfo session = ReRunAction.getAndroidSessionInfo(project, settings);
        if (session == null) {
            InstantRunManager.LOG.warn("Rerun could not locate an existing session for selected run config.");
        }
        Executor executor2 = executor = session == null ? DefaultRunExecutor.getRunExecutorInstance() : ReRunAction.getExecutor(session.getExecutorId());
        if (executor == null) {
            InstantRunManager.LOG.warn("Rerun could not identify executor for rerun");
            return;
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)executor, (RunnerAndConfigurationSettings)settings);
        if (builder == null) {
            InstantRunManager.LOG.warn("Rerun could not construct an env");
            return;
        }
        ExecutionEnvironment env = builder.activeTarget().dataContext(e.getDataContext()).build();
        InstantRunUtils.setReRun(env, true);
        boolean cleanBuild = ReRunAction.isCleanBuild(e);
        InstantRunUtils.setCleanReRun(env, cleanBuild);
        InstantRunManager.LOG.info("Rerun: clean? " + cleanBuild);
        ProgramRunnerUtil.executeConfiguration((ExecutionEnvironment)env, (boolean)false, (boolean)true);
    }

    @Nullable
    private static AndroidSessionInfo getAndroidSessionInfo(Project project, RunnerAndConfigurationSettings settings) {
        RunConfiguration configuration = settings.getConfiguration();
        if (configuration == null) {
            return null;
        }
        AndroidSessionInfo session = AndroidSessionInfo.findOldSession(project, null, configuration.getUniqueID());
        if (session == null) {
            return null;
        }
        return session;
    }

    @Nullable
    private static Executor getExecutor(@NotNull String executorId) {
        if (executorId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "executorId", "com/android/tools/idea/run/ReRunAction", "getExecutor"));
        }
        for (Executor executor : (Executor[])Executor.EXECUTOR_EXTENSION_NAME.getExtensions()) {
            if (!executorId.equals(executor.getId())) continue;
            return executor;
        }
        return null;
    }

    public boolean isDumbAware() {
        return true;
    }

    private static boolean isCleanBuild(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/run/ReRunAction", "isCleanBuild"));
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace())) {
            return !(e.getInputEvent() instanceof KeyEvent);
        }
        return e.getInputEvent() instanceof MouseEvent && (e.getModifiers() & 1) == 1;
    }
}

