/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.ide.common.rendering.api.ResourceReference;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.StyleResourceValue;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class StyleFilter {
    private final Project myProject;
    private final ResourceResolver myResolver;
    private final Map<String, ResourceValue> myFrameworkStyles;
    private final Map<String, ResourceValue> myProjectStyles;
    private final Set<String> myDerivedStyles;
    private final Set<String> myOtherStyles;
    private final Set<String> myCurrentInheritanceChain;

    public StyleFilter(@NotNull Project project, @NotNull ResourceResolver resolver) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "<init>"));
        }
        this.myProject = project;
        this.myResolver = resolver;
        this.myFrameworkStyles = (Map)resolver.getFrameworkResources().get(ResourceType.STYLE);
        this.myProjectStyles = (Map)resolver.getProjectResources().get(ResourceType.STYLE);
        this.myDerivedStyles = new HashSet<String>();
        this.myOtherStyles = new HashSet<String>();
        this.myCurrentInheritanceChain = new HashSet<String>();
    }

    public static boolean hasWidgetStyles(@NotNull Project project, @NotNull ResourceResolver resolver, @NotNull String tagName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "hasWidgetStyles"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "hasWidgetStyles"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "hasWidgetStyles"));
        }
        return !StyleFilter.getWidgetStyleNames(project, resolver, tagName).isEmpty();
    }

    public Stream<StyleResourceValue> getWidgetStyles(@NotNull String tagName) {
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getWidgetStyles"));
        }
        this.myDerivedStyles.clear();
        this.myOtherStyles.clear();
        this.myDerivedStyles.addAll(StyleFilter.getWidgetStyleNames(this.myProject, this.myResolver, tagName));
        return this.findDerivedStyles();
    }

    @NotNull
    public Stream<StyleResourceValue> getStylesDerivedFrom(@NotNull String baseStyle, boolean isFrameworkStyle) {
        if (baseStyle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseStyle", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getStylesDerivedFrom"));
        }
        this.myDerivedStyles.clear();
        this.myOtherStyles.clear();
        if (isFrameworkStyle) {
            this.myDerivedStyles.add("android:" + baseStyle);
        } else {
            this.myDerivedStyles.add(baseStyle);
        }
        Stream<StyleResourceValue> stream = this.findDerivedStyles();
        if (stream == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getStylesDerivedFrom"));
        }
        return stream;
    }

    private Stream<StyleResourceValue> findDerivedStyles() {
        ArrayList styles = new ArrayList(this.myFrameworkStyles.size() + this.myProjectStyles.size());
        this.myProjectStyles.values().forEach(style -> styles.add((StyleResourceValue)style));
        this.myFrameworkStyles.values().forEach(style -> styles.add((StyleResourceValue)style));
        return styles.stream().filter(this::filter).sorted(Comparator.comparing(ResourceValue::isUserDefined).reversed().thenComparing(ResourceReference::isFramework).thenComparing(ResourceReference::getName));
    }

    boolean filter(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "filter"));
        }
        if (style.getName().startsWith("Base.")) {
            return false;
        }
        if (style.isFramework() && style.getName().toLowerCase(Locale.US).equals(style.getName())) {
            return false;
        }
        this.myCurrentInheritanceChain.clear();
        return this.isDerived(style);
    }

    boolean isDerived(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "isDerived"));
        }
        String styleName = StyleFilter.getStyleName(style);
        if (this.myDerivedStyles.contains(styleName)) {
            return true;
        }
        if (this.myOtherStyles.contains(styleName)) {
            return false;
        }
        StyleResourceValue parentStyle = this.myResolver.getParent(style);
        if (parentStyle != null && !this.myCurrentInheritanceChain.contains(styleName)) {
            this.myCurrentInheritanceChain.add(styleName);
            return this.found(styleName, this.isDerived(parentStyle));
        }
        return this.found(styleName, false);
    }

    @NotNull
    private static String getStyleName(@NotNull StyleResourceValue style) {
        if (style == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "style", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getStyleName"));
        }
        if (style.isFramework()) {
            String string = "android:" + style.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getStyleName"));
            }
            return string;
        }
        String string = style.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getStyleName"));
        }
        return string;
    }

    private boolean found(@NotNull String name, boolean isIncluded) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "found"));
        }
        if (isIncluded) {
            this.myDerivedStyles.add(name);
        } else {
            this.myOtherStyles.add(name);
        }
        return isIncluded;
    }

    @NotNull
    private static List<String> getWidgetStyleNames(@NotNull Project project, @NotNull ResourceResolver resolver, @NotNull String tagName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getWidgetStyleNames"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getWidgetStyleNames"));
        }
        if (tagName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tagName", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getWidgetStyleNames"));
        }
        ViewHandlerManager manager = ViewHandlerManager.get(project);
        ViewHandler handler = manager.getHandler(tagName);
        if (handler == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getWidgetStyleNames"));
            }
            return list;
        }
        List<String> possibleNames = handler.getBaseStyles(tagName);
        Map frameworkStyles = (Map)resolver.getFrameworkResources().get(ResourceType.STYLE);
        Map projectStyles = (Map)resolver.getProjectResources().get(ResourceType.STYLE);
        ArrayList<String> names = new ArrayList<String>(4);
        for (String styleName : possibleNames) {
            if (frameworkStyles.containsKey(styleName)) {
                names.add("android:" + styleName);
            }
            if (!projectStyles.containsKey(styleName)) continue;
            names.add(styleName);
        }
        ArrayList<String> arrayList = names;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/property/editors/StyleFilter", "getWidgetStyleNames"));
        }
        return arrayList;
    }
}

