/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.uibuilder.api.DragType;
import com.android.tools.idea.uibuilder.api.InsertType;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.model.NlComponent;
import com.android.tools.idea.uibuilder.model.NlDropEvent;
import com.android.tools.idea.uibuilder.model.NlModel;
import com.android.tools.idea.uibuilder.structure.NlComponentTree;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.android.utils.Pair;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.Rectangle;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlDropListener
extends DropTargetAdapter {
    private final List<NlComponent> myDragged;
    private final NlComponentTree myTree;
    private DnDTransferItem myTransferItem;
    private NlComponent myDragReceiver;
    private NlComponent myNextDragSibling;

    public NlDropListener(@NotNull NlComponentTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/uibuilder/structure/NlDropListener", "<init>"));
        }
        this.myDragged = new ArrayList<NlComponent>();
        this.myTree = tree;
    }

    @Override
    public void dragEnter(@NotNull DropTargetDragEvent dragEvent) {
        if (dragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragEvent", "com/android/tools/idea/uibuilder/structure/NlDropListener", "dragEnter"));
        }
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.captureDraggedComponents(event, true);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragOver(@NotNull DropTargetDragEvent dragEvent) {
        if (dragEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dragEvent", "com/android/tools/idea/uibuilder/structure/NlDropListener", "dragOver"));
        }
        NlDropEvent event = new NlDropEvent(dragEvent);
        this.updateInsertionPoint(event);
    }

    @Override
    public void dragExit(@NotNull DropTargetEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/structure/NlDropListener", "dragExit"));
        }
        this.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Override
    public void drop(@NotNull DropTargetDropEvent dropEvent) {
        if (dropEvent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dropEvent", "com/android/tools/idea/uibuilder/structure/NlDropListener", "drop"));
        }
        NlDropEvent event = new NlDropEvent(dropEvent);
        InsertType insertType = this.captureDraggedComponents(event, false);
        if (this.findInsertionPoint(event) != null) {
            this.performDrop(dropEvent, insertType);
        }
        this.clearInsertionPoint();
        this.clearDraggedComponents();
    }

    @Nullable
    private InsertType captureDraggedComponents(@NotNull NlDropEvent event, boolean isPreview) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/structure/NlDropListener", "captureDraggedComponents"));
        }
        this.clearDraggedComponents();
        ScreenView screenView = this.myTree.getScreenView();
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        if (event.isDataFlavorSupported(ItemTransferable.DESIGNER_FLAVOR)) {
            try {
                this.myTransferItem = (DnDTransferItem)event.getTransferable().getTransferData(ItemTransferable.DESIGNER_FLAVOR);
                InsertType insertType = this.determineInsertType(event, isPreview);
                if (insertType.isMove()) {
                    this.myDragged.addAll(model.getSelectionModel().getSelection());
                } else {
                    Collection captured = (Collection)ApplicationManager.getApplication().runWriteAction(() -> model.createComponents(screenView, this.myTransferItem, insertType));
                    if (captured != null) {
                        this.myDragged.addAll(captured);
                    }
                }
                return insertType;
            }
            catch (UnsupportedFlavorException | IOException exception) {
                Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            }
        }
        return null;
    }

    @NotNull
    private InsertType determineInsertType(@NotNull NlDropEvent event, boolean isPreview) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/structure/NlDropListener", "determineInsertType"));
        }
        NlModel model = this.myTree.getDesignerModel();
        if (model == null || this.myTransferItem == null) {
            InsertType insertType = InsertType.MOVE_INTO;
            if (insertType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/NlDropListener", "determineInsertType"));
            }
            return insertType;
        }
        DragType dragType = event.getDropAction() == 1 ? DragType.COPY : DragType.MOVE;
        InsertType insertType = model.determineInsertType(dragType, this.myTransferItem, isPreview);
        if (insertType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/NlDropListener", "determineInsertType"));
        }
        return insertType;
    }

    private void clearDraggedComponents() {
        this.myDragged.clear();
    }

    private void updateInsertionPoint(@NotNull NlDropEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/structure/NlDropListener", "updateInsertionPoint"));
        }
        Pair<TreePath, NlComponentTree.InsertionPoint> point = this.findInsertionPoint(event);
        if (point == null) {
            this.clearInsertionPoint();
            event.reject();
        } else {
            this.myTree.markInsertionPoint((TreePath)point.getFirst(), (NlComponentTree.InsertionPoint)((Object)point.getSecond()));
            event.accept(this.determineInsertType(event, true) == InsertType.COPY ? event.getDropAction() : 1);
        }
    }

    @Nullable
    private Pair<TreePath, NlComponentTree.InsertionPoint> findInsertionPoint(@NotNull NlDropEvent event) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/structure/NlDropListener", "findInsertionPoint"));
        }
        this.myDragReceiver = null;
        this.myNextDragSibling = null;
        TreePath path = this.myTree.getClosestPathForLocation(event.getLocation().x, event.getLocation().y);
        if (path == null) {
            return null;
        }
        ScreenView screenView = this.myTree.getScreenView();
        if (screenView == null) {
            return null;
        }
        NlModel model = screenView.getModel();
        NlComponent component = (NlComponent)path.getLastPathComponent();
        if (component == null) {
            return null;
        }
        Rectangle bounds = this.myTree.getPathBounds(path);
        if (bounds == null) {
            return null;
        }
        NlComponentTree.InsertionPoint insertionPoint = NlDropListener.findTreeStateInsertionPoint(event.getLocation().y, bounds);
        ViewHandler handler = component.getViewHandler();
        if (insertionPoint == NlComponentTree.InsertionPoint.INSERT_INTO && handler instanceof ViewGroupHandler) {
            if (!model.canAddComponents(this.myDragged, component, component.getChild(0))) {
                return null;
            }
            this.myDragReceiver = component;
            this.myNextDragSibling = component.getChild(0);
        } else {
            NlComponent parent = component.getParent();
            if (parent == null) {
                return null;
            }
            if (parent.getViewHandler() == null || !model.canAddComponents(this.myDragged, parent, component)) {
                return null;
            }
            insertionPoint = (double)event.getLocation().y > bounds.getCenterY() ? NlComponentTree.InsertionPoint.INSERT_AFTER : NlComponentTree.InsertionPoint.INSERT_BEFORE;
            this.myDragReceiver = parent;
            this.myNextDragSibling = insertionPoint == NlComponentTree.InsertionPoint.INSERT_BEFORE ? component : component.getNextSibling();
        }
        return Pair.of((Object)path, (Object)((Object)insertionPoint));
    }

    @NotNull
    private static NlComponentTree.InsertionPoint findTreeStateInsertionPoint(int y, @NotNull Rectangle bounds) {
        if (bounds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bounds", "com/android/tools/idea/uibuilder/structure/NlDropListener", "findTreeStateInsertionPoint"));
        }
        int delta = bounds.height / 9;
        if (bounds.y + delta > y) {
            NlComponentTree.InsertionPoint insertionPoint = NlComponentTree.InsertionPoint.INSERT_BEFORE;
            if (insertionPoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/NlDropListener", "findTreeStateInsertionPoint"));
            }
            return insertionPoint;
        }
        if (bounds.y + bounds.height - delta < y) {
            NlComponentTree.InsertionPoint insertionPoint = NlComponentTree.InsertionPoint.INSERT_AFTER;
            if (insertionPoint == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/NlDropListener", "findTreeStateInsertionPoint"));
            }
            return insertionPoint;
        }
        NlComponentTree.InsertionPoint insertionPoint = NlComponentTree.InsertionPoint.INSERT_INTO;
        if (insertionPoint == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/uibuilder/structure/NlDropListener", "findTreeStateInsertionPoint"));
        }
        return insertionPoint;
    }

    private void clearInsertionPoint() {
        this.myTree.markInsertionPoint(null, NlComponentTree.InsertionPoint.INSERT_BEFORE);
    }

    private void performDrop(@NotNull DropTargetDropEvent event, InsertType insertType) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/android/tools/idea/uibuilder/structure/NlDropListener", "performDrop"));
        }
        this.myTree.skipNextUpdateDelay();
        NlModel model = this.myTree.getDesignerModel();
        assert (model != null);
        try {
            model.addComponents(this.myDragged, this.myDragReceiver, this.myNextDragSibling, insertType);
            event.acceptDrop(insertType == InsertType.COPY ? event.getDropAction() : 1);
            event.dropComplete(true);
            model.notifyModified(NlModel.ChangeType.DROP);
        }
        catch (Exception exception) {
            Logger.getInstance(NlDropListener.class).warn((Throwable)exception);
            event.rejectDrop();
        }
    }
}

